using System.Diagnostics;
namespace Sansa.Runtime {

    public abstract class AbstractTimer {

        protected IPlatformBridge _bridge; //[g^C}擾pB
        protected ITimerDownstream _handler;
        protected int _sleep; //ƉtickxނB0Ȃ瓮쒆
        protected int _interval; //ԈxBō1APЂƂ2
        protected int _sleepCount;
        protected int _intervalCount; //interval
        protected bool _isActive;
        protected bool _loop;

        public AbstractTimer(IPlatformBridge awt, ITimerDownstream handler) {
            _bridge = awt;
            _handler = handler;
        }
        protected void resetBase(int sleep, int interval, bool loop) { //xoƂ̃Zbg͍l
            Debug.Assert(sleep >= 0);
            Debug.Assert(interval >= 1);
            _sleep = sleep;
            _interval = interval;
            _sleepCount = _sleep;
            _loop = loop;

            _intervalCount = 1;
        }

        public bool IsActive() {
            return _isActive;
        }
        public bool IsSleeping() {
            return _sleepCount>0;
        }
        public bool IsAlive() {
            return _isActive || IsSleeping();
        }
        public bool IsDead() {
            return !IsAlive();
        }

        //Jn
        public void Initialize() {
            _handler.oninitialize();
            _bridge.getRootTimer().addTimer(this);

            if(_sleep==0)
                fireStart();
        }
        //IlɃWvƂƂtick߂
        public void Abort() {

            if(!_isActive) return;
            _sleepCount = 0;
            stepToLast();
            _handler.ontick();
            _isActive = false;
            fireEnd();
            _intervalCount = _interval;
        }

        //RootTimerĂ΂
        public void tick() {
            if(_sleepCount > 0) {
                if(--_sleepCount==0) fireStart();
                return;
            }

            if(--_intervalCount > 0) return;

            bool finished = stepValue();
            if(_loop) {
                if(finished) stepToFirst(); //I[ɂǂƓɏl֖߂
                _handler.ontick();
            }
            else {
                _isActive = !finished; //tickƂactive͔fĂ
                _handler.ontick();
                if(!_isActive) fireEnd();
            }
            _intervalCount = _interval;
        }

        //̒l܂Ői߂BI[trueԂ
        protected abstract bool stepValue();
        //ŏ/ŏI̒l܂Ői߂
        protected abstract void stepToFirst();
        protected abstract void stepToLast();

        private void fireStart() {
            _isActive = true;
            _handler.onstart();
            _handler.ontick();
            _intervalCount = _interval;
        }

        private void fireEnd() {
            _handler.onend();
            _bridge.getRootTimer().removeTimer(this);
        }

    }

}