/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

/**
 * nulll߂MappvpeB|C^gNXB
 * 
 * <p>ftHgMapvpeB|C^ł́A
 * Map̒lnullĂꍇAlȂ̂ƂĈB
 * null擾ꍇA{NXgpKvB</p>
 * 
 */
public class DynamicPropertyPointerEx extends DynamicPropertyPointer {

	/**
	 * VAo[WIDB
	 */
	private static final long serialVersionUID = -2235777024563491060L;

	/**
     * RXgN^B
     * @param parent eMapp|C^
     * @param handler vpeBnh
     */
    public DynamicPropertyPointerEx(NodePointer parent,
            DynamicPropertyHandler handler) {
        super(parent, handler);
    }

    /**
     * vf擾B
     * @return vf
     */
    @Override
    public int getLength() {
        // vf̒lnullȂ΁AvfPƂ
        Object value = getBaseValue();
        if (value == null) {
            return 1;
        }
        return ValueUtils.getLength(value);
    }
}
