/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.lang.reflect.InvocationTargetException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.AbstractBLogicMapper} NX
 * ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏񔽉fۃNXB<br>
 * BLogicIOPlugInɂĐꂽBLogicResourcesƂɁA
 * Webw̃IuWFNgƁArWlXWbNԂ̃f[^̃}bsOs@\
 * W񂵂ۃNXłB<br>
 * <br>
 * OF<br>
 * ۃNXAbstractBLogicMappereXgpNX쐬A
 * eeXgP[X̑Oɂ郁\bh邱ƁB
 * <p>
 *
 * @see jp.terasoluna.fw.service.thin.AbstractBLogicMapper
 */
@SuppressWarnings("unused")
public class AbstractBLogicMapperTest extends TestCase {

    private static final String TESTBEAN01_NAME = "jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01";

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractBLogicMapperTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public AbstractBLogicMapperTest(String name) {
        super(name);
    }

    /**
     * testMapBLogicParams01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:null<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:|<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:}bsO`Ȃ<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * BLogicIOnullœnꂽAnullԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams01() throws Exception {

        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = null;

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{E
        assertNull(mapper.mapBLogicParams(request, response, io));
    }

    /**
     * testMapBLogicParams02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not nulliio.getBLogicParams().size() == 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:`Ȃ<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:}bsO`Ȃ<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * }bsO`iblogic-paramsjLqĂȂAnullԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams02() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{E
        assertNull(mapper.mapBLogicParams(request, response, io));

    }

    /**
     * testMapBLogicParams03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:݂ȂJavaBean<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:requestF<br>
     *                 "requestValue""blogicRequestValue"<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.create"<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "bean creation failure."<br>
     *
     * <br>
     * inputBeanNameɑ݂ȂJavaBean`ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams03() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName("nothingClass");
        BLogicProperty property = new BLogicProperty();
        property.setSource("request");
        property.setProperty("requestValue");
        property.setBLogicProperty("blogicRequestValue");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.create", e.getErrorCode());
            assertEquals(ClassLoadException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("bean creation failure."));
        }
    }

    /**
     * testMapBLogicParams04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():propName+"_FromForm"ԋp<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:formF<br>
     *                 "userName""blogicUserName"<br>
     *
     * <br>
     * ҒlF(߂l) Object:[blogicUserName="userName_FromForm"]<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * property̎w肪1̏ꍇA擾ɑΉ͒l擾\bhĂяoAƖWbN̓͏BeañtB[hɃ}bsO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams04() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("form");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{E
        AbstractBLogicMapper_BeanStub01 result = (AbstractBLogicMapper_BeanStub01) mapper
                .mapBLogicParams(request, response, io);
        assertEquals("userName_FromForm", result.getBlogicUserName());

    }

    /**
     * testMapBLogicParams05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():propName+"_FromForm"ԋp<br>
     *         () getValueFromRequest():propName+"_FromRequest"ԋp<br>
     *         () getValueFromSession():propName+"_FromSession"ԋp<br>
     *         () getValueFromApplication():propName+"_FromApplication"ԋp<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:formF<br>
     *                 "userName""blogicUserName"<br>
     *                requestF<br>
     *                 "requestValue""blogicRequestValue"<br>
     *                sessionF<br>
     *                 "sessionValue""blogicSessionValue"<br>
     *                applicationF<br>
     *                 "applicationValue""blogicApplicationValue"<br>
     *
     * <br>
     * ҒlF(߂l) Object:[blogicUserName="userName_FromForm"]<br>
     *                  [blogicRequestValue="rrequestValue_FromRequest"]<br>
     *                  [blogicSessionValue="sessionValue_FromSession"]<br>
     *                  [blogicApplicationValue="applicationValue_FromApplication"]<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * property̎w肪̏ꍇA擾ɑΉ͒l擾\bhĂяoAƖWbN̓͏BeañtB[hɃ}bsO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams05() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("form");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);
        BLogicProperty property2 = new BLogicProperty();
        property2.setSource("request");
        property2.setProperty("requestValue");
        property2.setBLogicProperty("blogicRequestValue");
        io.setBLogicParam(property2);
        BLogicProperty property3 = new BLogicProperty();
        property3.setSource("session");
        property3.setProperty("sessionValue");
        property3.setBLogicProperty("blogicSessionValue");
        io.setBLogicParam(property3);
        BLogicProperty property4 = new BLogicProperty();
        property4.setSource("application");
        property4.setProperty("applicationValue");
        property4.setBLogicProperty("blogicApplicationValue");
        io.setBLogicParam(property4);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{E
        AbstractBLogicMapper_BeanStub01 result = (AbstractBLogicMapper_BeanStub01) mapper
                .mapBLogicParams(request, response, io);
        assertEquals("userName_FromForm", result.getBlogicUserName());
        assertEquals("requestValue_FromRequest", result.getBlogicRequestValue());
        assertEquals("sessionValue_FromSession", result.getBlogicSessionValue());
        assertEquals("applicationValue_FromApplication", result.getBlogicApplicationValue());
    }

    /**
     * testMapBLogicParams06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():propName+"_FromForm"ԋp<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:formF<br>
     *                 "userName"wȂ<br>
     *
     * <br>
     * ҒlF(߂l) Object:[userName="userName_FromForm"]<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * ƖWbNL[w肳ĂȂꍇA͏Beañ}bsÕtB[h͎擾̃L[ƂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams06() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("form");
        property.setProperty("userName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{E
        AbstractBLogicMapper_BeanStub01 result = (AbstractBLogicMapper_BeanStub01) mapper
                .mapBLogicParams(request, response, io);
        assertEquals("userName_FromForm", result.getUserName());
    }

    /**
     * testMapBLogicParams07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():propName+"_FromForm"ԋp<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:page:<br>
     *                 "userName"  "blogicUserName"<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.getvalue"<br>
     *                    uPF<br>
     *                    "userName"<br>
     *                    bvOFBLogicMapperException(NoSuchMethodException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "no such method."<br>
     *
     * <br>
     * 擾ɑz肵Ȃw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams07() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        // 擾ɑzO̕ݒ
        property.setSource("page");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.getvalue", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertEquals("userName", e.getOptions()[0]);
            // NoSuchMethodExceptioñ`FbN
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("no such method."));
        }

    }

    /**
     * testMapBLogicParams08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():Exception<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:errorF<br>
     *                 "userName""blogicUserName"<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.getvalue"<br>
     *                    uPF<br>
     *                    "userName"<br>
     *                    bvOFBLogicMapperException(InvocationTargetException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "exception is thrown out by invokeMethod."<br>
     *
     * <br>
     * tNVŎs郁\bhőzO̗OASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams08() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("error");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.getvalue", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertEquals("userName", e.getOptions()[0]);
            // InvocationTargetExceptioñ`FbN
            assertEquals(InvocationTargetException.class.getName(), e
                    .getCause().getCause().getClass().getName());
            assertTrue(LogUTUtil
                    .checkError("exception is thrown out by invokeMethod."));
        }

    }

    /**
     * testMapBLogicParams09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():propName+"_FromForm"ԋp<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:formF<br>
     *                 "userName""nothing"i݂ȂtB[hj<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.setproperty"<br>
     *                    uPF<br>
     *                    "nothing"<br>
     *                    bvOFBLogicMapperException(PropertyAccessException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "setBeanProperty failure."<br>
     *
     * <br>
     * ƖWbNL[œ͏Beanɑ݂ȂtB[hw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams09() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("form");
        property.setProperty("userName");
        property.setBLogicProperty("nothing");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.setproperty", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertEquals("nothing", e.getOptions()[0]);
            // PropertyAccessExceptioñ`FbN
            assertEquals(PropertyAccessException.class.getName(), e.getCause()
                    .getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("setBeanProperty failure."));
        }
    }

    /**
     * testMapBLogicParams10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:""i󕶎jF<br>
     *                 "userName"  "blogicUserName"<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.source"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "source is illegal."<br>
     *
     * <br>
     * 擾""i󕶎jw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams10() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource("");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.source", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("source is illegal."));
        }
    }

    /**
     * testMapBLogicParams11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:nullF<br>
     *                 "userName"  "blogicUserName"<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.source"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "source is illegal."<br>
     *
     * <br>
     * 擾nullw肵ASystemException邱ƁBi{肦Ȃj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams11() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);
        BLogicProperty property = new BLogicProperty();
        property.setSource(null);
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            Object result = mapper.mapBLogicParams(request, response, io);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.source", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("source is illegal."));
        }
    }

    /**
     * testMapBLogicParams12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:null<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:requestF<br>
     *                 "requestValue""blogicRequestValue"<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * inputBeanNamenull̂ƂAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams12() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(null);
        BLogicProperty property = new BLogicProperty();
        property.setSource("request");
        property.setProperty("requestValue");
        property.setBLogicProperty("blogicRequestValue");
        io.setBLogicParam(property);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        assertNull(mapper.mapBLogicParams(request, response, io));
    }

    /**
     * testMapBLogicParams13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicParams().size()  > 0j<br>
     *         () getValueFromForm():|<br>
     *         () getValueFromRequest():|<br>
     *         () getValueFromSession():|<br>
     *         () getValueFromError():|<br>
     *         () inputBeanName:"jp.terasoluna.fw.service.thin.AbstractBLogicMapper_BeanStub01"<br>
     *         () property(擾F擾̃L[  ƖWbNL[j:}bsO`ȂB<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *
     * <br>
     * blogic-iopropertyw肪ȂꍇA͒lNXȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicParams13() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        io.setInputBeanName(TESTBEAN01_NAME);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        assertNull(mapper.mapBLogicParams(request, response, io));
    }

    /**
     * testMapBLogicResult01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *         () result:null<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:|<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.result"<br>
     *                    bvOFBLogicMapperException(NullPointerException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "result is null."<br>
     *         (ԕω) request:[<br>
     *
     * <br>
     * BLogicResultnullœnꂽASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult01() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();

        // BLogicResultݒ
        BLogicResult result = null;

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.result", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            // NullPointerExceptioñ`FbN
            assertEquals(NullPointerException.class.getName(), e.getCause()
                    .getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("BLogicResult is null."));
        }
    }

    /**
     * testMapBLogicResult02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:null<br>
     *         () result:not nulliresult.getResultObject()==nullj<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:|<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:Ȃ<br>
     *
     * <br>
     * BlogicIOnullAAresultresultObjectnull̎AɏI邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult02() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = null;

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        result.setResultObject(null);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        mapper.mapBLogicResult(request, response, io, result);

        // 
        assertFalse(request.getAttributeNames().hasMoreElements());
    }

    /**
     * testMapBLogicResult03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:null<br>
     *         () result:not nulliresult.getResultObject()!=nullj<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:|<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.notnull"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "bean is not null."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * BlogicIOnullAAresultresultObjectnullłȂASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult03() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = null;

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        result.setResultObject("not null");

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.notnull", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("bean is not null."));
        }
    }

    /**
     * testMapBLogicResult04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not nulliio.getBLogicResults().size() == 0j<br>
     *         () result:not nulliresult.getResultObject()==nullj<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:}bsO`Ȃ<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:Ȃ<br>
     *
     * <br>
     * }bsO`iblogic-resultsjLqĂ炸AAresultresultObjectnull̎AɏI邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult04() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        result.setResultObject(null);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        mapper.mapBLogicResult(request, response, io, result);

        // 
        assertFalse(request.getAttributeNames().hasMoreElements());
    }

    /**
     * testMapBLogicResult05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not nulliio.getBLogicResults().size() == 0j<br>
     *         () result:not nulliresult.getResultObject()!=nullj<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:}bsO`Ȃ<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.notnull"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "bean is not null."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * }bsO`iblogic-resultsjLqĂ炸AAresultresultObjectnullłȂASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult05() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        result.setResultObject("not null");

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.notnull", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("bean is not null."));
        }
    }

    /**
     * testMapBLogicResult06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:not null<br>
     *                iresult.getResultObject()!=nullj<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:formF<br>
     *                "nothing"i݂ȂtB[hj "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.getproperty"<br>
     *                    uPF<br>
     *                    "nothing"<br>
     *                    bvOFBLogicMapperException(PropertyAccessException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "getBeanProperty failure."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * ƖWbNL[ŏo͏Beanɑ݂ȂtB[hw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult06() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("form");
        property.setProperty("userName");
        property.setBLogicProperty("nothing");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.getproperty", e.getErrorCode());
            assertEquals("nothing", e.getOptions()[0]);
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            // PropertyAccessExceptioñ`FbN
            assertEquals(PropertyAccessException.class.getName(), e.getCause()
                    .getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("getBeanProperty failure."));
        }
    }

    /**
     * testMapBLogicResult07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:result.getResultObject() [blogicUserName="ꑾY"]<br>
     *         () setValueToForm():requestɁufL[+"_ToForm"vL[Ɉvalueݒ<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:formF<br>
     *                "blogicUserName" "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:[userName_ToForm="ꑾY"]<br>
     *
     * <br>
     * property̎w肪1̏ꍇAfɑΉo͒lf\bhĂяoAf̃tB[hɃ}bsO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult07() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("form");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        bean.setBlogicUserName("ꑾY");
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        mapper.mapBLogicResult(request, response, io, result);

        // 
        assertEquals("ꑾY", request.getAttribute("userName_ToForm"));
    }

    /**
     * testMapBLogicResult08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:result.getResultObject() [blogicUserName="ꑾY"AblogicRequestValue="requestValueAblogicSessionValue="sessionValue"]<br>
     *         () setValueToForm():requestɁufL[+"_ToForm"vL[Ɉvalueݒ<br>
     *         () setValueToRequest():requestɁufL[+"_ToRequest"vL[Ɉvalueݒ<br>
     *         () setValueToSession():requestɁufL[+"_ToSession"vL[Ɉvalueݒ<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:formF<br>
     *                "blogicUserName" "userName"<br>
     *                requestF<br>
     *                "blogicRequestValue" "requestValue"<br>
     *                sessionF<br>
     *                "blogicSessionValue" "sessionValue"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:[userName_ToForm="ꑾY"]<br>
     *                    [requestValue_ToRequest="requestValue"]<br>
     *                    [sessionValue_ToSession="sessionValue"]<br>
     *
     * <br>
     * property̎w肪̏ꍇAfɑΉo͒lf\bhĂяoAf̃tB[hɃ}bsO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult08() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("form");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);
        BLogicProperty property2 = new BLogicProperty();
        property2.setDest("request");
        property2.setProperty("requestValue");
        property2.setBLogicProperty("blogicRequestValue");
        io.setBLogicResult(property2);
        BLogicProperty property3 = new BLogicProperty();
        property3.setDest("session");
        property3.setProperty("sessionValue");
        property3.setBLogicProperty("blogicSessionValue");
        io.setBLogicResult(property3);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        bean.setBlogicUserName("ꑾY");
        bean.setBlogicRequestValue("requestValue");
        bean.setBlogicSessionValue("sessionValue");
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        mapper.mapBLogicResult(request, response, io, result);

        // 
        assertEquals("ꑾY", request.getAttribute("userName_ToForm"));
        assertEquals("requestValue", request
                .getAttribute("requestValue_ToRequest"));
        assertEquals("sessionValue", request
                .getAttribute("sessionValue_ToSession"));
    }

    /**
     * testMapBLogicResult09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:result.getResultObject() [userName="ꑾY"AblogicUserName=null]<br>
     *         () setValueToForm():requestɁufL[+"_ToForm"vL[Ɉvalueݒ<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:formF<br>
     *                wȂ "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:[userName_ToForm="ꑾY"]<br>
     *
     * <br>
     * ƖWbNL[w肳ĂȂꍇAflƂĎ擾tB[h̖O͔f̃L[ƓɂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult09() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("form");
        property.setProperty("userName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        bean.setUserName("ꑾY");
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        mapper.mapBLogicResult(request, response, io, result);

        // 
        assertEquals("ꑾY", request.getAttribute("userName_ToForm"));
    }

    /**
     * testMapBLogicResult10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:not null<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:page:<br>
     *                  "blogicUserName""userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.setvalue"<br>
     *                    uPF<br>
     *                    "userName"<br>
     *                    bvOFBLogicMapperException(NoSuchMethodException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "no such method."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * fɑz肵Ȃw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult10() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        // 擾ɑzO̕ݒ
        property.setDest("page");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.setvalue", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertEquals("userName", e.getOptions()[0]);
            // NoSuchMethodExceptioñ`FbN
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("no such method."));
        }
    }

    /**
     * testMapBLogicResult11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:not null<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():Exception<br>
     *         () property(擾FƖWbNL[  f̃L[j:errorF<br>
     *                "blogicUserName" "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.setvalue"<br>
     *                    uPF<br>
     *                    "userName"<br>
     *                    bvOFBLogicMapperException(InvocationTargetException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "exception is thrown out by invokeMethod."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * tNVŎs郁\bhőzO̗OASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult11() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("error");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.setvalue", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertEquals("userName", e.getOptions()[0]);
            // InvocationTargetExceptioñ`FbN
            assertEquals(InvocationTargetException.class.getName(), e
                    .getCause().getCause().getClass().getName());
            assertTrue(LogUTUtil
                    .checkError("exception is thrown out by invokeMethod."));
        }
    }

    /**
     * testMapBLogicResult12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:not null<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:""i󕶎jF<br>
     *                 "blogicUserName" "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.dest"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "dest is illegal."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * f""i󕶎jw肵ASystemException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult12() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest("");
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.dest", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("dest is illegal."));
        }
    }

    /**
     * testMapBLogicResult13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () io:not null<br>
     *                iio.getBLogicResults().size() > 0j<br>
     *         () result:not null<br>
     *         () setValueToForm():|<br>
     *         () setValueToRequest():|<br>
     *         () setValueToSession():|<br>
     *         () setValueToError():|<br>
     *         () property(擾FƖWbNL[  f̃L[j:nullF<br>
     *                 "blogicUserName" "userName"<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.blogic.mapper.dest"<br>
     *                    bvOFBLogicMapperException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "dest is illegal."<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * fnullw肵ASystemException邱ƁBi{肦Ȃj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMapBLogicResult13() throws Exception {
        // [NGXg
        HttpServletRequest request = new MockHttpServletRequest();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BlogicIOݒ
        BLogicIO io = new BLogicIO();
        BLogicProperty property = new BLogicProperty();
        property.setDest(null);
        property.setProperty("userName");
        property.setBLogicProperty("blogicUserName");
        io.setBLogicResult(property);

        // BLogicResultݒ
        BLogicResult result = new BLogicResult();
        AbstractBLogicMapper_BeanStub01 bean = new AbstractBLogicMapper_BeanStub01();
        result.setResultObject(bean);

        // AbstractBLogicMapperImpl
        AbstractBLogicMapperImpl01 mapper = new AbstractBLogicMapperImpl01();

        // eXg{
        try {
            mapper.mapBLogicResult(request, response, io, result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.blogic.mapper.dest", e.getErrorCode());
            assertEquals(BLogicMapperException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("dest is illegal."));
        }
    }

}
