/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * IfNotErrorsTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class IfNotErrorsTagTest extends TestCase {

    // eXgΏ
    IfNotErrorsTag tag = null;

    /**
     * Constructor for IfNotErrorsTagTest.
     * @param arg0
     */
    public IfNotErrorsTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (IfNotErrorsTag) TagUTUtil.create(IfNotErrorsTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * errors=Not Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=SKIP_BODY<br>
     * <br>
     * NGXg擾G[Nullł͂Ȃꍇ̃eXgP[X<br>
     */
    public void testDoStartTag01() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        ServletRequest rq = pc.getRequest();
        ActionMessages errors = new ActionMessages();
        errors.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(""));
        rq.setAttribute(Globals.ERROR_KEY, errors);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag01 End */

    /**
     * testDoStartTag02B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * errors=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * <br>
     * NGXg擾G[Null̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag02() throws Exception {

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

    } /* testDoStartTag02 End */

    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * Ȃ<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * 
     * EVAL_PAGEԋp邱ƂmF<br>
     */
    public void testDoEndTag01() throws Exception {
        // eXgs
        int result = tag.doEndTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    }

} /* IfNotErrorsTagTest Class End */
