/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.util.ArrayList;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.SpringTestCase;

import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.MockServletConfig;

/**
 * {@link jp.terasoluna.fw.web.taglib.DefineCodeListTag}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * defineCodeList ^O̎NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 */
@SuppressWarnings("unused")
public class DefineCodeListTagTest extends SpringTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefineCodeListTagTest.class);
    }

	@Override
	protected void doOnSetUp() throws Exception {
	}

	@Override
	protected String[] getConfigLocations() {
		return new String[]{
           "jp/terasoluna/fw/web/taglib/DefineCodeListTagTest.xml"};
	}


    /**
     * testDoStartTag01()
     * <br><br>
     * 
     * (ُn)<br>
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() id:""<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspTagException<br>
     *                    bvOFnull<br>
     *                    bZ[WFid is required.<br>
     *         (ԕω) O:OxFerror<br>
     *                    bZ[WFid is required.<br>
     *         
     * <br>
     * CX^Xϐid󕶎̏ꍇA
     * JspTagException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag01() throws Exception {
		// O
    	DefineCodeListTag tag
		    = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
		
		// id""ꍇ
		UTUtil.setPrivateField(tag,"id","");
		
		try {
			// eXgs
			int result = tag.doStartTag();
			// 
			fail();
		} catch (JspTagException ex) {
			// 
			// bZ[W`FbN
			assertEquals("id is required.", ex.getMessage());
			// bvO`FbN
			assertNull(ex.getCause());
			// O`FbN
			assertTrue(LogUTUtil.checkError("id is required."));
		}
    }

    /**
     * testDoStartTag02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader02<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans=null<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) pageContext:pageXR[v<br>
     *                    "testLoader02"=ArrayListݒ肳邱<br>
     *         (ԕω) O:OxFwarn<br>
     *                    bZ[WF
     *             "Codebean is null. CodeListLoader(bean id:testLoader02)"<br>
     *         
     * <br>
     * DIRei擾CodeListLoadergetCodeBeansnullԋpꍇA
     * pageXR[vɎw肳ꂽidL[ƂċArrayList
     * ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag02() throws Exception {
		// O
    	DefineCodeListTag tag
		  = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);
        
        // getCodeBeans=null
		UTUtil.setPrivateField(tag,"id","testLoader02");

		// eXgs
		int result = tag.doStartTag();
		
		// 
		// ߂l
		assertEquals(Tag.EVAL_BODY_INCLUDE,result);
		// O`FbN
		assertTrue(LogUTUtil.checkWarn(
                "Codebean is null. CodeListLoader(bean id:testLoader02)"));
		// pageXR[v"testLoader02"ɋArrayListݒ肳邱
		ArrayList codeArrayList
            = (ArrayList)pageContext.getAttribute("testLoader02");
		assertEquals(0,codeArrayList.size());	
    }

    /**
     * testDoStartTag03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader03<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={}i̔zj<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) pageContext:pageXR[v<br>
     *                    "testLoader03"=CodeBeanz񂪐ݒ肳邱<br>
     *         
     * <br>
     * DIRei擾CodeListLoadergetCodeBeans̔z
     * ԋpꍇApageXR[vɎw肳ꂽidL[Ƃċ
     * CodeBeanz񂪐ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag03() throws Exception {
		// O
    	DefineCodeListTag tag
		    = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);
		// getCodeBeans={}i̔zj
		UTUtil.setPrivateField(tag, "id", "testLoader03");

		// eXgs
		int result = tag.doStartTag();
		
		// 
		// ߂l
		assertEquals(Tag.EVAL_BODY_INCLUDE, result);
		// pageXR[v"testLoader"=CodeBeanz񂪐ݒ肳邱
		CodeBean[] codeBeans
            = (CodeBean[])pageContext.getAttribute("testLoader03");
		assertEquals(0,codeBeans.length);	
    }

    /**
     * testDoStartTag04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader04<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={<br>
     *                CodeBean("id","name")<br>
     *                }<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) pageContext:pageXR[v<br>
     *                    "testLoader04"=CodeBeanz<br>
     *                    {CodeBean("id", "name")}i1j<br>
     *                    ݒ肳邱<br>
     *         
     * <br>
     * DIRei擾CodeListLoadergetCodeBeansvf1̔z
     * ԋpꍇApageXR[vɎw肳ꂽid
     * L[ƂĎ擾CodeBeanz񂪐ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag04() throws Exception {
		// O
    	DefineCodeListTag tag
            = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);
        
        // getCodeBeans={CodeBean("id","name") }
		UTUtil.setPrivateField(tag,"id","testLoader04");

		// eXgs
		int result = tag.doStartTag();
		
		// 
		// ߂l
		assertEquals(Tag.EVAL_BODY_INCLUDE, result);

        //pageXR[v"testLoader"=CodeBeanz񂪐ݒ肳邱ƂmF
		CodeBean[] codeBeans
            = (CodeBean[]) pageContext	.getAttribute("testLoader04");
		assertEquals(1, codeBeans.length);
		CodeBean codeBean = codeBeans[0];
		assertEquals("id", codeBean.getId());
		assertEquals("name", codeBean.getName());
		
    }

    /**
     * testDoStartTag05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:testLoader05<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                getCodeBeans={<br>
     *                CodeBean("id1","name1"),<br>
     *                CodeBean("id2","name2"),<br>
     *                CodeBean("id3","name3"),<br>
     *                }<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_BODY_INCLUDE<br>
     *         (ԕω) pageContext:pageXR[v<br>
     *                    "testLoader05"=CodeBeanz<br>
     *                    {<br>
     *                    CodeBean("id1","name1"),<br>
     *                    CodeBean("id2","name2"),<br>
     *                    CodeBean("id3","name3"),<br>
     *                    }i3j<br>
     *                    ݒ肳邱<br>
     *         
     * <br>
     * DIRei擾CodeListLoadergetCodeBeans̗vf̔z
     * ԋpꍇApageXR[vɎw肳ꂽidL[Ƃ
     * 擾CodeBeanz񂪐ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag05() throws Exception {
		// O
    	DefineCodeListTag tag
            = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

        //getCodeBeans={
        //  CodeBean("id1","name1"),
        //  CodeBean("id2","name2"),
        //  CodeBean("id3","name3"),
        //}
		UTUtil.setPrivateField(tag,"id","testLoader05");

		// eXgs
		int result = tag.doStartTag();

		// 
		// ߂l
		assertEquals(Tag.EVAL_BODY_INCLUDE, result);
		
        //pageXR[v"testLoader"=CodeBeanz񂪐ݒ肳邱ƂmF
		CodeBean[] codeBeans
            = (CodeBean[])pageContext.getAttribute("testLoader05");
		assertEquals(3,codeBeans.length);
		for (int i = 0; i < codeBeans.length; i++) {
			CodeBean codeBean = codeBeans[i];
			assertEquals("id" + (i + 1), codeBean.getId());
			assertEquals("name" + (i + 1), codeBean.getName());
		}
    }

    /**
     * testDoStartTag06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() id:testLoader06<br>
     *         () WebApplicationContext.getBean(id)<br>
     *                iCodeListLoaderj:not null<br>
     *                CodeListLoaderȂNX̃CX^XB<br>
     *         () out.print:s<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspTagException<br>
     *                    bvOFClassCastException<br>
     *                    bZ[WF
     *                bean id:testLoader06 is not instance of CodeListLoader<br>
     *         (ԕω) O:OxFerror<br>
     *                    bZ[WF
     *                bean id:testLoader06 is not instance of CodeListLoader<br>
     *         
     * <br>
     * DIRei擾CX^XCodeListLoaderNX
     * CX^Xł͂ȂꍇAJspTagException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag06() throws Exception {
		// O
    	DefineCodeListTag tag
		  = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);

        MockPageContext pageContext =
        	(MockPageContext) TagUTUtil.getPageContext(tag);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(pageContext, "config", config);

		// CodeListLoaderȂNX̃CX^XB
		UTUtil.setPrivateField(tag, "id", "testLoader06");
		try {
			// eXgs
			int result = tag.doStartTag();
			fail();
		} catch (JspTagException ex) {
			// 
			// bvO`FbN
			assertEquals(ClassCastException.class.getName(),
					ex.getRootCause().getClass().getName());
			// bZ[WL[`FbN
			assertEquals(
					"bean id:testLoader06 is not instance of CodeListLoader.",
					ex.getMessage());
			// O`FbN
			assertTrue(LogUTUtil.checkError(
                    "bean id:testLoader06 is not instance of CodeListLoader."));
		}
    }

    /**
     * testDoEndTag01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_PAGE<br>
     *         
     * <br>
     * TagSupport.EVAL_PAGEԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoEndTag01() throws Exception {
		// O
    	DefineCodeListTag tag
		  = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);

		// eXg{
        int result = tag.doEndTag();

        // eXgʊmF
		assertEquals(Tag.EVAL_PAGE, result);
    }

    /**
     * testRelease01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() id:"id"<br>
     *         
     * <br>
     * ҒlF(ԕω) id:null<br>
     *         
     * <br>
     * idnullɂȂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRelease01() throws Exception {
		// O
    	DefineCodeListTag tag
		  = (DefineCodeListTag) TagUTUtil.create(DefineCodeListTag.class);
        UTUtil.setPrivateField(tag, "id", "id");

		// eXg{
        tag.release();

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "id"));
    }
}
