/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.partition;

import jp.terasoluna.fw.batch.core.JobManager;
import jp.terasoluna.fw.batch.core.JobStatus;

/**
 * <p>WuɂāAqWu𑽏dxPŒs邽߂̃Wu}l[W
 * BsĂqWûǂꂩrŏIꍇɁAc̎qWu
 * sɃWu~B</p>
 * 
 * <p>ƏIɁÃWu}l[W̃WuXe[^XIԂłƂ
 * ẽWuXe[^X̃WuƓWuXe[^XɍXVB</p>
 * 
 */
public class SequentialChildJobManager extends JobManager {

    /**
     * ƏIsB
     * 
     * @param parentJobStatus ÑWuXe[^X
     * @param jobStatus ̃Wu}l[W̃WuXe[^X
     */
    @Override
    protected void finishWork(
            JobStatus parentJobStatus, JobStatus jobStatus) {
        if (jobStatus.isExecuting() || jobStatus.isShutdownGraceful()
                || jobStatus.isShutdownImmediate()) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        } else {
            parentJobStatus.setJobState(jobStatus.getJobState());
        }
    }

}
