/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import junit.framework.TestCase;

/**
 * HashUtilubN{bNXeXg<br>
 * 
 * (O)<br>
 * EƂɂȂ<br>
 * 
 */
public class HashUtilTest extends TestCase {

    /**
     * Constructor for HashUtilTest.
     * @param arg0 eXgP[X̃\bh
     */
    public HashUtilTest(String arg0) {
        super(arg0);
    }

    /**
     * @see TestCase#setUp()
     * @throws Exception eXgR[h̖{Ƃ̖O
     * 
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * @see TestCase#tearDown()
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testHash01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFp<br>
     * ҒlFp̃nbVl<br>
     * 
     * p̃nbVl̎擾o邱Ƃ̊mFmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash01() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "MD5";
        String paramStr = "abc";

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("abc".getBytes()),
                resultHashValue));
    }

    /**
     * testHash02B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFSp<br>
     * ҒlFSp̃nbVl<br>
     * 
     * Sp̃nbVl̎擾o邱Ƃ̊mFmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash02() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "MD5";
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("".getBytes()),
                resultHashValue));
    }
    /**
     * testHash03B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lF󕶎<br>
     * ҒlF󕶎̃nbVl<br>
     * 
     * 󕶎̃nbVl̎擾o邱Ƃ̊mFmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash03() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "MD5";
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHash04B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFnbVASYw<br>
     * ҒlFnbVl̎擾<br>
     * 
     * nbVASYwōsꍇɂnbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash04() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "md5";
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHash05B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * 
     * null̃nbVl̎擾NullPointerException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash05() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "md5";
        String paramStr = null;

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertNull(resultHashValue);
    }

    /**
     * testHash06B<br>
     * 
     * (ُn)<br>
     * ϓ_FA<br>
     * 
     * ͒lFsȃnbVASY<br>
     * ҒlFNoSuchAlgorithmException<br>
     * 
     * sȃnbVASYw莞NoSuchAlgorithmException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash06() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "NoSuchAlgorithm";
        String paramStr = "abc";

        try {
            // eXgs
            HashUtil.hash(paramAlgorithm, paramStr);
            fail();
        } catch (NoSuchAlgorithmException nsae) {
            return;
        }
    }

    /**
     * testHash07B<br>
     * 
     * (ُn)<br>
     * ϓ_FC<br>
     * 
     * ͒lFnbVASYɋ󕶎w<br>
     * ҒlFNoSuchAlgorithmException<br>
     * 
     * nbVASYɋ󕶎w莞NoSuchAlgorithmException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash07() throws Exception {
        // ͒lݒ
        String paramAlgorithm = "";
        String paramStr = "abc";

        try {
            // eXgs
            HashUtil.hash(paramAlgorithm, paramStr);
            fail();
        } catch (NoSuchAlgorithmException nsae) {
            return;
        }
    }

    /**
     * testHash08B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lFnbVASYnullw<br>
     * ҒlFNullPointerException<br>
     * 
     * nbVASYnullw莞NullPointerException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHash08() throws Exception {
        // ͒lݒ
        String paramAlgorithm = null;
        String paramStr = "abc";

        // eXgs
        byte[] resultHashValue = HashUtil.hash(paramAlgorithm, paramStr);

        // ʊmF
        assertNull(resultHashValue);
    }

    /**
     * testHashMD501B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFp<br>
     * ҒlFp̃nbVl<br>
     * 
     * p̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashMD501() throws Exception {
        // ͒lݒ
        String paramStr = "abc";

        // eXgs        
        byte[] resultHashValue = HashUtil.hashMD5(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("abc".getBytes()),
                resultHashValue));

    }

    /**
     * testHashMD502B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFSp<br>
     * ҒlFSp̃nbVl<br>
     * 
     * Sp̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashMD502() throws Exception {
        // ͒lݒ
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hashMD5(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHashMD503B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lF󕶎<br>
     * ҒlF󕶎̃nbVl<br>
     * 
     * 󕶎̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashMD503() throws Exception {
        // ͒lݒ
        String paramStr = "";

        // eXgs        
        byte[] resultHashValue = HashUtil.hashMD5(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("MD5").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHashMD504B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * 
     * null̃nbVl̎擾NullPointerException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashMD504() throws Exception {
        // ͒lݒ
        String paramStr = null;

        // eXgs
        byte[] resultHashValue = HashUtil.hashMD5(paramStr);

        // ʊmF
        assertNull(resultHashValue);
    }

    /**
     * testHashSHA101B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFp<br>
     * ҒlFp̃nbVl<br>
     * 
     * p̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashSHA101() throws Exception {
        // ͒lݒ
        String paramStr = "abc";

        // eXgs
        byte[] resultHashValue = HashUtil.hashSHA1(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("SHA1").digest("abc".getBytes()),
                resultHashValue));
    }

    /**
     * testHashSHA102B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFSp<br>
     * ҒlFSp̃nbVl<br>
     * 
     * Sp̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashSHA102() throws Exception {
        // ͒lݒ
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hashSHA1(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("SHA1").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHashSHA103B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lF󕶎<br>
     * ҒlF󕶎̃nbVl<br>
     * 
     * Sp̃nbVl̎擾o邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashSHA103() throws Exception {
        // ͒lݒ
        String paramStr = "";

        // eXgs
        byte[] resultHashValue = HashUtil.hashSHA1(paramStr);

        // ʊmF
        assertTrue(
            MessageDigest.isEqual(
                MessageDigest.getInstance("SHA1").digest("".getBytes()),
                resultHashValue));
    }

    /**
     * testHashSHA104B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * 
     * null̃nbVl̎擾NullPointerException邱ƂmFB<br>
     * 
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testHashSHA104() throws Exception {
        // ͒lݒ
        String paramStr = null;

        // eXgs
        byte[] resultHashValue = HashUtil.hashSHA1(paramStr);

        // ʊmF
        assertNull(resultHashValue);
    }

}
