/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.mapper.castor.exception;

import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorCreateMarshallerIOException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.oxm.mapper.castor.exception.CastorCreateMarshallerIOException} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * CastorMarshallerIOOꍇAX[O
 * <p>
 * 
 * @see jp.terasoluna.fw.oxm.mapper.castor.exception.CastorCreateMarshallerIOException
 */
public class CastorCreateMarshallerIOExceptionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CastorCreateMarshallerIOExceptionTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public CastorCreateMarshallerIOExceptionTest(String name) {
        super(name);
    }

    /**
     * testCastorCreateMarshallerIOException01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() cause:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) cause:Ɠ̃CX^X<br>
     *         
     * <br>
     * ̃CX^Xɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCastorCreateMarshallerIOException01() throws Exception {
        
        // ͒l̐ݒB
        Throwable cause = new Throwable();
        // eXgΏۃRXgN^̎sB
        CastorCreateMarshallerIOException ce = new CastorCreateMarshallerIOException(cause);

        // o͒l̊mFB
        Throwable throwCause =
            ((Throwable) UTUtil.getPrivateField(ce, "cause"));
        
        assertSame(cause, throwCause);

    }

    /**
     * testCastorCreateMarshallerIOException02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() cause:null<br>
     *         
     * <br>
     * ҒlF(ԕω) cause:null<br>
     *         
     * <br>
     * null̏ꍇAnullݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCastorCreateMarshallerIOException02() throws Exception {
        
        // eXgΏۃRXgN^̎sB
        CastorCreateMarshallerIOException ce = new CastorCreateMarshallerIOException(null);

        // o͒l̊mFB
        Throwable throwCause =
            ((Throwable) UTUtil.getPrivateField(ce, "cause"));
        
        assertNull(throwCause);

    }

}
