/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.mapper.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorCreateMarshallerIOException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorMappingException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorMarshalException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorUnsupportedEncodingException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorValidationException;
import jp.terasoluna.fw.oxm.serialize.XMLSerializerEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.Method;
import org.apache.xml.serialize.OutputFormat;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

/**
 * Castor𗘗pIuWFNg-XMLϊNXB
 * 
 * <p>
 * IuWFNg-XML̕ϊ𖾎IɎw肷ꍇ́ACastor}bsO`t@CKvƂȂB
 * Castor}bsO`t@CŃIuWFNgXMLAXMLIuWFNg ݂̕ϊsƂłB
 * Castor}bsO`t@C͕ϊsIuWFNg̃NX pbP[WAOAgqh.xmlhŔzu邱ƁB
 * </p>
 * 
 * <p>
 * Castor}bsO`t@Cȗꍇ́ACastor̃ftHgϊ[KpB
 * </p>
 * 
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>ftHgϊgpꍇ̃IvV</legend> ftHgϊgpꍇ́ACastorXMLl[~OIvV
 * L̂悤 mixed Ǝw肵ĂƁB<br>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>castor.properties</legend> org.exolab.castor.xml.naming=mixed
 * </fieldset> <br>
 * ̃IvV̐ݒLɂāAL̂悤Marshall̏oXMLωB<br>
 * ftHĝ܂܂ƁAUnmarshallɖ肪邽߁ÃIvVݒ肷B<br>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>yorg.exolab.castor.xml.naming=lower (ftHg)z</legend>
 * <code>UserBean  &lt;user-bean&gt;</code><br>
 * </fieldset> <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;"> <legend>yorg.exolab.castor.xml.naming=mixedz</legend>
 * <code>UserBean  &lt;userBean&gt;</code> </fieldset> </fieldset>
 * 
 * <p>
 * jXMLϊΏۂ̃IuWFNgusample.SampleBeanvNX̏ꍇA
 * Castor}bsO`t@C̓NXpX́usample/SampleBean.xmlv t@CƂȂB
 * </p>
 * 
 * <p>
 * Castor}bsO`t@C̋Lq@́A Castor̎dlɏĂB ڍׂTERASOUNÃhLgQƂ邱ƁB
 * </p>
 * 
 * <p>
 * {NXł́AxCastor}bsO`t@Cǂݍނ ŃLbVB LbV𗘗pȂꍇA{NX
 * {@link #cache}falseɂ邱ƁB
 * </p>
 * 
 * <p>
 * <strong>gp</strong>
 * </p>
 * 
 * <p>
 * yϊΏۂ̃IuWFNgz <code><pre>
 *       public class SampleDto {
 *           private int userid;
 *           private String username;
 *           private Item[] item;
 *           EEE
 *           igetterAsetterj
 *       }
 *       public class Item {
 *           private int id;
 *           private String name;
 *           private int price;
 *           EEE
 *           igetterAsetterj
 *       }
 * </pre></code>
 * </p>
 * 
 * <p>
 * yϊΏۂXMLf[^z <code><pre>
 *       &lt;sample-dto&gt;
 *        &lt;user-id&gt;15&lt;/user-id&gt;
 *        &lt;user-name&gt;user1&lt;/user-name&gt;
 *        &lt;item&gt;
 *          &lt;id&gt;100&lt;/id&gt;
 *          &lt;name&gt;item1&lt;/name&gt;
 *          &lt;price&gt;1000&lt;/price&gt;
 *        &lt;/item&gt;
 *        &lt;item&gt;
 *          &lt;id&gt;101&lt;/id&gt;
 *          &lt;name&gt;item2&lt;/name&gt;
 *          &lt;price&gt;2000&lt;/price&gt;
 *        &lt;/item&gt;
 *       &lt;/sample-dto&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * yϊΏۂ̃IuWFNgz <code><pre>
 *       SampleDto[0].userid[0] = 15
 *       SampleDto[0].name[0] = user1
 *       SampleDto[0].Item[0].id[0] = 100
 *       SampleDto[0].Item[0].name[0] = &quot;item1&quot;
 *       SampleDto[0].Item[0].price[0] = 1000
 *       SampleDto[0].Item[1].id[0] = 101
 *       SampleDto[0].Item[1].name[0] = &quot;item2&quot;
 *       SampleDto[0].Item[1].price[0] = 200
 * </pre></code>
 * </p>
 * 
 * <p>
 * yCastor}bsO`t@Cz <code><pre>
 *       &lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
 *       &lt;!DOCTYPE mapping PUBLIC &quot;-//EXOLAB/Castor Object Mapping DTD Version 1.0//EN&quot;
 *                                       &quot;http://castor.exolab.org/mapping.dtd&quot;&gt;
 *       &lt;mapping&gt;
 *         &lt;class name=&quot;sample.dto.SampleDto&quot;&gt;
 *           &lt;map-to xml=&quot;sample-dto&quot;/&gt;
 *           &lt;field name=&quot;userid&quot; type=&quot;int&quot;&gt;
 *             &lt;bind-xml name=&quot;user-id&quot; node=&quot;element&quot;/&gt;
 *           &lt;/field&gt;
 *            &lt;field name=&quot;username&quot; type=&quot;string&quot;&gt;
 *             &lt;bind-xml name=&quot;user-name&quot; node=&quot;element&quot;/&gt;
 *           &lt;/field&gt;
 *           &lt;field name=&quot;item&quot; type=&quot;sample.dto.Item&quot; collection=&quot;array&quot;&gt;
 *             &lt;bind-xml name=&quot;Item&quot; node=&quot;element&quot;/&gt;
 *          &lt;/field&gt;
 *         &lt;/class&gt;
 *         &lt;class name=&quot;sample.dto.Item&quot;&gt;
 *           &lt;field name=&quot;id&quot; type=&quot;int&quot;&gt;
 *           &lt;/field&gt;
 *           &lt;field name=&quot;name&quot; type=&quot;string&quot;&gt;
 *           &lt;/field&gt;
 *           &lt;field name=&quot;price&quot; type=&quot;int&quot;&gt;
 *           &lt;/field&gt;
 *         &lt;/class&gt;
 *       &lt;/mapping&gt; 
 * </pre></code>
 * </p>
 * 
 * <p>
 * yR[hiXMLIuWFNgjz
 * 
 * <pre><code>
 * CastorOXMapper oxmapper = new CastorOXMapperImpl();
 * SampleDto bean = new SampleDto(); // ̃IuWFNgXMLf[^i[
 * Reader reader = new FileReader(&quot;C:/sample/sampleDto.xml&quot;); // ϊXMLf[^
 * 
 * // XMLIuWFNgϊ
 * oxmapper.unmarshal(reader, bean);
 * </code></pre>
 * 
 * </p>
 * 
 * <p>
 * yR[hiIuWFNgXMLjz
 * 
 * <pre><code>
 * CastorOXMapper oxmapper = new CastorOXMapperImpl();
 * Writer writer = new OutputStreamWriter(System.out);
 * 
 * // IuWFNgXML
 * oxmapper.marshal(bean, writer);
 * </code></pre>
 * 
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder
 * 
 */
public class CastorOXMapperImpl implements OXMapper {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(CastorOXMapperImpl.class);

    /**
     * ftHg̕ZbgB
     */
    protected static final String DEFAULT_CHARSET = "UTF-8";

    /**
     * ZbgB
     */
    private String charset = DEFAULT_CHARSET;

    /**
     * Castor}bsO`t@C̃LbVݒBftHgtrueB
     */
    private boolean cache = true;

    /**
     * MarshallerIvV suppressXSITypefalseݒ肷ƃ}bsO`ݒ莞
     * hLgɁuxmlns:xsivyсuxsi:typevt^
     */
    private boolean suppressXSIType = true;

    /**
     * MarshallerIvV preserveWhitespacetrueݒ肷ƁA
     * hLg̃[gm[hɁuxml:space="preserve"vt^B<br>
     * ftHgltruełB Sdɑ΂ėLɂȂ邽߁Agpɂ͒ӂKvB
     */
    private boolean preserveWhitespaceAtMarshal = true;

    /**
     * UnmarshallerIvV whitespacePreservetrueݒ肷ƁA gbvx̋󔒂ێ悤ɂȂB<br>
     * ftHglfalsełB Sdɑ΂ėLɂȂ邽߁Agpɂ͒ӂKvB
     */
    private boolean preserveWhitespaceAtUnmarshal = false;

    /**
     * MarshallerIvV indentingtrueݒ肷ƁAxmlCfgB<br>
     * <b>ӁFpreserveWhitespaceAtMarshal  <u>false</u> ̎̂ݗL<b><br>
     */
    private boolean indenting = true;
    
    /**
     * pbP[W̃Zp[^B
     */
    public static final String NESTED_PACKAGE_SEPARATOR = ".";

    /**
     * tH_̃Zp[^B
     */
    public static final String NESTED_FOLDER_SEPARATOR = "/";

    /**
     * Castor}bsO`t@C̃TtBbNXB
     */
    public static final String CASTOR_MAPPINGFILE_SUFFIX = ".xml";

    /**
     * Castor}bsO`t@CLbVMapB
     */
    private Map<Class, Mapping> mappingFileCache = new HashMap<Class, Mapping>();

    /**
     * MarshallerŋLXMLClassDescriptorResolverB
     */
    private XMLClassDescriptorResolver sharedResolverForMarshaller = null;

    /**
     * Marshallerɐݒς݂Castor}bsOClass̏WB
     */
    private Set<Class> hasSetMappingSetForMarshaller = new HashSet<Class>();

    /**
     * DOMc[IuWFNgɕϊB
     * 
     * @param doc
     *            DOMc[B
     * @param out
     *            XMLϊꂽIuWFNgB
     */
    public void unmarshal(Document doc, Object out) {

        if (doc == null) {
            log.error("DOM tree is null.");
            throw new IllegalArgumentException("DOM tree is null.");
        }

        Unmarshaller unmarshaller = createUnmarshaller(out);

        // XMLObject
        try {
            unmarshaller.unmarshal(doc);
        } catch (MarshalException e) {
            // XMLf[^̃}bsOɎs
            log.error("Castor unmarshal failure.", e);
            throw new CastorMarshalException(e);
        } catch (ValidationException e) {
            // XMLf[^̌؂Ɏs
            log.error("Castor validation error.", e);
            throw new CastorValidationException(e);
        }
    }

    /**
     * Xg[XMLf[^oAIuWFNgɕϊB
     * 
     * @param reader
     *            XMLf[^BZbgw肳ĂȂꍇA VM̃ftHgZbggpB
     * @param out
     *            XMLϊꂽIuWFNgB
     */
    public void unmarshal(Reader reader, Object out) {

        if (reader == null) {
            log.error("Reader is null.");
            throw new IllegalArgumentException("Reader is null.");
        }

        Unmarshaller unmarshaller = createUnmarshaller(out);

        // XMLObject
        try {
            unmarshaller.unmarshal(reader);
        } catch (MarshalException e) {
            // XMLf[^̃}bsOɎs
            log.error("Castor unmarshal failure.", e);
            throw new CastorMarshalException(e);
        } catch (ValidationException e) {
            // XMLf[^̌؂Ɏs
            log.error("Castor validation error.", e);
            throw new CastorValidationException(e);
        }
    }

    /**
     * Xg[XMLf[^oAIuWFNgɕϊB
     * 
     * <p>
     * argCharsetnull܂͋󕶎̏ꍇA InputStreamReader̕ZbgƂđ{@link #charset}̒lgpB<br>
     * ftHgݒł́A{@link #charset}̒l"UTF-8"łB
     * </p>
     * 
     * @param is
     *            XMLf[^B
     * @param argCharset
     *            ZbgB
     * @param out
     *            XMLϊꂽIuWFNgB
     */
    public void unmarshal(InputStream is, String argCharset, Object out) {

        if (is == null) {
            log.error("InputStream is null.");
            throw new IllegalArgumentException("InputStream is null.");
        }

        String charset = argCharset;

        // Zbgw肳ĂȂꍇ́AUTF-8gp
        if (charset == null || charset.length() < 1) {
            if (log.isDebugEnabled()) {
                log.debug("Character encoding is not found. " + DEFAULT_CHARSET
                        + " is used.");
            }
            charset = getCharset();
        }

        InputStreamReader isr = null;

        // XMLObject
        try {
            isr = new InputStreamReader(is, charset);
            unmarshal(isr, out);
        } catch (UnsupportedEncodingException e) {
            // T|[gĂȂGR[fBO
            log.error("Character encoding error.", e);
            throw new CastorUnsupportedEncodingException(e);
        } finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            } catch (IOException e) {
                log.error("Failed to close input stream.", e);
            }
        }
    }

    /**
     * A}[V[𐶐B Castor}bsO`̐ݒsB
     * 
     * @param out
     *            o͑Ώۂ̃IuWFNg
     * @return A}[V[
     */
    protected Unmarshaller createUnmarshaller(Object out) {

        if (out == null) {
            log.error("Unmarshal object is null.");
            throw new IllegalArgumentException("Unmarshal object is null.");
        }

        Unmarshaller unmarshaller = new Unmarshaller(out);

        Class mappingClass = out.getClass();

        // Castor}bsO`
        Mapping mapping = getCastorMapping(mappingClass);

        if (mapping != null) {
            try {
                unmarshaller.setMapping(mapping);
            } catch (MappingException e) {
                // Castor}bsO`t@Cɖ肪
                log.error("Castor mapping file is invalid. "
                        + "- [root-classpath]/"
                        + getMappingFilePath(mappingClass), e);
                throw new CastorMappingException(e);
            }

            // Castor}bsO`t@CLbV
            if (cache && !mappingFileCache.containsKey(mappingClass)) {
                mappingFileCache.put(mappingClass, mapping);
            }
        }

        // CastorŃof[Vi``FbNj͍sȂ
        unmarshaller.setValidation(false);

        // UnmarshallerIvV whitespacePreserve
        unmarshaller.setWhitespacePreserve(preserveWhitespaceAtUnmarshal);

        return unmarshaller;
    }

    /**
     * IuWFNgXMLɕϊAXg[ɏށB
     * 
     * @param in
     *            XMLɕϊIuWFNg
     * @param writer
     *            ϊXMLރC^[
     */
    public void marshal(Object in, Writer writer) {
        Marshaller marshaller = createMarshaller(in, writer);

        // ObjectXML
        try {
            marshaller.marshal(in);
        } catch (MarshalException e) {
            // XMLf[^̃}bsOɎs
            log.error("Castor marshal failure.", e);
            throw new CastorMarshalException(e);
        } catch (ValidationException e) {
            // XMLf[^̌؂Ɏs
            log.error("Castor validation error.", e);
            throw new CastorValidationException(e);
        }
    }

    /**
     * }[V[𐶐B Castor}bsO`ݒ肷B
     * 
     * @param in
     *            XMLϊΏۂ̃IuWFNg
     * @param writer
     *            o͗pC^[
     * @return }[V[
     */
    @SuppressWarnings("deprecation")
    protected Marshaller createMarshaller(Object in, Writer writer) {

        if (in == null) {
            log.error("Marshall object is null.");
            throw new IllegalArgumentException("Marshall object is null.");
        }

        if (writer == null) {
            log.error("Writer is null.");
            throw new IllegalArgumentException("Writer is null.");
        }

        Marshaller marshaller = null;

        // }[V[̐
        try {
            XMLSerializerEx serializer = new XMLSerializerEx(writer,
                    new OutputFormat(Method.XML, charset, indenting));
            serializer.setPreserveWhitespace(preserveWhitespaceAtMarshal);

            marshaller = new Marshaller((ContentHandler) serializer);
            if (sharedResolverForMarshaller == null) {
                ClassDescriptorResolver resolver = marshaller.getResolver();
                if (resolver instanceof XMLClassDescriptorResolver) {
                    sharedResolverForMarshaller = (XMLClassDescriptorResolver) resolver;
                }
            } else {
                marshaller.setResolver(sharedResolverForMarshaller);
            }
        } catch (IOException e) {
            log.error("Marshaling io error.", e);
            throw new CastorCreateMarshallerIOException(e);
        }

        Class mappingClass = in.getClass();

        if (!hasSetMappingSetForMarshaller.contains(mappingClass)) {
            // Castor}bsO`
            Mapping mapping = getCastorMapping(mappingClass);

            if (mapping != null) {
                try {
                    marshaller.setMapping(mapping);
                    hasSetMappingSetForMarshaller.add(mappingClass);
                } catch (MappingException e) {
                    // Castor}bsO`t@Cɖ肪
                    log.error("Castor mapping file is invalid. "
                            + "- [root-classpath]/"
                            + getMappingFilePath(mappingClass), e);
                    throw new CastorMappingException(e);
                }

                // Castor}bsO`t@CLbV
                if (cache && !mappingFileCache.containsKey(mappingClass)) {
                    mappingFileCache.put(mappingClass, mapping);
                }
            }
        }

        marshaller.setValidation(false);

        // MarshallerIvV suppressXSIType
        marshaller.setSuppressXSIType(suppressXSIType);

        return marshaller;
    }

    /**
     * Castor}bsO`t@C擾B {@link #cache}truȅꍇAǂݍCastor}bsO`t@C
     * LbVBfalsȅꍇALbV͍sȂB
     * 
     * @param mappingClass
     *            }bsOΏۂ̃NX
     * @return Castor}bsO`t@C
     */
    protected Mapping getCastorMapping(Class mappingClass) {
        Mapping mapping = null;

        // LbVΕԂ
        if (cache) {
            mapping = mappingFileCache.get(mappingClass);
            if (mapping != null) {
                return mapping;
            }
        }

        // Castor}bsO`t@C擾
        mapping = new Mapping();
        URL mappingURL = getUrl(mappingClass);

        if (mappingURL == null) {
            // Castor}bsO`t@CȂꍇnullԋpACastor̃ftHg[Kp
            return null;
        }

        // }bsOCX^XCastor}bsO`t@C[h
        mapping.loadMapping(new InputSource(mappingURL.toExternalForm()));

        return mapping;
    }

    /**
     * URL擾B
     * 
     * @param mappingClass
     *            }bsOΏۂ̃NX
     * @return \[XURLCX^X
     */
    protected URL getUrl(Class mappingClass) {
        return Thread.currentThread().getContextClassLoader().getResource(
                getMappingFilePath(mappingClass));
    }

    /**
     * Castor}bsOt@C̃pX擾B
     * 
     * @param mappingClass
     *            }bsONXB
     * @return Castor}bsOt@C̃pX
     */
    protected String getMappingFilePath(Class mappingClass) {
        StringBuilder buf = new StringBuilder();
        buf.append(mappingClass.getName().replace(NESTED_PACKAGE_SEPARATOR,
                NESTED_FOLDER_SEPARATOR));
        buf.append(CASTOR_MAPPINGFILE_SUFFIX);
        return buf.toString();
    }

    /**
     * cache擾B
     * 
     * @return cache
     */
    public boolean isCache() {
        return cache;
    }

    /**
     * cacheݒ肷B
     * 
     * @param cache
     *            cacheɐݒ肷l
     */
    public void setCache(boolean cache) {
        this.cache = cache;
    }

    /**
     * Zbg擾B
     * 
     * @return ZbgB
     */
    public String getCharset() {
        return charset;
    }

    /**
     * Zbgݒ肷B
     * 
     * @param charset
     *            ZbgB
     */
    public void setCharset(String charset) {
        this.charset = charset;
    }

    /**
     * MarshallerIvV suppressXSIType<br>
     * <br>
     * <b>Castor}bsOݒ艻ɃXL[}of[^Kpꍇtrueݒ肷B</b><br>
     * <br>
     * falseݒ肷ƃlXgBeanMarshall鎞ɁA
     * XMLhLgɁuxmlns:xsivyсuxsi:typevt^B<br>
     * ̃l[Xy[Xt^ƁACastor}bsOݒ艻 XL[}of[^gpꍇAUnmarshallłȂB<br>
     * ̂߁AXL[}of[^gpꍇɂ́ÃIvVtrue ݒ肷B<br>
     * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
     * <legend>false</legend>
     * 
     * <pre>
     *       &lt;resultReserveParam&gt;
     *         &lt;reserveDetailList 
     *         xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot; 
     *         xsi:type=&quot;java:sample.ReserveDetail&quot;&gt;
     *         &lt;/reserveDetailList&gt;
     *       &lt;/resultReserveParam&gt;
     * </pre>
     * 
     * </fieldset><br>
     * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
     * <legend>trueiftHgj</legend>
     * 
     * <pre>
     *       &lt;resultReserveParam&gt;
     *         &lt;reserveDetailList&gt;
     *         &lt;/reserveDetailList&gt;
     *       &lt;/resultReserveParam&gt;
     * </pre>
     * 
     * </fieldset><br>
     * 
     * @param suppressXSIType
     *            ݒ肷 suppressXSIType
     */
    public void setSuppressXSIType(boolean suppressXSIType) {
        this.suppressXSIType = suppressXSIType;
    }

    /**
     * UnmarshallerIvV whitespacePreserveݒ肷B
     * <p>
     * trueݒ肷ƁASĂ̗vfɂċ󔒂ێ ܂܃A}[VsB<br>
     * falsȅꍇłAuxml:space="preserve"vw肳ꂽ vfɂẮA󔒂ێ܂܃A}[VB
     * 
     * Sdɑ΂ėLɂȂ邽߁Agpɂ͒ӂKvłB ftHgl<code>false</code>B
     * 
     * @param preserveWhitespaceAtUnmarshal
     *            ݒ肷 whitespacePreserve
     */
    public void setPreserveWhitespaceAtUnmarshal(
            boolean preserveWhitespaceAtUnmarshal) {
        this.preserveWhitespaceAtUnmarshal = preserveWhitespaceAtUnmarshal;
    }

    /**
     * MarshallerIvV preserveWhitespaceݒ肷B
     * <p>
     * trueݒ肷ƐhLg̃[gm[h uxml:space="preserve"vt^B<br>
     * Sdɑ΂ėLɂȂ邽߁Agpɂ͒ӂKvłB ftHgl<code>true</code>B
     * 
     * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
     * <legend>false</legend>
     * 
     * <pre>
     *       &lt;resultReserveParam&gt;
     *         &lt;reserveDetailList&gt;
     *         &lt;/reserveDetailList&gt;
     *       &lt;/resultReserveParam&gt;
     * </pre>
     * 
     * </fieldset><br>
     * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
     * <legend>trueiftHgj</legend>
     * 
     * <pre>
     *       &lt;resultReserveParam xml:space=&quot;preserve&quot;&gt;
     *         &lt;reserveDetailList&gt;
     *         &lt;/reserveDetailList&gt;
     *       &lt;/resultReserveParam&gt;
     * </pre>
     * 
     * </fieldset><br> *
     * 
     * @param preserveWhitespaceAtMarshal
     *            ݒ肷preserveWhitespace
     */
    public void setPreserveWhitespaceAtMarshal(
            boolean preserveWhitespaceAtMarshal) {
        this.preserveWhitespaceAtMarshal = preserveWhitespaceAtMarshal;
    }

    /**
     * MarshallerIvV indentingݒ肷<br>
     * <br>
     * trueݒ肷ƁAxmlCfgB<br>
     * <br>
     * <b>ӁFpreserveWhitespaceAtMarshal  <u>false</u> ̎̂ݗL<b><br>
     * 
     * @param indenting ݒ肷 indenting
     */
    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

}
