/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * ̐EjsT[ubgtB^B
 * 
 * <p>
 * NGXgJnɐ𐶐ANGXgIɔjB
 * ̐`FCꂽ̎sɗOĂAK͔jB
 *
 * ̏ڍׂ́ARequestContextSupportQƂ̂ƁB
 * </p>
 * 
 * <p>
 * {T[ubgtB^𗘗pɂ́Aweb.xml̐ݒ肪KvłB
 * </p>
 * 
 * <p>
 * yfvCgfBXNv^iweb.xmlj̐ݒz<br>
 * <code><pre>
 *  &lt;filter&gt;
 *   &lt;filter-name&gt;requestContextHandlingFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *     jp.terasoluna.fw.web.rich.RequestContextHandlingFilter
 *   &lt;/filter-class&gt;
 *  &lt;/filter&gt;
 *  &lt;filter-mapping&gt;
 *    &lt;filter-name&gt;requestContextHandlingFilter&lt;/filter-name&gt;
 *    &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 *  &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * ̎擾̂߁ADIRei琧T|[gNX擾B
 * 擾BeanID́hctxSupporthƂB
 * RequestContextSupport擾ۂɗpBeanIDJX^}CYꍇ́A
 * tB^̏p[^uctxSupportBeanIDv
 * RequestContextSupport擾邽߂BeanLq邱ƂŒڎw肷邱ƂłB
 * ʏ́Ap[^̎w͕svłB
 * </p>
 * 
 * <p>
 * yinitParameter𗘗pfvCgfBXNv^iweb.xmlj̐ݒz<br>
 * <code><pre>
 *  &lt;filter&gt;
 *     &lt;filter-name&gt;requestContextHandlingFilter&lt;/filter-name&gt;
 *     &lt;filter-class&gt;
 *       jp.terasoluna.fw.web.rich.RequestContextHandlingFilter
 *     &lt;/filter-class&gt;
 *     &lt;init-param&gt;
 *       &lt;param-name&gt;ctxSupportBeanID&lt;/param-name&gt;
 *       &lt;param-value&gt;newCtxSupport&lt;/param-value&gt;
 *     &lt;/init-param&gt;
 *   &lt;/filter&gt;
 *   &lt;filter-mapping&gt;
 *     &lt;filter-name&gt;requestContextHandlingFilter&lt;/filter-name&gt;
 *     &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 *   &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.context.support.RequestContextSupport
 * 
 */
public class RequestContextHandlingFilter implements Filter {
    
    /**
     * DIReiRequestContextSupport擾ۂBeanID̃ftHglB
     */
    private static final String DEFAULT_CTXSUPPORT_BEANID = "ctxSupport";
    
    /**
     * p[^RequestContextSupportBeanID擾邽߂̃L[B
     */
    private static final String INITPARAM_KEY_CTXSUPPORT_BEANID
                                                     = "ctxSupportBeanID";
    
    /**
     * RequestContextSupportB
     */
    private RequestContextSupport ctxSupport = null;

    /**
     * tB^̏sB
     * RequestContextSupportDIRei擾B
     * 
     * @param config tB^ݒ
     * @throws ServletException T[ubgO
     */
    public void init(FilterConfig config) throws ServletException {
        String ctxSupportBeanID
            = config.getInitParameter(INITPARAM_KEY_CTXSUPPORT_BEANID);
        if (ctxSupportBeanID == null) {
            ctxSupportBeanID = DEFAULT_CTXSUPPORT_BEANID;
        }
        // ReLXg̎擾
        ApplicationContext context 
            = WebApplicationContextUtils.getWebApplicationContext(
                config.getServletContext());
        this.ctxSupport
            = (RequestContextSupport) context.getBean(ctxSupportBeanID);
    }

    /**
     * tB^B
     * ̓o^EjsB
     * 
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param chain `FCꂽtB^
     * @throws IOException o͗O
     * @throws ServletException T[ubgO
     */
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        try {
            // ReLXg̐
            ctxSupport.generateContext((HttpServletRequest) request);
            chain.doFilter(request, response);
        } finally {
            // ReXg̍폜
            ctxSupport.destroyContext();
        }
    }

    /**
     * tB^̔jsB
     * ȂɂȂB
     */
    public void destroy() {
    }
}
