/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;

/**
 * NGXgƎs郊NGXgRg[Bean`̃}bsOsnhB
 * 
 * <p>
 * DispacherServletsA
 * ̃NGXgƂ炩ߒ`ړEڔBeanƂāA
 * DIRei胊NGXgRg[̎擾sAԋpB
 * DispacherServlet́AԋpꂽNGXgRg[sB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇA{NXBean`sƁB
 * ܂Aȉ̃vpeBKݒ肷邱ƁB
 * </p>
 * 
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th></th>
 * 
 *     <tr>
 *       <td align=center><b>ctxSupport</b></td>
 *       <td>NGXg擾邽߂̃T|[gWbNNXB</td>
 *     </tr>
 *     
 *     <tr>
 *       <td align=center><b>prefix</b></td>
 *       <td>NGXgɕt^ړB</td>
 *     </tr>
 * 
 *     <tr>
 *       <td align=center><b>suffix</b></td>
 *       <td>NGXgɕt^ڔB</td>
 *     </tr>
 *     
 *     <tr>
 *       <td align=center><b>defaultHandler</b></td>
 *       <td>NGXgɑΉRg[݂Ȃꍇ̃Rg[B</td>
 *     </tr>
 * 
 *  </table>
 * 
 * </p>
 * 
 * <p>
 * y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 *   &lt;bean id=&quot;defaultHandlerMapping&quot;
 *       class=&quot;jp.terasoluna.fw.web.rich.springmvc.servlet.handler.BeanNameUrlHandlerMappingEx&quot;&gt;
 *     &lt;property name=&quot;ctxSupport&quot; ref=&quot;ctxSupport&quot;/&gt;
 *     &lt;property name=&quot;prefix&quot; value=&quot;/secure/blogic/&quot;/&gt;
 *     &lt;property name=&quot;suffix&quot; value=&quot;.do&quot;/&gt;
 *     &lt;property name=&quot;defaultHandler&quot; ref=&quot;unknownRequestNameController&quot;/&gt;
 *   &lt;/bean&gt;
 *    ctxSupport́A T|[gWbNBean`B
 *    unknownRequestNameControlleŕANGXgɑΉRg[݂ȂꍇɎsRg[Bean`B
 * </pre></code>
 * </p>
 * 
 * <p>
 * L̐ݒsꍇA
 * Ƃ΁ANGXgusumvꍇA
 * DIReiu/secure/blogic/sum.dovƂ̂Bean擾AԋpB
 * ABean擾łȂ(݂Ȃ)ꍇ́A
 * uunknownRequestNameControllervƂ̂
 * BeanDIRei擾AԋpB
 * iBean擾łȂꍇ̏ڍׂ́AUnkownRequestNameControllerQƂ̂ƁBj
 * </p>
 * 
 */
public class BeanNameUrlHandlerMappingEx extends BeanNameUrlHandlerMapping 
    implements InitializingBean {
    /**
     * ONXB
     */
    private static Log log = 
        LogFactory.getLog(BeanNameUrlHandlerMappingEx.class);
    
    /**
     * T|[gWbNNXB
     */
    protected RequestContextSupport ctxSupport = null;
    
    /**
     * NGXgɕt^ړB
     */
    protected String prefix = "";

    /**
     * NGXgɕt^ڔB
     */
    protected String suffix = "";
    
    /**
     * NGXgɕt^ړݒ肷B
     * @param prefix NGXgɕt^ړB
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /**
     * NGXgɕt^ڔݒ肷B
     * @param suffix NGXgɕt^ڔB
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    /**
     * T|[gWbNNXݒ肷B
     * @param ctxSupport T|[gWbNNX
     */
    public void setCtxSupport(
            RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }
    
    /**
     * NGXgƂɁANGXgRg[̃CX^XbNAbvB
     * @param urlPath URLpX
     * @param request HttpServletRequest
     * @return NGXgRg[̃CX^X
     */
    @Override
    protected Object lookupHandler(String urlPath, HttpServletRequest request) {
        String requestName = ctxSupport.getRequestName();
        String newUrlPath = prefix + requestName + suffix;
        
        // Rg[̎擾
        Object handler = super.lookupHandler(newUrlPath, request); 
        
        if (handler == null) {
            log.error("Controller is not found. " + "BeanName:'" 
                    + newUrlPath + "'");
        }
        return handler; 
    }

    /**
     * {NXCX^XꂽɌĂ΂郁\bhB
     * ReLXg擾NXNull`FbNsB
     */
    public void afterPropertiesSet() {
        if (ctxSupport == null) {
            log.error("BeanNameUrlHandlerMappingEx must be set ctxSupport.");
            throw new IllegalStateException(
                    "BeanNameUrlHandlerMappingEx must be set ctxSupport.");
        }
    }
}
