/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.reset;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.reset.ResetterResources} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Zbgp̐ݒێNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.reset.ResetterResources
 */
public class ResetterResourcesTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ResetterResourcesTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ResetterResourcesTest(String name) {
        super(name);
    }

    /**
     * testSetActionReset01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() actionReset:ActionReset<br>
     *                path="path"<br>
     *         () actionResets:{}<br>
     *
     * <br>
     * ҒlF(ԕω) actionResets:{"path"=ActionReset}<br>
     *
     * <br>
     * Ɏw肵ActionResetpathL[ƂāAactionResetsɈactionResetݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetActionReset01() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath("path");
        //eXgs
        rr.setActionReset(ar);

        //ʊmF
        Map map = (Map) UTUtil.getPrivateField(rr, "actionResets");
        ActionReset obj = (ActionReset) map.get("path");
        assertEquals("path", obj.getPath());
        //L[̊mF
        assertTrue(map.containsKey("path"));
    }

    /**
     * testSetActionReset02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() actionReset:ActionReset<br>
     *                path=null<br>
     *         () actionResets:{}<br>
     *
     * <br>
     * ҒlF(ԕω) actionResets:{null=ActionReset}<br>
     *
     * <br>
     * Ɏw肵ActionResetpathL[ƂāAactionResetsɈactionResetݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetActionReset02() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath(null);
        //eXgs
        rr.setActionReset(ar);
        //ʊmF
        Map map = (Map) UTUtil.getPrivateField(rr, "actionResets");
        //L[̊mF
        assertTrue(map.containsKey(null));
        ActionReset obj = (ActionReset) map.get(null);
        assertNull(obj.getPath());
    }

    /**
     * testSetActionReset03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() actionReset:ActionReset<br>
     *                path=""<br>
     *         () actionResets:{}<br>
     *
     * <br>
     * ҒlF(ԕω) actionResets:{""=ActionReset}<br>
     *
     * <br>
     * Ɏw肵ActionResetpathL[ƂāAactionResetsɈactionResetݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetActionReset03() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath("");
        //eXgs
        rr.setActionReset(ar);
        //ʊmF
        Map map = (Map) UTUtil.getPrivateField(rr, "actionResets");
        //L[̊mF
        assertTrue(map.containsKey(""));
        ActionReset obj = (ActionReset) map.get("");
        assertEquals("", obj.getPath());
    }

    /**
     * testGet01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:"path"<br>
     *         () actionResets:{"path"=ActionReset}<br>
     *
     * <br>
     * ҒlF(߂l) ActionReset:ActonReset<br>
     *                   path="path"<br>
     *
     * <br>
     * Ɏw肵lL[ƂactionResetsActionReset݂ꍇAActionResetCX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath("path");

        Map<String, ActionReset> actionResets = new HashMap<String, ActionReset>();
        actionResets.put(ar.getPath(), ar);

        UTUtil.setPrivateField(rr, "actionResets", actionResets);

        //eXgs
        ActionReset result = rr.get("path");
        //ʊmF
        assertEquals("path", result.getPath());
    }

    /**
     * testGet02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:"path0"<br>
     *         () actionResets:{"path"=ActionReset}<br>
     *
     * <br>
     * ҒlF(߂l) ActionReset:null<br>
     *
     * <br>
     * Ɏw肵lL[ƂactionResetsActionReset݂ȂꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath("path");

        Map<String, ActionReset> actionResets = new HashMap<String, ActionReset>();
        actionResets.put(ar.getPath(), ar);

        UTUtil.setPrivateField(rr, "actionResets", actionResets);

        //eXgs
        //ʊmF
        assertNull(rr.get("path0"));
    }

    /**
     * testGet03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:null<br>
     *         () actionResets:{null=ActionReset}<br>
     *
     * <br>
     * ҒlF(߂l) ActionReset:ActionReset<br>
     *                   path=null<br>
     *
     * <br>
     * Ɏw肵lL[ƂactionResetsActionReset݂ꍇAActionResetCX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet03() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath(null);

        Map<String, ActionReset> actionResets = new HashMap<String, ActionReset>();
        actionResets.put(ar.getPath(), ar);

        UTUtil.setPrivateField(rr, "actionResets", actionResets);

        //eXgs
        ActionReset result = rr.get(null);
        //ʊmF
        assertNull(result.getPath());
    }

    /**
     * testGet04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:""<br>
     *         () actionResets:{""=ActionReset}<br>
     *
     * <br>
     * ҒlF(߂l) ActionReset:ActionReset<br>
     *                   path=""<br>
     *
     * <br>
     * Ɏw肵lL[ƂactionResetsActionReset݂ꍇAActionResetCX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGet04() throws Exception {
        //ݒ
        ResetterResources rr = new ResetterResources();
        ActionReset ar = new ActionReset();
        ar.setPath("");

        Map<String, ActionReset> actionResets = new HashMap<String, ActionReset>();
        actionResets.put(ar.getPath(), ar);

        UTUtil.setPrivateField(rr, "actionResets", actionResets);

        //eXgs
        ActionReset result = rr.get("");
        //ʊmF
        assertEquals("", result.getPath());
    }

}
