/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;



/**
 * {@link jp.terasoluna.fw.web.thin.AuthorizationControlFilter} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ANZX̃`FbNsB<br>
 * w肳ꂽpXւ̃ANZXĂ邩𔻕ʂB ANZXᔽ̏ꍇ́A{@link UnauthorizedException}X[
 * <p>
 *
 * @see jp.terasoluna.fw.web.thin.AuthorizationControlFilter
 */
public class AuthorizationControlFilterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AuthorizationControlFilterTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                               "controller",
                               null);
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public AuthorizationControlFilterTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:not null<br>
     *         () getController():AuthorizationControlFilter_AuthorizationControllerStub01CX^X<br>
     *         () controller:AuthorizationControlFilter_AuthorizationControllerStub01CX^X<br>
     *
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():ĂяoȂ<br>
     *         (ԕω) controller:OƓ̃CX^X<br>
     *
     * <br>
     * controllernullŖꍇAconrollŗ^configݒ肳AgetControllerĂяoȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        // ɐݒ肵ĂRtBO
        MockFilterConfig existingConfig = new MockFilterConfig();
        // ɐݒ肵ĂRg[
        AuthorizationController existingController =
            new AuthorizationControlFilter_AuthorizationControllerStub01();

        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                                "controller",
                                existingController);
        // tB^̗p
        AuthorizationControlFilter_AuthorizationControlFilterStub01 filter
            = new AuthorizationControlFilter_AuthorizationControlFilterStub01();

        filter.setConfig(existingConfig);

        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();
        // Vݒ肳Rg[
        AuthorizationControlFilter_AuthorizationControllerStub01 newController
            = new AuthorizationControlFilter_AuthorizationControllerStub01();
        filter.newController = newController;

        // eXg{
        filter.init(newConfig);
        // 
        assertSame(newConfig,UTUtil.getPrivateField(filter,"config"));
        assertFalse(filter.isCalled);

        assertSame(existingController,
                UTUtil.getPrivateField(AuthorizationControlFilter.class,
                        "controller"));
    }

    /**
     * testInit02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:null<br>
     *         () getController():AuthorizationControlFilter_AuthorizationControllerStub01CX^X<br>
     *         () controller:null<br>
     *
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():Ăяo<br>
     *         (ԕω) controller:getController()瓾CX^XƓ̃CX^X<br>
     *
     * <br>
     * controllernull̏ꍇAŗ^configݒ肳AgetControllerĂяoAtB[hɐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        // tB^̗p
        AuthorizationControlFilter_AuthorizationControlFilterStub01 filter
            = new AuthorizationControlFilter_AuthorizationControlFilterStub01();

        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();
        // Vݒ肳Rg[
        AuthorizationControlFilter_AuthorizationControllerStub01 newController
            = new AuthorizationControlFilter_AuthorizationControllerStub01();
        filter.newController = newController;

        // eXg{
        filter.init(newConfig);
        // 
        assertSame(newConfig,UTUtil.getPrivateField(filter,"config"));
        assertTrue(filter.isCalled);

        assertSame(newController,
                UTUtil.getPrivateField(AuthorizationControlFilter.class,
                        "controller"));
    }

    /**
     * testGetAuthorizationController01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() controller:AuthorizationControlFilter_AuthorizationControllerStub01CX^X<br>
     *
     * <br>
     * ҒlF(߂l) AuthorizationController:OŐݒ肵CX^XƓ̃CX^X<br>
     *
     * <br>
     * n1̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAuthorizationController01() throws Exception {
        // O
        AuthorizationController existingController =
            new AuthorizationControlFilter_AuthorizationControllerStub01();

        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                                "controller",
                                existingController);
        // eXg{
        AuthorizationController actual =
            AuthorizationControlFilter.getAuthorizationController();

        // 
        assertSame(existingController, actual);
    }

    /**
     * testDoFilter01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHORIZATION_THRU_KEY:"aaaaa"<br>
     *         () authorizationController:AuthorizationControlFilter_AuthorizationControllerStub01<br>
     *
     * <br>
     * ҒlF(ԕω) AUTHORIZATION_THRU_KEY:OƓl<br>
     *         (ԕω) chain.doFilter:s<br>
     *
     * <br>
     * request̑lłAUTHORIZATION_THRU_KEYnullłȂꍇAʋƖւ̑Jڃ`FbNs킸ɏI邱ƁB<br>
     * FilterChain#doFilter()\bhs邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        AuthorizationController existingController
            = new AuthorizationControlFilter_AuthorizationControllerStub01();

        AuthorizationControlFilter filter = new AuthorizationControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);

        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setAttribute("AUTHORIZATION_THRU_KEY","aaaaa");

        AuthorizationControlFilter_FilterChainStub01 filterChain
            = new AuthorizationControlFilter_FilterChainStub01();

        // eXg{
        filter.doFilter(request,response,filterChain);
        // 
        assertEquals("aaaaa",request.getAttribute("AUTHORIZATION_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHORIZATION_THRU_KEY:null<br>
     *         () authorizationController:AuthorizationControlFilter_AuthorizationControllerStub01<br>
     *         () .isCheckRequired():false<br>
     *
     * <br>
     * ҒlF(ԕω) AUTHORIZATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *
     * <br>
     * ʋƖւ̑Jڃ`FbNfalsȅꍇAȍ~̃`FbNs킸Arequest̑lAUTHORIZATION_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        // .isCheckRequired() = false
        AuthorizationController existingController
            = new AuthorizationControlFilter_AuthorizationControllerStub01();

        AuthorizationControlFilter filter = new AuthorizationControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);

        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        AuthorizationControlFilter_FilterChainStub01 filterChain
            = new AuthorizationControlFilter_FilterChainStub01();

        // eXg{
        filter.doFilter(request,response,filterChain);
        // 
        assertEquals("true",request.getAttribute("AUTHORIZATION_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHORIZATION_THRU_KEY:null<br>
     *         () authorizationController:AuthorizationControlFilter_AuthorizationControllerStub02<br>
     *         () .isCheckRequired():true<br>
     *         () .isAuthorized():false<br>
     *
     * <br>
     * ҒlF(ԕω) AUTHORIZATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:UnauthorizedExceptionF<br>
     *
     * <br>
     * ʋƖւ̑Jڃ`FbNtureŁAANZX`FbNfalsȅꍇArequest̑lAUTHORIZATION_THRU_KEYݒ肵UnauthorizedException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        // .isCheckRequired() = true   isAuthorized = false
        AuthorizationController existingController
            = new AuthorizationControlFilter_AuthorizationControllerStub02();

        AuthorizationControlFilter filter = new AuthorizationControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);

        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();

        AuthorizationControlFilter_FilterChainStub01 filterChain
            = new AuthorizationControlFilter_FilterChainStub01();

        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (UnauthorizedException e) {
            // 
            assertEquals("true", request.getAttribute("AUTHORIZATION_THRU_KEY"));
            assertFalse(filterChain.isCalled);
        }

    }

    /**
     * testDoFilter04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHORIZATION_THRU_KEY:null<br>
     *         () authorizationController:AuthorizationControlFilter_AuthorizationControllerStub03<br>
     *         () .isCheckRequired():true<br>
     *         () .isAuthorized():true<br>
     *
     * <br>
     * ҒlF(ԕω) AUTHORIZATION_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *
     * <br>
     * ʋƖւ̑Jڃ`FbNAANZX`FbNtruȅꍇArequest̑lAUTHORIZATION_THRU_KEYݒ肵ďI邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        // .isCheckRequired() = true   isAuthorized = true
        AuthorizationController existingController
            = new AuthorizationControlFilter_AuthorizationControllerStub03();

        AuthorizationControlFilter filter = new AuthorizationControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);

        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();

        AuthorizationControlFilter_FilterChainStub01 filterChain
            = new AuthorizationControlFilter_FilterChainStub01();

        // eXg{
        filter.doFilter(request, response, filterChain);

        // 
        assertEquals("true", request.getAttribute("AUTHORIZATION_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () AUTHORIZATION_THRU_KEY:null<br>
     *         () authorizationController:null<br>
     *
     * <br>
     * ҒlF(ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:NullPointerExceptionF<br>
     *
     * <br>
     * authorizationControllernull̏ꍇANullPointerException邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter05() throws Exception {
        // O
        AuthorizationControlFilter filter = new AuthorizationControlFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();

        AuthorizationControlFilter_FilterChainStub01 filterChain
            = new AuthorizationControlFilter_FilterChainStub01();

        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (NullPointerException e) {
            // 
            // sȂ
            assertFalse(filterChain.isCalled);
        }

    }

    /**
     * testGetControllerClass01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() AUTHORIZATION_CONTROLLER_CLASS:AuthorizationController.class<br>
     *                static final<br>
     *
     * <br>
     * ҒlF(߂l) Class:OŐݒ肵CX^XƓ̃CX^X<br>
     *
     * <br>
     * n1̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetControllerClass01() throws Exception {
        // O
        AuthorizationControlFilter filter = new AuthorizationControlFilter();

        // eXg{
        Class actual = filter.getControllerClass();

        // 
        assertEquals(AuthorizationController.class,actual);
    }

    /**
     * testGetErrorCode01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() AUTHORIZATION_CONTROLLER_ERROR:"errors.authorization.controller"<br>
     *                static final<br>
     *
     * <br>
     * ҒlF(߂l) String:"errors.authorization.controller"<br>
     *
     * <br>
     * n1̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrorCode01() throws Exception {
        // O
        AuthorizationControlFilter filter = new AuthorizationControlFilter();

        // eXg{
        String actual = filter.getErrorCode();

        // 
        assertEquals("errors.authorization.controller",actual);
    }

    /**
     * testGetDefaultControllerBeanId01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() DEFAULT_AUTHORIZATION_BEAN_ID:"authorizationController"<br>
     *                static final<br>
     *
     * <br>
     * ҒlF(߂l) String:"authorizationController"<br>
     *
     * <br>
     * n1̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetDefaultControllerBeanId01() throws Exception {
        // O
        AuthorizationControlFilter filter = new AuthorizationControlFilter();

        // eXg{
        String actual = filter.getDefaultControllerBeanId();

        // 
        assertEquals("authorizationController",actual);
    }

}
