/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.xml.sax.SAXException;

import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.web.struts.reset.ActionReset;
import jp.terasoluna.fw.web.struts.reset.FieldReset;
import jp.terasoluna.fw.web.struts.reset.ResetterImpl;
import jp.terasoluna.fw.web.struts.reset.ResetterResources;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * tH[̃Zbgݒ[hvOCB<br>
 * PlugIn@\gpAT[ubgɃtH[̃Zbg@\̐ݒǂݍ݁AT[ubgReLXgɕۑB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
 */
public class ResetterPlugInTest extends TestCase {

    /**
     * t@CpXvpeB擾
     */
    private static final String RESET_FILE_NAME = ResetterPlugInTest.class
            .getResource("ResetterPlugInTest-reset.xml").getPath();

    /**
     * t@CpXvpeB擾
     */
    private static final String RESET_FILE_NAME2 = ResetterPlugInTest.class
            .getResource("ResetterPlugInTest-reset2.xml").getPath();

    /**
     * t@CpXvpeB擾
     */
    private static final String RESET_FILE_NAME3 = ResetterPlugInTest.class
            .getResource("ResetterPlugInTest-reset3.xml").getPath();

    /**
     * t@CpXvpeB擾
     */
    private static final String RESET_RULES_FILE_NAME = ResetterPlugInTest.class
            .getResource("ResetterPlugInTest-reset-rules.xml").getPath();
    
    /**
     * ResetterPlugInB
     */
    private ResetterPlugIn plugin = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ResetterPlugInTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        plugin = new ResetterPlugIn();
        UTUtil.setPrivateField(ResetterPlugIn.class, "digester", null);
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ResetterPlugInTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resetter:ResetterPlugIn_ResetterStub01i݂NXj<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml"i݂t@Cj<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:T[ubgReLXg"RESETTER_RESOURCES"L[ɂResetterResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) RESETTER:T[ubgReLXg"RESETTER"L[ɂResetterPlugIn_ResetterStub01CX^Xi[邱ƁB<br>
     *         
     * <br>
     * ɍs邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter",
                "jp.terasoluna.fw.web.struts.plugins."
                        + "ResetterPlugIn_ResetterStub01");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // Zbg[w
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // eXgs
        plugin.init(servlet, conf);
        
        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn_ResetterStub01",
                ((ResetterImpl) ctx.getAttribute("RESETTER")).getClass().getName());
        assertEquals(
                "jp.terasoluna.fw.web.struts.reset.ResetterResources",
                ((ResetterResources) ctx.getAttribute("RESETTER_RESOURCES"))
                        .getClass().getName());
    }

    /**
     * testInitResetter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resetter:null<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER:T[ubgReLXg"RESETTER"L[ɂResetterCX^Xi[邱ƁB<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * this.resetternull̎AɃftHgresetterT[ubgReLXgɒǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResetter01() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter", null);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResetter(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals("jp.terasoluna.fw.web.struts.reset.ResetterImpl",
                ((ResetterImpl) ctx.getAttribute("RESETTER")).getClass().getName());
    }

    /**
     * testInitResetter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resetter:""<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER:T[ubgReLXg"RESETTER"L[ɂResetterCX^Xi[邱ƁB<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * this.resetter󕶎̎AɃftHgresetterT[ubgReLXgɒǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResetter02() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter", "");

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResetter(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals("jp.terasoluna.fw.web.struts.reset.ResetterImpl",
                ((ResetterImpl) ctx.getAttribute("RESETTER")).getClass().getName());
    }

    /**
     * testInitResetter03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resetter:Nothingi݂ȂNXj<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFClassLoadException(ClassNotFoundException)<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFClassLoadException<br>
     *         
     * <br>
     * this.resetter݂ȂNX̎AServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResetter03() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter", "Nothing");

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        try {
            // eXgs
            plugin.initResetter(servlet, conf);
            fail();
        } catch (ServletException e) {
            // ʊmF
            assertEquals(ClassLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertEquals(ClassNotFoundException.class.getName(), e
                    .getRootCause().getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInitResetter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resetter:ResetterPlugIn_ResetterStub01i݂NXj<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER:T[ubgReLXg"RESETTER"L[ɂResetterPlugIn_ResetterStub01CX^Xi[邱ƁB<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * this.resetter݂NX̎AresetterT[ubgReLXgɒǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResetter04() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter",
                "jp.terasoluna.fw.web.struts.plugins."
                        + "ResetterPlugIn_ResetterStub01");

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResetter(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn_ResetterStub01",
                ((ResetterImpl) ctx.getAttribute("RESETTER")).getClass().getName());

    }

    /**
     * testInitResetter05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()="test1"<br>
     *         () this.resetter:ResetterPlugIn_ResetterStub01i݂NXj<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER:T[ubgReLXg"RESETTER/test1"L[ɂResetterPlugIn_ResetterStub01CX^Xi[邱ƁB<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * W[󕶎ȊO̎AT[ubgReLXgɓo^L[ɁAW[ǉĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResetter05() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("/test1");

        // Zb^[NXSCNXݒ
        UTUtil.setPrivateField(plugin, "resetter",
                "jp.terasoluna.fw.web.struts.plugins."
                        + "ResetterPlugIn_ResetterStub01");

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResetter(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn_ResetterStub01",
                ((ResetterImpl) ctx.getAttribute("RESETTER/test1")).getClass()
                        .getName());

    }

    /**
     * testInitResources01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:null<br>
     *         () digesterRules:|<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bZ[WF"resources file location is not specified"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"resources file location is not specified"<br>
     *         
     * <br>
     * this.resourcesPathnull̎ServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources01() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", null);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.initResources(servlet, conf);
            fail();
        } catch (ServletException e) {
            assertEquals("resources file location is not specified", e
                    .getMessage());
            assertTrue(LogUTUtil
                    .checkError("resources file location is not specified"));
        }
    }

    /**
     * testInitResources02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:""<br>
     *         () digesterRules:|<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bZ[WF"resources file location is not specified"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"resources file location is not specified"<br>
     *         
     * <br>
     * this.resourcesPath󕶎̎ServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources02() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", "");

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.initResources(servlet, conf);
            fail();
        } catch (ServletException e) {
            assertEquals("resources file location is not specified", e
                    .getMessage());
            assertTrue(LogUTUtil
                    .checkError("resources file location is not specified"));
        }
    }

    /**
     * testInitResources03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml"<br>
     *         () digesterRules:null<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:"/WEB-INF/reset-rules.xml"<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFXmlLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFXmlLoadException<br>
     *         
     * <br>
     * digesterRulesw肳ȂꍇAftHg̃t@Ci[Ă邱ƂmFB܂AdigesterRulest@C݂Ȃt@C̎ServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources03() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        try {
            // eXgs
            plugin.initResources(servlet, conf);
            fail();
        } catch (ServletException e) {
            assertEquals(XmlLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
            assertEquals("/WEB-INF/reset-rules.xml", UTUtil.getPrivateField(
                    plugin, "digesterRules"));
        }
    }

    /**
     * testInitResources04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml"<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():MalformedURLException<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFMalformedURLException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFMalformedURLException<br>
     *         
     * <br>
     * ServletContext#getResource()MalformedURLExceptionAServletExceptionŃbv邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources04() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME);
        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub02 servlet = new ResetterPlugIn_ActionServletStub02();

        try {
            // eXgs
            plugin.initResources(servlet, conf);
            fail();
        } catch (ServletException e) {
            assertEquals(MalformedURLException.class.getName(), e
                    .getRootCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
            assertEquals(RESET_RULES_FILE_NAME, UTUtil.getPrivateField(plugin,
                    "digesterRules"));
        }
    }
    
    /**
     * testInitResources05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml"<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:T[ubgReLXg"RESETTER_RESOURCES"L[ɂResetterResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * RESETTER_RESOURCESL[ɂāAɃT[ubgReLXgɒǉĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources05() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME);
        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResources(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.reset.ResetterResources",
                ((ResetterResources) ctx.getAttribute("RESETTER_RESOURCES"))
                        .getClass().getName());
    }

    /**
     * testInitResources06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()="/test2"<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml"<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:T[ubgReLXg"RESETTER_RESOURCES/test2"L[ɂResetterResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * W[󕶎ȊO̎AT[ubgReLXgɓo^L[ɁAW[ǉĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources06() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("/test2");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME);
        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResources(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.reset.ResetterResources",
                ((ResetterResources) ctx
                        .getAttribute("RESETTER_RESOURCES/test2")).getClass()
                        .getName());
    }

    /**
     * testInitResources07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"nothing.xml"i݂Ȃt@Cj<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFIOException<br>
     *         
     * <br>
     * this.resourcePathɑ݂Ȃt@Cw肵ꍇAServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources07() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", "nothing.xml");

        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.initResources(servlet, conf);
            fail();
        } catch (ServletException e) {
            // ʊmF
            // ۂ̏ꍇ́AMalformedURLException邪AcatchIOExceptionȂ̂instanceofŃ`FbN
            assertTrue(e.getRootCause() instanceof IOException);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }
    
    /**
     * testInitResources08()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-error-reset.xml"(p[XG[t@C)<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFSAXException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFSAXException<br>
     *         
     * <br>
     * this.resourcesPathɃp[XG[t@Cw肵AServletException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources08() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath",
                ResetterPlugInTest.class.getResource(
                        "ResetterPlugInTest-error-reset.xml").getPath());

        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, conf);
            fail();
        } catch (ServletException e) {
            // ʊmF
            // ۂ̏ꍇ́ASAXParseException邪AcatchSAXExceptionȂ̂instanceofŃ`FbN
            assertTrue(e.getRootCause() instanceof SAXException);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }
    
    /**
     * testInitResources09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml","ResetterPlugInTest-reset2.xml","ResetterPlugInTest-reset3.xml"<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:T[ubgReLXg"RESETTER_RESOURCES"L[ɂResetterResourcesCX^Xi[邱ƁBiResetterResources̒g̊mFsȂj<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * this.resourcesPathɕ̃t@Cw肵ARESETTER_RESOURCESL[ɂāAɃT[ubgReLXgɒǉĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources09() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME + ","
                + RESET_FILE_NAME2 + "," + RESET_FILE_NAME3);
        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        plugin.initResources(servlet, conf);

        // ʊmF
        // T[ubgReLXg擾
        ServletContext ctx = servlet.getServletContext();
        assertEquals(
                "jp.terasoluna.fw.web.struts.reset.ResetterResources",
                ((ResetterResources) ctx.getAttribute("RESETTER_RESOURCES"))
                        .getClass().getName());

        // XMLp[Xʂ擾
        ResetterResources resource = (ResetterResources) ctx
                .getAttribute("RESETTER_RESOURCES");
        Map actionResets = (Map) UTUtil.getPrivateField(resource,
                "actionResets");

        // Pt@Cڂresett@Cɓǂݍ߂Ă邱
        ActionReset actionReset1_1 = (ActionReset) actionResets
                .get("/changePage");
        // fieldReset`FbN
        Map fieldResets1_1 = (Map) UTUtil.getPrivateField(actionReset1_1,
                "fieldResets");
        assertEquals(1, fieldResets1_1.size());
        FieldReset fieldReset1_1 = (FieldReset) fieldResets1_1.get("field1-1");
        assertEquals("field1-1", fieldReset1_1.getFieldName());
        assertFalse(fieldReset1_1.isSelect());

        ActionReset actionReset1_2 = (ActionReset) actionResets.get("/bbb/BBB");
        // fieldReset`FbN
        Map fieldResets1_2 = (Map) UTUtil.getPrivateField(actionReset1_2,
                "fieldResets");
        assertEquals(3, fieldResets1_2.size());
        FieldReset fieldReset1_2 = (FieldReset) fieldResets1_2.get("field1-1");
        assertEquals("field1-1", fieldReset1_2.getFieldName());
        assertFalse(fieldReset1_2.isSelect());
        FieldReset fieldReset1_3 = (FieldReset) fieldResets1_2.get("field1-2");
        assertEquals("field1-2", fieldReset1_3.getFieldName());
        assertTrue(fieldReset1_3.isSelect());
        FieldReset fieldReset1_4 = (FieldReset) fieldResets1_2.get("field1-3");
        assertEquals("field1-3", fieldReset1_4.getFieldName());
        assertTrue(fieldReset1_4.isSelect());

        ActionReset actionReset1_3 = (ActionReset) actionResets.get("/ccc/CCC");
        // fieldReset`FbN
        Map fieldResets1_3 = (Map) UTUtil.getPrivateField(actionReset1_3,
                "fieldResets");
        assertEquals(2, fieldResets1_3.size());
        FieldReset fieldReset1_5 = (FieldReset) fieldResets1_3.get("field1-1");
        assertEquals("field1-1", fieldReset1_5.getFieldName());
        assertFalse(fieldReset1_5.isSelect());
        FieldReset fieldReset1_6 = (FieldReset) fieldResets1_3.get("field1-2");
        assertEquals("field1-2", fieldReset1_6.getFieldName());
        assertFalse(fieldReset1_6.isSelect());

        // Qt@Cڂresett@Cɓǂݍ߂Ă邱
        ActionReset actionReset2_1 = (ActionReset) actionResets
                .get("/aaa/AAA2");
        // fieldReset`FbN
        Map fieldResets2_1 = (Map) UTUtil.getPrivateField(actionReset2_1,
                "fieldResets");
        assertEquals(1, fieldResets2_1.size());
        FieldReset fieldReset2_1 = (FieldReset) fieldResets2_1.get("field2-1");
        assertEquals("field2-1", fieldReset2_1.getFieldName());
        assertFalse(fieldReset2_1.isSelect());

        ActionReset actionReset2_2 = (ActionReset) actionResets
                .get("/bbb/BBB2");
        // fieldReset`FbN
        Map fieldResets2_2 = (Map) UTUtil.getPrivateField(actionReset2_2,
                "fieldResets");
        assertEquals(3, fieldResets2_2.size());
        FieldReset fieldReset2_2 = (FieldReset) fieldResets2_2.get("field2-1");
        assertEquals("field2-1", fieldReset2_2.getFieldName());
        assertFalse(fieldReset2_2.isSelect());
        FieldReset fieldReset2_3 = (FieldReset) fieldResets2_2.get("field2-2");
        assertEquals("field2-2", fieldReset2_3.getFieldName());
        assertTrue(fieldReset2_3.isSelect());
        FieldReset fieldReset2_4 = (FieldReset) fieldResets2_2.get("field2-3");
        assertEquals("field2-3", fieldReset2_4.getFieldName());
        assertTrue(fieldReset2_4.isSelect());

        ActionReset actionReset2_3 = (ActionReset) actionResets
                .get("/ccc/CCC2");
        // fieldReset`FbN
        Map fieldResets2_3 = (Map) UTUtil.getPrivateField(actionReset2_3,
                "fieldResets");
        assertEquals(2, fieldResets2_3.size());
        FieldReset fieldReset2_5 = (FieldReset) fieldResets2_3.get("field2-1");
        assertEquals("field2-1", fieldReset2_5.getFieldName());
        assertFalse(fieldReset2_5.isSelect());
        FieldReset fieldReset2_6 = (FieldReset) fieldResets2_3.get("field2-2");
        assertEquals("field2-2", fieldReset2_6.getFieldName());
        assertFalse(fieldReset2_6.isSelect());

        // Rt@Cڂresett@Cɓǂݍ߂Ă邱
        ActionReset actionReset3_1 = (ActionReset) actionResets
                .get("/aaa/AAA3");
        // fieldReset`FbN
        Map fieldResets3_1 = (Map) UTUtil.getPrivateField(actionReset3_1,
                "fieldResets");
        assertEquals(1, fieldResets3_1.size());
        FieldReset fieldReset3_1 = (FieldReset) fieldResets3_1.get("field3-1");
        assertEquals("field3-1", fieldReset3_1.getFieldName());
        assertFalse(fieldReset3_1.isSelect());

        ActionReset actionReset3_2 = (ActionReset) actionResets
                .get("/bbb/BBB3");
        // fieldReset`FbN
        Map fieldResets3_2 = (Map) UTUtil.getPrivateField(actionReset3_2,
                "fieldResets");
        assertEquals(3, fieldResets3_2.size());
        FieldReset fieldReset3_2 = (FieldReset) fieldResets3_2.get("field3-1");
        assertEquals("field3-1", fieldReset3_2.getFieldName());
        assertFalse(fieldReset3_2.isSelect());
        FieldReset fieldReset3_3 = (FieldReset) fieldResets3_2.get("field3-2");
        assertEquals("field3-2", fieldReset3_3.getFieldName());
        assertTrue(fieldReset3_3.isSelect());
        FieldReset fieldReset3_4 = (FieldReset) fieldResets3_2.get("field3-3");
        assertEquals("field3-3", fieldReset3_4.getFieldName());
        assertTrue(fieldReset3_4.isSelect());

        ActionReset actionReset3_3 = (ActionReset) actionResets
                .get("/ccc/CCC3");
        // fieldReset`FbN
        Map fieldResets3_3 = (Map) UTUtil.getPrivateField(actionReset3_3,
                "fieldResets");
        assertEquals(2, fieldResets3_3.size());
        FieldReset fieldReset3_5 = (FieldReset) fieldResets3_3.get("field3-1");
        assertEquals("field3-1", fieldReset3_5.getFieldName());
        assertFalse(fieldReset3_5.isSelect());
        FieldReset fieldReset3_6 = (FieldReset) fieldResets3_3.get("field3-2");
        assertEquals("field3-2", fieldReset3_6.getFieldName());
        assertFalse(fieldReset3_6.isSelect());

        // Qt@CڂƂRt@Cڂresett@CɏdpX݂ꍇA
        // ォݒ肳ꂽt@C̏񂪐ݒ肳Ă邱
        ActionReset actionResetDuplicate = (ActionReset) actionResets
                .get("/duplicate");
        // fieldReset`FbN
        Map duplicate = (Map) UTUtil.getPrivateField(actionResetDuplicate,
                "fieldResets");
        assertEquals(1, duplicate.size());
        FieldReset fieldReset1 = (FieldReset) duplicate.get("duplicate1");
        assertNull(fieldReset1);
        FieldReset fieldReset2 = (FieldReset) duplicate.get("duplicate2");
        assertEquals("duplicate2", fieldReset2.getFieldName());
        assertFalse(fieldReset2.isSelect());
    }

    /**
     * testInitResources10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () this.resourcePath:"ResetterPlugInTest-reset.xml","ResetterPlugInTest-reset2.xml","ResetterPlugInTest-reset3.xml"<br>
     *         () digesterRules:"ResetterPlugInTest-reset-rules.xml"<br>
     *         () ServletContext#getResource():|<br>
     *         
     * <br>
     * ҒlF(ԕω) RESETTER_RESOURCES:|<br>
     *         (ԕω) digesterRules:|<br>
     *         (ԕω) O:ServletException<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFIOException<br>
     *         
     * <br>
     * getPublicIdentifier()̖߂肪󔒂ŁAURL̃IuWFNgłȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitResources10() throws Exception {
        // W[ݒ
        ModuleConfig conf = new ModuleConfigImpl("");

        plugin = new ResetterPlugIn() {
            @Override
            public String getPublicIdentifier() {
            	return "";
            }
        };

        // reset.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "resourcesPath", RESET_FILE_NAME + ","
                + RESET_FILE_NAME2 + "," + RESET_FILE_NAME3);
        // reset-rules.xml̃pXݒ
        UTUtil.setPrivateField(plugin, "digesterRules", RESET_RULES_FILE_NAME);

        // ANVT[ubg쐬
        ResetterPlugIn_ActionServletStub01 servlet = new ResetterPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.initResources(servlet, conf);
            fail("eXgs");
        } catch (ServletException e) {
        	assertTrue(e.getRootCause() instanceof IOException);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }

    }

    /**
     * testSetResetter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() string:"string"<br>
     *         () resetter:null<br>
     *         
     * <br>
     * ҒlF(ԕω) resetter:"string"<br>
     *         
     * <br>
     * stringi[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetResetter01() throws Exception {
        // ݒ
        ResetterPlugIn rpi = new ResetterPlugIn();
        // eXgs
        rpi.setResetter("string");
        // ʊmF
        assertEquals("string", UTUtil.getPrivateField(rpi, "resetter"));
    }

    /**
     * testSetResources01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() string:"string"<br>
     *         () resourcesPath:null<br>
     *         
     * <br>
     * ҒlF(ԕω) resourcesPath:"string"<br>
     *         
     * <br>
     * stringi[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetResources01() throws Exception {
        // ݒ
        ResetterPlugIn rpi = new ResetterPlugIn();
        // eXgs
        rpi.setResources("string");
        // ʊmF
        assertEquals("string", UTUtil.getPrivateField(rpi, "resourcesPath"));
    }

    /**
     * testSetDigesterRules01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() digesterRules:"string"<br>
     *         () digesterRules:null<br>
     *         
     * <br>
     * ҒlF(ԕω) digesterRules:"string"<br>
     *         
     * <br>
     * digesterRulesi[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDigesterRules01() throws Exception {
        // ݒ
        ResetterPlugIn rpi = new ResetterPlugIn();
        // eXgs
        rpi.setDigesterRules("string");
        // ʊmF
        assertEquals("string", UTUtil.getPrivateField(rpi, "digesterRules"));
    }

    /**
     * testSetPublicIdentifier01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() publicIdentifier:"publicIdentifier"<br>
     *         () publicIdentifier:not nulliftHglj<br>
     *
     * <br>
     * ҒlF(ԕω) publicIdentifier:"publicIdentifier"<br>
     *
     * <br>
     * publicIdentifieri[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetPublicIdentifier01() throws Exception {
        // eXg{
        plugin.setPublicIdentifier("publicIdentifier");

        // 
        assertEquals("publicIdentifier", UTUtil.getPrivateField(plugin,
                "publicIdentifier"));
    }

    /**
     * testSetDtdUrl01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dtdUrl:"dtdUrl"<br>
     *         () dtdUrl:not nulliftHglj<br>
     *
     * <br>
     * ҒlF(ԕω) dtdUrl:"dtdUrl"<br>
     *
     * <br>
     * dtdUrli[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetDtdUrl01() throws Exception {
        // eXg{
        plugin.setDtdUrl("dtdUrl");

        // 
        assertEquals("dtdUrl", UTUtil.getPrivateField(plugin, "dtdUrl"));
    }

}
