/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;

import junit.framework.TestCase;

/**
 * IfErrorsTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class IfErrorsTagTest extends TestCase {

    //eXgΏ
    IfErrorsTag tag = null;

    /**
     * Constructor for IfErrorsTagTest.
     * @param arg0
     */
    public IfErrorsTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (IfErrorsTag) TagUTUtil.create(IfErrorsTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * requestErrors=Not Null<br>
     * sessionErrors=Not Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * <br>
     * NGXg擾G[Nullł͂Ȃ
     * ZbV擾G[Nullł͂Ȃꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag01() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();
        ActionMessages errors = new ActionMessages();
        errors.add(Globals.ERROR_KEY, new ActionMessage(""));
        rq.setAttribute(Globals.ERROR_KEY, errors);

        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, errors);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

    } /* testDoStartTag1 End */

    /**
     * testDoStartTag02B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * requestErrors=Null<br>
     * sessionErrors=Not Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * <br>
     * NGXg擾G[Null
     * ZbV擾G[Nullł͂Ȃꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag02() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();
        ActionMessages errors = new ActionMessages();
        errors.add(Globals.ERROR_KEY, new ActionMessage(""));
        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, errors);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

    } /* testDoStartTag2 End */

    /**
     * testDoStartTag03B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * requestErrors=Not Null<br>
     * sessionErrors=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * <br>
     * NGXg擾G[Nullł͂Ȃ
     * ZbV擾G[Nullꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag03() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();
        ActionMessages errors = new ActionMessages();
        errors.add(Globals.ERROR_KEY, new ActionMessage(""));
        rq.setAttribute(Globals.ERROR_KEY, errors);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

    } /* testDoStartTag3 End */

    /**
     * testDoStartTag04B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * requestErrors=Null<br>
     * sessionErrors=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=SKIP_BODY<br>
     * <br>
     * NGXg擾G[Null
     * ZbV擾G[Nullꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag04() throws Exception {

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag4 End */

    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * Ȃ<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * 
     * EVAL_PAGEԋp邱ƂmF<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoEndTag01() throws Exception {
        // eXgs
        int result = tag.doEndTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    }

} /* IfErrorsTagTest Class End */
