/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.terasoluna.fw.web.struts.form.FieldChecksEx;

import org.apache.struts.taglib.html.JavascriptValidatorTag;

/**
 * Struts񋟂AJavascriptValidatorTagNXgNXB
 * vpeBt@C擾pJiASpJi
 * Javascript̕ϐƂďo͂B
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p> <code>&lt;html:javascript&gt;</code> ^O <code>API</code> QƁB</p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class JavascriptValidatorTagEx extends JavascriptValidatorTag {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = 879915691393426820L;

	/**
     * ^O̕]JnɌĂ΂B
     * pJiASpJĩXgFieldCheckExNX̕ϐ
     * 擾AJavaScript̕ϐƂďo͂B
     * @return 
     * @throws JspException s̗O
     */
    @Override
    public int doStartTag() throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(this.renderKanaList());

        } catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return super.doStartTag();
    }

    /**
     * FieldCheckExNX甼pJiASpJi擾A
     * JavaScript̕ϐ`̕ƂĕҏWAԋpB
     *
     * @return pJiASpJi̕ϐ`
     */
    protected String renderKanaList() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.renderStartElement());
        if ("true".equalsIgnoreCase(htmlComment)) {
            builder.append(HTML_BEGIN_COMMENT);
        }
        builder.append("var hankakuKanaList = \"");
        builder.append(FieldChecksEx.getHankakuKanaList() + "\";" + "\n");
        builder.append("var zenkakuKanaList = \"");
        builder.append(FieldChecksEx.getZenkakuKanaList() + "\";" + "\n");
        builder.append(super.getJavascriptEnd());
        return builder.toString();
    }

}
