/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.web.thin.AuthorizationControlFilter;
import jp.terasoluna.fw.web.thin.AuthorizationController;

/**
 * <p>
 *  <code>ifAuthorized</code> ^O̎NXB
 * </p>
 *
 * <p>
 *  NGXg <code>path</code> Ŏw肳ꂽpXɑ΂ăANZX
 *  ꍇɂ̂݁A^Õ{fBo͂BANZXȂꍇɂ́A
 *  PɖBANZX̃`FbŃA
 *  {@link
 *  jp.terasoluna.fw.web.thin.AuthorizationController}
 *  ֈϏB
 * </p>
 *
 * <br>
 * <h5>^OT|[g鑮</h5>
 * <p>{@link IfAuthorizedTag} ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>path</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ΏۂƂȂ <code>path</code>B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>blockId</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ̃^O̐eƂȂ {@link IfAuthorizedBlockTag}
 *     ƕRtׂ <code>blockId</code>B
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <code><pre>
 * &lt;t:ifAuthorized parh="/pathToSomewhere"&gt;
 *   ... // 胆[Û݂̕\ړ
 * &lt;/t:ifAuthorized&gt;
 * </pre></code></p>
 *
 * @see jp.terasoluna.fw.web.taglib.IfAuthorizedBlockTag
 * @see
 * jp.terasoluna.fw.web.thin.AuthorizationController
 *
 */
public class IfAuthorizedTag extends TagSupport {
    
    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -4929834014631292954L;

	/**
     * pXB
     */
    private String path = null;

    /**
     * ubNIDB
     */
    private String blockId = null;

    /**
     * pXݒ肷B
     *
     * @param path pXB
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * ubNIDݒ肷B
     *
     * @param blockId ubNID
     */
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB<code>AccessConrol</code>
     * Ƀ`FbNϏA<code>path</code>
     * ɑ΂ăANZXƂɂ̓^Õ{fBo͂A
     * ANZXȂƂɂ̓{fBXLbvB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        HttpServletRequest req
            = (HttpServletRequest) pageContext.getRequest();

        // AuthorizationController擾
        AuthorizationController ac
             = AuthorizationControlFilter.getAuthorizationController();

        // ANZX`FbN
        boolean isAuthorized = ac.isAuthorized(this.path, req);

        if (isAuthorized) {
            if (this.blockId != null) {
                // ANZX`FbNʂubNɒǉĕۑ
                pageContext.setAttribute(this.blockId, new Boolean(true));
            }
            // ANZXƂ̓{fB]
            return EVAL_BODY_INCLUDE;
        }
		// ȂƂ̓{fB]XLbv
		return SKIP_BODY;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.path = null;
        this.blockId = null;
    }

}
