/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.FormPropertyConfig;

/**
 * ANVtH[֘Ã[eBeBNXB
 *
 * <p>
 *  ANVtH[֘Aŗp@\[eBeB
 *  ƂďW񂵂ĂB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FormEx
 * @see
 *  jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
 * @see
 *  jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
 *
 */
public class ActionFormUtil {

    /**
     * w肵tB[h̐ݒ擾B
     *
     * @param fieldName tB[h
     * @param mapping }bsO
     * @return FormPropertyConfig
     */
    public static FormPropertyConfig getPropertyConfig(
        String fieldName,
        ActionMapping mapping) {
        String name = mapping.getName();
        if (name == null) {
            return null;
        }
        FormBeanConfig config =
            mapping.getModuleConfig().findFormBeanConfig(name);
        if (config == null) {
            return null;
        }
        return config.findFormPropertyConfig(fieldName);
    }

    /**
     * DynaActionForm̎w肳ꂽvpeBl
     * B
     *
     * @param form DynaActionForm ̃CX^X
     * @param fieldName Ώۂ̃vpeB
     * @param mapping ANV}bsO
     */
    public static void initialize(
        DynaActionForm form,
        String fieldName,
        ActionMapping mapping) {
        // p[^l̃`FbN
        if (form == null
            || fieldName == null
            || "".equals(fieldName)
            || mapping == null) {
            return;
        }

        FormPropertyConfig config =
            ActionFormUtil.getPropertyConfig(fieldName, mapping);
        if (config == null) {
            return;
        }
        form.set(fieldName, config.initial());

    }

    /**
     *  ZbVXR[vɊi[ꂽ_&quot;_&quot;Ŏn܂SĂ
     *  ANVtH[폜郆[eBeB\bhB
     *
     * <p>
     *   exclude Ŏw肳ꂽANVtH[͍폜ȂB
     * </p>
     *
     * @param session HTTPZbV
     * @param exclude 폜ΏۂƂȂANVtH[
     */
    public static void clearActionForm(HttpSession session, String exclude) {

        Enumeration enumeration = session.getAttributeNames();
        List<String> removeList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String key = (String) enumeration.nextElement();
            if (key.startsWith("_")) {
                if (exclude == null || !key.equals(exclude)) {
                    if (session.getAttribute(key) instanceof ActionForm) {
                        removeList.add(key);
                    }
                }
            }
        }

        int cnt = removeList.size();
        for (int i = 0; i < cnt; i++) {
            String removeKey = removeList.get(i);
            session.removeAttribute(removeKey);
        }
    }

    /**
     * ZbVXR[vɊi[ꂽ_&quot;_&quot;
     * n܂SẴANVtH[폜郆[eBeB\bhB
     *
     * @param session HTTPZbV
     */
    public static void clearActionForm(HttpSession session) {
        clearActionForm(session, null);
    }

    /**
     *  HTTPNGXgƂĐݒ肳ĂANV}bsO
     *  ANVtH[擾B
     *
     * @param req HTTPNGXg
     * @return ANVtH[
     */
    public static String getActionFormName(HttpServletRequest req) {
        ActionMapping mapping =
            (ActionMapping) req.getAttribute(Globals.MAPPING_KEY);
        if (mapping == null) {

            // ȍ~͎sȂ
            return null;
        }
        return mapping.getName();
    }

}
