/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.ServerBlockageControlFilter;
import jp.terasoluna.fw.web.thin.ServerBlockageController;

/**
 * <p><code>ifPreBlockade</code> ^O̎NX</p>
 * <p>
 *  {@link IfPreBlockadeTag}
 * </p>
 *
 * <p>
 *  T[oǏԖ͗\ǏԂ̏ꍇɂ̂݁A^Õ{fBo͂B
 *  ʏ펞ɂ͒PɖBT[oǂ̃`FbŃA
 *  {@link
 *  jp.terasoluna.fw.web.thin.ServerBlockageController}
 *  ֈϏB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p>̃^OɂĐݒ肳鑮͂܂B</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <code><pre>
 * &lt;t:ifPreBlockade&gt;
 *   ... // T[oǏԖ͗\ǏԂ̏ꍇɂ݂̂̕\ړ
 * &lt;/t:ifPreBlockade&gt;
 * </pre></code></p>
 *
 * @see
 * jp.terasoluna.fw.web.thin.ServerBlockageController
 *
 */
public class IfPreBlockadeTag extends TagSupport {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -7545297874735975274L;

	/**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException O
     */
    @Override
    public int doStartTag() throws JspException {

        ServerBlockageController sbc =
            ServerBlockageControlFilter.getServerBlockageController();

        String pathInfo = RequestUtil.getPathInfo(pageContext.getRequest());

        if (sbc.isPreBlockaded() || sbc.isBlockaded(pathInfo)) {
            // \ǏԂ܂͕ǏԂ̂Ƃ̓{fB]
            return EVAL_BODY_INCLUDE;
        }
		// {fB]XLbv
		return SKIP_BODY;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException O
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

}
