/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import jp.terasoluna.fw.util.StringUtil;

/**
 * <p>
 *  ̍̃zCgXy[X폜ltrim^O̎NXB
 * </p>
 *
 * <p>
 *  {@link jp.terasoluna.fw.util.StringUtil} NX
 *  <code>ltrim()</code> \bhɂĕ̍̃zCgXy[X
 *  폜B
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p> {@link StringFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p> {@link StringFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p>
 *  <code>&quot;form0001&quot;</code> bean
 *  <code>&quot;field001&quot;</code> vpeB̒l̃zCgXy[X
 *  ďo͂ɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:ltrim name="form0001"
 *              property="field001" /&gt;
 * </pre></code></p>
 *
 * <p>
 *  L beañvpeBAJX^^Oŏo͂ɃXNveBOϐ
 *  <code>&quot;trimmed&quot;</code>փZbgꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:ltrim id="trimmed"
 *              name="form0001"
 *              property="field001" /&gt;
 * </pre></code></p>
 *
 * <p>
 *  zCgXy[X錳̕beanoɁA
 *  JX^^O <code>value</code>
 *  ɂĎw肷ꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:ltrim value="zCgXy[XO̕  " /&gt;
 * </pre></code></p>
 *
 * @see jp.terasoluna.fw.web.taglib.StringFormatterTagBase
 *
 * 
 */
public class LTrimTag extends StringFormatterTagBase {

	/**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -6952812606364915110L;

	/**
     * SpXy[X̃gۑB
     */
    protected boolean zenkaku = false;

    /**
     * SpXy[X̃gۑ擾B
     *
     * @return SpXy[X̃gۑ
     */
    public boolean getZenkaku() {
        return this.zenkaku;
    }

    /**
     * SpXy[X̃gۑݒ肷B
     *
     * @param zenkaku SpXy[X̃gۑ
     */
    public void setZenkaku(boolean zenkaku) {
        this.zenkaku = zenkaku;
    }

    /**
     * w肳ꂽ̍̃zCgXy[X폜B
     *
     * @param s tH[}bgΏۂ̕
     * @return ̃zCgXy[X폜ꂽ
     */
    @Override
    protected String doFormat(String s) {
    	if (zenkaku) {
    		return StringUtil.ltrimZ(s);
    	}
        return StringUtil.ltrim(s);
    }

}
