/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.fw.validation.FieldChecks;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest04 extends TestCase {

    /**
     * eXgpCX^XB
     */
    private ValidatorAction va = null;

    /**
     * eXgpCX^XB
     */
    private Field field = null;

    /**
     * eXgpCX^XB
     */
    private FieldChecks_ValidationErrorsImpl01 errors = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest04.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        va = new ValidatorAction();
        field = new Field();
        errors = new FieldChecks_ValidationErrorsImpl01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest04(String name) {
        super(name);
    }

    /**
     * testValidateIntRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateIntRange(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateIntRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"1.5"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beanint^ɕϊłȂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange03() throws Exception {
        // eXg{
        // 
        assertFalse(new FieldChecks().validateIntRange("1.5", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("1.5", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateIntRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"-2147483648"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varintRangeMinnull̏ꍇA
     * ͈͂̍ŏlInteger.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange04() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("-2147483648", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"-2147483649"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varintRangeMinnull̏ꍇA
     * ͈͂̍ŏlInteger.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange05() throws Exception {
        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("-2147483649", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("-2147483649", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateIntRange06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"-2147483648"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varintRangeMin󕶎̏ꍇA
     * ͈͂̍ŏlInteger.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange06() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("-2147483648", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"-2147483649"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varintRangeMin󕶎̏ꍇA
     * ͈͂̍ŏlInteger.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange07() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("-2147483649", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("-2147483649", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateIntRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2147483647"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMax=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varintRangeMaxnull̏ꍇA
     * ͈͂̍őlInteger.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange08() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("2147483647", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2147483648"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMax=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varintRangeMaxnull̏ꍇA
     * ͈͂̍őlInteger.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange09() throws Exception {
        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("2147483648", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("2147483648", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateIntRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2147483647"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMax=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varintRangeMax󕶎̏ꍇA
     * ͈͂̍őlInteger.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange10() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("2147483647", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateIntRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2147483648"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMax=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varintRangeMax󕶎̏ꍇA
     * ͈͂̍őlInteger.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange11() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("2147483648", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("2147483648", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateIntRange12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin="1.5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - intRangeMin is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - intRangeMin is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varintRangeMin̒lint^ɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange12() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMin");
        var.setValue("1.5");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateIntRange("5", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- intRangeMin is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateIntRange13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMax="5.5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - intRangeMax is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - intRangeMax is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varintRangeMax̒lint^ɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange13() throws Exception {
        // O
        Var var = new Var();
        var.setName("intRangeMax");
        var.setValue("5.5");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateIntRange("5", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- intRangeMax is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateIntRange14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin="1"<br>
     *                intRangeMax="10"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lAintRangeMinintRangeMax͈͓̔̒l̏ꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange14() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("intRangeMin");
        var1.setValue("1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("intRangeMax");
        var2.setValue("10");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("5", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateIntRange15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin="6"<br>
     *                intRangeMax="10"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAintRangeMin̒l菬ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange15() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("intRangeMin");
        var1.setValue("6");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("intRangeMax");
        var2.setValue("10");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("5", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("5", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));

    }

    /**
     * testValidateIntRange16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin="1"<br>
     *                intRangeMax="4"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAintRangeMax̒l傫ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange16() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("intRangeMin");
        var1.setValue("1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("intRangeMax");
        var2.setValue("4");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateIntRange("5", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("5", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));

    }

    /**
     * testValidateIntRange17()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                intRangeMin="5"<br>
     *                intRangeMax="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lƁAintRangeMax,intRangeMin̒lƓꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateIntRange17() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("intRangeMin");
        var1.setValue("5");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("intRangeMax");
        var2.setValue("5");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateIntRange("5", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateDoubleRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateDoubleRange(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateDoubleRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beandouble^ɕϊłȂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange03() throws Exception {
        // eXg{
        // 
        assertFalse(new FieldChecks().validateDoubleRange("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateDoubleRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"4.9E-324"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * vardoubleRangeMinnull̏ꍇA
     * ͈͂̍ŏlDouble.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange04() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange("4.9E-324", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"4.9E-324"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * vardoubleRangeMin󕶎̏ꍇA
     * ͈͂̍ŏlDouble.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange05() throws Exception {
        // O
        Var var = new Var();
        var.setName("doubleRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange("4.9E-324", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"1.7976931348623157E308"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMax=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * vardoubleRangeMaxnull̏ꍇA͈͂̍őlDouble.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange06() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange(
                        "1.7976931348623157E308", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"1.7976931348623157E308"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMax=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * vardoubleRangeMax󕶎̏ꍇA͈͂̍őlDouble.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange07() throws Exception {
        // O
        Var var = new Var();
        var.setName("doubleRangeMax");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange(
                        "1.7976931348623157E308", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateDoubleRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - doubleRangeMin is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - doubleRangeMin is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * vardoubleRangeMin̒ldouble^ɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange08() throws Exception {
        // O
        Var var = new Var();
        var.setName("doubleRangeMin");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateDoubleRange("0.5E1", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- doubleRangeMin is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateDoubleRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMax="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - doubleRangeMax is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - doubleRangeMax is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * vardoubleRangeMax̒ldouble^ɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange09() throws Exception {
        // O
        Var var = new Var();
        var.setName("doubleRangeMax");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateDoubleRange("0.5E1", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- doubleRangeMax is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateDoubleRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin="0.1E1"<br>
     *                doubleRangeMax="0.1E2"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lAdoubleRangeMindoubleRangeMax͈͓̔̒l̏ꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange10() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("doubleRangeMin");
        var1.setValue("0.1E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("doubleRangeMax");
        var2.setValue("0.1E2");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateDoubleRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin="0.1E2"<br>
     *                doubleRangeMax="0.1E3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAdoubleRangeMin̒l菬ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange11() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("doubleRangeMin");
        var1.setValue("0.1E2");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("doubleRangeMax");
        var2.setValue("0.1E3");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateDoubleRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("0.5E1", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateDoubleRange12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin="0.1E1"<br>
     *                doubleRangeMax="0.4E1"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAdoubleRangeMax̒l傫ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange12() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("doubleRangeMin");
        var1.setValue("0.1E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("doubleRangeMax");
        var2.setValue("0.4E1");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateDoubleRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("0.5E1", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateDoubleRange13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                doubleRangeMin="0.5E1"<br>
     *                doubleRangeMax="0.5E1"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lƁAdoubleRangeMax,doubleRangeMin̒lƓꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDoubleRange13() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("doubleRangeMin");
        var1.setValue("0.5E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("doubleRangeMax");
        var2.setValue("0.5E1");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateDoubleRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

}
