package net.takemix.testok;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;

import net.takemix.testok.db.TestokDataBaseHelper;
import net.takemix.testok.db.TestokDataBaseHelper.QuestionType;
import android.app.AlertDialog;
import android.app.Application;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class Testok extends  Application {
    public enum ToeicLevel {
        TL_A,
        TL_B,
        TL_C,
        TL_D,
        TL_E,
        TL_END;

        public Integer getMaxLevel () {
            switch(this) {
            case TL_A:
                return 10;
            case TL_B:
                return 8;
            case TL_C:
                return 6;
            case TL_D:
                return 4;
            case TL_E:
                return 2;
            default:
                break;
            }
            return -1;
        }

        public Integer getMinLevel () {
            switch(this) {
            case TL_A:
                return 8;
            case TL_B:
                return 6;
            case TL_C:
                return 4;
            case TL_D:
                return 2;
            case TL_E:
                return 1;
            default:
                break;
            }
            return -1;
        }
    }

    int ScoreTableByListening[] = {
        96, 480, 495,
        91, 470, 495,
        86, 440, 490,
        81, 410, 460,
        76, 390, 430,
        71, 360, 400,
        66, 330, 370,
        61, 300, 345,
        56, 270, 315,
        51, 240, 285,
        46, 210, 255,
        41, 180, 225,
        36, 150, 195,
        31, 120, 165,
        26, 90, 135,
        21, 60, 105,
        16, 40, 75,
        11, 10, 45,
        6, 5, 20,
        1, 5, 5,
        0, 5, 5,
        0
    };

    int ScoreTableByReading[] = {
        96, 450, 495,
        91, 420, 465,
        86, 400, 435,
        81, 370, 410,
        76, 340, 380,
        71, 310, 355,
        66, 280, 325,
        61, 260, 300,
        56, 230, 270,
        51, 200, 245,
        46, 170, 215,
        41, 140, 185,
        36, 120, 160,
        31, 90, 130,
        26, 60, 105,
        21, 30, 75,
        16, 10, 50,
        11, 5, 20,
        6, 5, 5,
        1, 5, 5,
        0, 5, 5,
        0
    };

    private static final String tag = "Testok";

    public String userName;
    public ToeicLevel level;
    public Integer untilDays;
    public Integer studyTime;
    public Date examDate;
    public Integer currentScore;
    public TestokDataBaseHelper db;
    public EnumSet<QuestionType> mockexamQuestionTypes;
    public ArrayList<Question> questionArray;

    @Override
    public void onCreate() {
        super.onCreate();
        Log.i(tag, "onCreate - IN");

        this.db = new TestokDataBaseHelper(this);
        /** call onCreate method */
        SQLiteDatabase tempDb = this.db.getWritableDatabase();
        tempDb.close();

        this.mockexamQuestionTypes = EnumSet.of(QuestionType.QT_READING_INCOMPLETE_SENTENCES);
        this.questionArray = new ArrayList<Question>();

        Log.i(tag, "onCreate - OUT");
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        Log.i(tag, "onTerminate - IN");
        Log.i(tag, "onTerminate - OUT");
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        Log.w(tag, "onLowMemory - IN");
        Log.w(tag, "onLowMemory - OUT");
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.i(tag, "onConfigurationChanged - IN");
        Log.i(tag, "onConfigurationChanged - OUT");
    }

    public void getProfile() {
        this.userName = this.db.userName();
        this.currentScore = this.db.mockScore();
        if (this.currentScore == 0) {
            this.currentScore = this.db.lastScore();
        }
        this.level = convertScoreToLeve(this.currentScore);

        this.untilDays = -1;
        this.examDate = this.db.examDate();
        if (this.examDate != null) {
            Date today = new Date();
            long diff = this.examDate.getTime() - today.getTime();
            if (diff > 0 ) {
                long oneDateTime = 1000 * 60 * 60 * 24;
                this.untilDays = (int) (diff / oneDateTime);
            }
            else {
                this.untilDays = 0;
            }
        }
        this.studyTime = this.db.studyTime();
    }

    public ToeicLevel convertScoreToLeve(Integer score) {
        ToeicLevel lv;

        if (score >= 860) {
            lv = ToeicLevel.TL_A;
        } else if (score >= 730) {
            lv = ToeicLevel.TL_B;
        } else if (score >= 470) {
            lv = ToeicLevel.TL_C;
        } else if (score >= 220) {
            lv = ToeicLevel.TL_D;
        } else {
            lv = ToeicLevel.TL_E;
        }

        return lv;
    }

    public Boolean isQuestionExist(Integer questionId) {

        for (Question q : this.questionArray) {
            if (q.qid == questionId) {
                return true;
            }
        }

        return false;
    }

    public void setQuestionPref(QuestionType qt) {
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(PFConstants.getQuestionSettingType(), qt.name());
        editor.commit();
    }

    public void setQuestionPref(QuestionType qt, Integer maxLv, Integer minLv, Integer timeLimit, Integer questions) {
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(PFConstants.getQuestionSettingType(), qt.name());
        editor.putInt(PFConstants.getQuestionSettingMaxLevel(), maxLv);
        editor.putInt(PFConstants.getQuestionSettingMinLevel(), minLv);
        editor.putInt(PFConstants.getQuestionTimeLimit(), timeLimit);
        editor.putInt(PFConstants.getTotalQuestions(), questions);
        editor.commit();
    }

    public AlertDialog showAlertDialog(Context activity, int title, int message, Boolean isCance){
        return this.showAlertDialog(activity, getString(title), getString(message), isCance);
    }
    public AlertDialog showAlertDialog(Context activity, int title, String message, Boolean isCance){
        return this.showAlertDialog(activity, getString(title), message, isCance);
    }
    public AlertDialog showAlertDialog(Context activity, String title, int message, Boolean isCance){
        return this.showAlertDialog(activity, title, getString(message), isCance);
    }
    public AlertDialog showAlertDialog(Context activity, String title, String message, Boolean isCancel) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(activity);
        alertDialogBuilder.setTitle(title);
        alertDialogBuilder.setMessage(message);
        alertDialogBuilder.setPositiveButton("OK", null);
        if (isCancel) {
            alertDialogBuilder.setNegativeButton("Cancel", null);
        }
        alertDialogBuilder.setCancelable(isCancel);

        AlertDialog dialog = alertDialogBuilder.create();
        dialog.show();
        return dialog;
    }

    public ProgressDialog showProgressDialog(Context activity, int title, int message){
        return this.showProgressDialog(activity, getString(title), getString(message));
    }
    public ProgressDialog showProgressDialog(Context activity, int title, String message){
        return this.showProgressDialog(activity, getString(title), message);
    }
    public ProgressDialog showProgressDialog(Context activity, String title, int message){
        return this.showProgressDialog(activity, title, getString(message));
    }
    public ProgressDialog showProgressDialog(Context activity, String title, String message){
        ProgressDialog dialog = new ProgressDialog(activity);

        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        dialog.setProgressStyle(android.app.ProgressDialog.STYLE_SPINNER);
        dialog.show();

        return dialog;
    }
}
