package net.takemix.testok.activity;

import java.util.Date;
import java.util.Random;

import net.takemix.testok.PFConstants;
import net.takemix.testok.Question;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.LayoutInflater.Factory;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

public class QuestionActivity extends Activity implements View.OnClickListener, RadioGroup.OnCheckedChangeListener, OnCheckedChangeListener {
    private static final String TAG = "QuestionActivitys";

    private static final int SUBMENU_FIFTY_FIFTY = 0;
    private static final int SUBMENU_TIME_STOP = 1;
    private static final int SUBMENU_HINT = 2;

    private Testok testok;

    private Chronometer cTimeCounter;
    private Chronometer cTotalTimeCounter;

    private TextView tvQuestionSubject;
	private TextView tvQuestionNo;
    private TextView tvTotalQuestions;
    private TextView tvQuestionSlash;
    private TextView tvTime;
    private TextView tvTotalTime;
	private TextView tvQuestionSentence;
	private Button bPrev;
	private Button bAbort;
	private Button bNext;
	private RadioGroup rgAnswer;
	private RadioButton[] rbArray;
	private ToggleButton tbMark;

	private Question question;
    private GetNextQuestionThread getNextQuestionThread;
	private Integer questionNo;
    private Integer totalQuestion;
    private Long sequenceId;
    private Boolean automaticallyNextQuestion;

    static private Question nextQuestion;

    @Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.question);

        this.testok = (Testok)getApplication();

        this.tvQuestionSubject = (TextView)this.findViewById(R.id.question_subjectTextView);
        this.tvQuestionSubject.setText(R.string.question_subject);
        this.tvQuestionNo = (TextView)this.findViewById(R.id.question_noTextView);
        this.tvTotalQuestions = (TextView)this.findViewById(R.id.question_totalTextView);
        this.tvQuestionSlash = (TextView)this.findViewById(R.id.question_slashTextView);

        this.tvTime = (TextView)this.findViewById(R.id.question_timeTextView);
        this.tvTime.setText(R.string.question_time);
        this.tvTotalTime = (TextView)this.findViewById(R.id.question_totalTimeTextView0);
        this.tvTotalTime.setText(R.string.question_totaltime);
        this.cTotalTimeCounter = (Chronometer)this.findViewById(R.id.question_totalTimeChronometer);
        this.cTimeCounter = (Chronometer)this.findViewById(R.id.question_timeChronometer);

        this.tvQuestionSentence = (TextView)this.findViewById(R.id.question_questionTextView);

        this.rgAnswer = (RadioGroup)this.findViewById(R.id.question_anserRadioGroup);
        this.rbArray = new RadioButton[Question.MAX_ANSWER];
        this.rbArray[0] = (RadioButton)this.findViewById(R.id.question_answerARadio);
        this.rbArray[1] = (RadioButton)this.findViewById(R.id.question_answerBRadio);
        this.rbArray[2] = (RadioButton)this.findViewById(R.id.question_answerCRadio);
        this.rbArray[3] = (RadioButton)this.findViewById(R.id.question_answerDRadio);

        this.bPrev = (Button)this.findViewById(R.id.question_previousButton);
        this.bPrev.setText(R.string.question_prev);
        this.bPrev.setOnClickListener(this);
        this.bAbort = (Button)this.findViewById(R.id.question_abortButton);
        this.bAbort.setText(R.string.question_pause);
        this.bAbort.setOnClickListener(this);
        this.bNext = (Button)this.findViewById(R.id.question_nextButton);
        this.bNext.setText(R.string.question_next);
        this.bNext.setOnClickListener(this);

        this.tbMark = (ToggleButton)this.findViewById(R.id.question_markToggleButton);
        this.tbMark.setOnCheckedChangeListener(this);

        if (this.init()) {
            this.cTotalTimeCounter.setBase(SystemClock.elapsedRealtime());
            this.cTotalTimeCounter.start();

            this.refreshView();
        }

        Log.i(TAG, "onCreate - OUT");
	}

    public Boolean init() {
        Log.i(TAG, "init - IN");

        this.testok.questionArray.clear();

        Date date = new Date();
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putLong(PFConstants.getQuestionSeqId(), date.getTime());
        editor.commit();

        this.testok.db.setPreferences();
        Question q = this.testok.db.getQuestion();
        if (this.init(q, 1)) {
            this.testok.questionArray.add(this.question);
        } else {
            return false;
        }

        nextQuestion = null;
        this.getQuestionForBackground();

        Log.i(TAG, "init - OUT");
        return true;
    }

    private Boolean init(Question q, Integer qno) {
        Log.i(TAG, "init(qno=" + qno + ") - IN");

        if (q == null) {
            Toast.makeText(this, R.string.question_no_question, Toast.LENGTH_LONG).show();
            return false;
        }

        this.question = q;
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putInt(PFConstants.getQuestionNo(), qno);
        editor.commit();

        this.totalQuestion = pref.getInt(PFConstants.getTotalQuestions(), -1);  //total questions as -1, no limit
        this.questionNo = pref.getInt(PFConstants.getQuestionNo(), 0);
        this.sequenceId = pref.getLong(PFConstants.getQuestionSeqId(), 0);
        this.automaticallyNextQuestion = pref.getBoolean(PFConstants.getAutomaticallyNextQuestion(), false);

        Log.i(TAG, "init(qno) - OUT");
        return true;
    }

    private void refreshView() {
        Log.i(TAG, "refreshView - IN [" + this.questionNo + "]");

        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);

        if (this.totalQuestion > 0) {
            this.tvTotalQuestions.setText(this.totalQuestion.toString());
            this.tvTotalQuestions.setVisibility(View.VISIBLE);
            this.tvQuestionSlash.setVisibility(View.VISIBLE);
        } else {
            this.tvTotalQuestions.setVisibility(View.INVISIBLE);
            this.tvQuestionSlash.setVisibility(View.INVISIBLE);
        }

        if (this.question.time <= 0) {
            this.cTimeCounter.setBase(SystemClock.elapsedRealtime());
        } else {
            this.cTimeCounter.setBase(SystemClock.elapsedRealtime() - this.question.time);
        }
        this.cTimeCounter.start();

        Boolean mark = this.testok.db.mark(this.question.qid);
        this.tbMark.setChecked(mark);

        this.tvQuestionNo.setText(this.questionNo.toString());
        this.tvQuestionSentence.setText(this.question.questionSentence);

        this.rgAnswer.setOnCheckedChangeListener(null); // no call onCheckedChanged by follow set
        this.rgAnswer.clearCheck();
        for (int i = 0; i < rbArray.length; i++) {
            this.rbArray[i].setTag(i);
            this.rbArray[i].setText(this.question.answer[i]);
            if (question.selectedIndex == i) {
                this.rgAnswer.check(this.rbArray[i].getId());
            }
            this.rbArray[i].setVisibility(View.VISIBLE);
        }
        this.rgAnswer.setOnCheckedChangeListener(this);

        if (pref.getInt(PFConstants.getQuestionNo(), 0) == 1) {
            this.bPrev.setEnabled(false);
        } else {
            this.bPrev.setEnabled(true);
        }

        if (this.questionNo == this.totalQuestion) {
            //最後の問題の場合は「回答を確認」を表示
            this.bNext.setText(R.string.question_finish);
        } else {
            this.bNext.setText(R.string.question_next);
        }
        this.bNext.setEnabled(true);

        Log.i(TAG, "refreshView - OUT");
	}

	public void onClick(View v) {
        if (v == this.bNext) {
	        Log.i(TAG, "onClick - bNext");
	        this.setHistory(this.question.qid);
		    this.nextAction();
		} else if (v == this.bPrev) {
            Log.i(TAG, "onClick - bPrev");
            this.setHistory(this.question.qid);
            this.prevAction();
		} else if (v == this.bAbort) {
            Log.i(TAG, "onClick - bAbort");

            this.setHistory(this.question.qid);

            Intent intent = new Intent(this, net.takemix.testok.activity.AnswerActivity.class);
            startActivityForResult(intent, 1);

            finish();
		}

        Log.i(TAG, "onClick - OUT");
	}

	 public void onCheckedChanged(CompoundButton button, boolean checked) {
	     if (button == this.tbMark) {
	         Log.i(TAG, "onClick - tbMark");

	         this.testok.db.setMark(this.question.qid, checked);
	     }

	     Log.i(TAG, "onCheckedChanged - OUT");
	 }

	public void onCheckedChanged(RadioGroup group, int checkedId) {
        Log.i(TAG, "onCheckedChanged - IN");

        RadioButton radioButton = (RadioButton) findViewById(checkedId);

        if (radioButton.isChecked()) {
    	    this.question.selectedIndex = (Integer)radioButton.getTag();

    	    this.setHistory(this.question.qid);

    	    if (this.automaticallyNextQuestion) {
    	        this.nextAction();
    	    }
	    }

        Log.i(TAG, "onCheckedChanged - OUT");
	}

    private void nextAction() {
        if ((this.totalQuestion != -1) && (this.questionNo == this.totalQuestion)) {
            //終了
            Intent intent = new Intent(this, net.takemix.testok.activity.AnswerActivity.class);
            startActivity(intent);

            finish();
        } else if (this.questionNo == this.testok.questionArray.size()) {
            //新規問題
            //結局、nextQuestionはThreadSafeにしなくても良いということが分かった
            //この時点であれば使う、なければ処理中に取得しても破棄する
            Question q = nextQuestion;
            if (nextQuestion == null) {
                Log.i(TAG, "nextAction - get next question");

                ProgressDialog dialog = this.testok.showProgressDialog(this, R.string.question_wait, null);
                do {
                    q = this.testok.db.getQuestion();
                } while(this.testok.isQuestionExist(q.qid));
                Log.i(TAG, "nextAction - set next question");

                dialog.dismiss();
            }

            if (this.init(q, this.questionNo + 1)) {
                this.testok.questionArray.add(q);
                this.refreshView();

                nextQuestion = null;
                this.getQuestionForBackground();
            }
        } else {
            //出題済みの問題
            Question q = testok.questionArray.get(this.questionNo);
            if (this.init(q, this.questionNo + 1)) {
                this.refreshView();
            }
        }
	}

	private void prevAction() {
        Question q = testok.questionArray.get(this.questionNo - 2);
        if (this.init(q, this.questionNo - 1)) {
            this.refreshView();
        }
	}

	private void setHistory(Integer updateId) {
	    this.question.time = SystemClock.elapsedRealtime() - this.cTimeCounter.getBase();
	    this.testok.db.setHistory(this.sequenceId, this.question);
	}

    private void getQuestionForBackground() {
        Log.i(TAG, "getQuestionForBackground - IN");
        this.getNextQuestionThread = new GetNextQuestionThread(this.testok);
        this.getNextQuestionThread.start();
        Log.i(TAG, "getQuestionForBackground - OUT");
    }

    class GetNextQuestionThread extends Thread {
        private Testok testok;

        public GetNextQuestionThread(Testok testok) {
            super();

            this.testok = testok;
        }

        public void run() {
            Log.i(TAG, "GetNextQuestionThread - run");

            Question q;
            do {
                q = this.testok.db.getQuestion();
            } while(this.testok.isQuestionExist(q.qid));

            Log.i(TAG, "GetNextQuestionThread - get next question");
            nextQuestion = q;
        }
	}

	@Override
    public boolean onCreateOptionsMenu(Menu menu) {
	    super.onCreateOptionsMenu(menu);
        MenuItem item0 = menu.add(0, SUBMENU_FIFTY_FIFTY, 0, R.string.question_submenu_ff);
        MenuItem item1 = menu.add(0, SUBMENU_TIME_STOP, 0, R.string.question_submenu_ts);
        MenuItem item2 = menu.add(0, SUBMENU_HINT, 0, R.string.question_submenu_hi);

        setMenuBGColor(Color.WHITE);

        item0.setIcon(R.drawable.fiftyfifty_off);
        item1.setIcon(R.drawable.timestop_off);
        item2.setIcon(R.drawable.hint_off);

        return true;
    }

    protected void setMenuBGColor(final int color) {
        getLayoutInflater().setFactory( new Factory() {

            //@Override
            public View onCreateView (String name, Context context, AttributeSet attrs) {
                if(name.equalsIgnoreCase("com.android.internal.view.menu.IconMenuItemView")) {
                    try {
                        final View view = getLayoutInflater().createView(name, null, attrs);
                        new Handler().post(new Runnable() {
                            public void run() {
                                view.setBackgroundColor(color);
                            }
                        } );
                        return view;
                    } catch (InflateException e) {
                        e.printStackTrace();
                    } catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch(item.getItemId()) {
        case SUBMENU_FIFTY_FIFTY:
            Random rnd = new Random();
            int invisibleCount = Question.MAX_ANSWER / 2;
            do {
                int rand = rnd.nextInt(Question.MAX_ANSWER);
                RadioButton rb = this.rbArray[rand];
                if (rand != this.question.rightAnswerIndex) {
                    if (rb.getVisibility() != RadioButton.INVISIBLE) {
                        rb.setVisibility(RadioButton.INVISIBLE);
                        invisibleCount--;
                    }
                }
            } while (invisibleCount > 0);
            return true;
        case SUBMENU_TIME_STOP:
            this.cTimeCounter.stop();
            this.cTotalTimeCounter.stop();
            return true;
        case SUBMENU_HINT:
            Toast.makeText(this, this.question.hint, Toast.LENGTH_LONG).show();
            return true;
        }

        return true;
    }
}
