//
//  TetriPadAppDelegate.m
//  TetriPad
//
//  Created by あんのたん on 10/05/21.
//  Copyright __MyCompanyName__ 2010. All rights reserved.
//

#import "TetriPadAppDelegate.h"

#define kTetriPadBlockWidth 10.0f
#define kTetriPadBlockHeight 20.0f

@implementation TetriPadAppDelegate

@synthesize window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {    
	
    // Override point for customization after application launch
	
	application.statusBarHidden = YES;
	
	CGRect deviceRect = [[UIScreen mainScreen] bounds];
	float blockWidth = deviceRect.size.width / kTetriPadBlockWidth;
	float blockHeight = deviceRect.size.height / kTetriPadBlockHeight;
	//blockWidth = blockHeight;
	
	buttons = [[NSMutableArray alloc] init];
	monos = [[NSArray alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"Monos" ofType:@"plist"]];
	
	for (int i=0; i<kTetriPadBlockHeight; i++) {
		for (int j=0; j<kTetriPadBlockWidth; j++) {
			UIButton* button = [UIButton buttonWithType:UIButtonTypeCustom];
			button.frame = CGRectMake(j * blockWidth, i * blockHeight, blockWidth, blockHeight);
			[window addSubview:button];
			[buttons addObject:button];
		}
	}
	
	for (int i=0; i<[buttons count]; i++) {
		if (i % 10 >= 7) {
			[[buttons objectAtIndex:i] addTarget:self action:@selector(moveToRight) forControlEvents:UIControlEventTouchDown];
		} else if (i % 10 >= 3) {
			if (i < kTetriPadBlockWidth * 15) {
				if (i % 10 >= 5) {			
					[[buttons objectAtIndex:i] addTarget:self action:@selector(rotateLeft) forControlEvents:UIControlEventTouchDown];
				} else {
					[[buttons objectAtIndex:i] addTarget:self action:@selector(rotateRight) forControlEvents:UIControlEventTouchDown];
				}
			} else {
				[[buttons objectAtIndex:i] addTarget:self action:@selector(hardDrop) forControlEvents:UIControlEventTouchDown];
			}
		} else {
			[[buttons objectAtIndex:i] addTarget:self action:@selector(moveToLeft) forControlEvents:UIControlEventTouchDown];
		}
	}
	
    [window makeKeyAndVisible];
    
	[self reset];
	
	UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"TetriPad" message:@"Welcome to TetriPad!" delegate:self cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
	[alert show];
	[alert release];
	
    return YES;
}

- (void)applicationWillTerminate:(UIApplication *)application
{
}

- (void)reset {
	lineCount = 0;
	
	if (informations) {
		[informations release];
	}
	
	informations = [[NSMutableArray alloc] init];
	
	for (int i=0; i<[buttons count]; i++) {
		UIButton* button = [buttons objectAtIndex:i];
		button.backgroundColor = [self backgroundColorForIndex:i];
		[informations addObject:[NSNull null]];
	}
}

- (UIColor *)backgroundColorForIndex:(NSUInteger)aIndex {
	
	if (aIndex % 10 >= 7) {
		return [UIColor blackColor];
	} else if (aIndex % 10 >= 3) {
		if (aIndex < kTetriPadBlockWidth * 15) {
			if (aIndex % 10 >= 5) {
				return [UIColor grayColor];
			} else {
				return [UIColor blackColor];
			}
		} else {
			return [UIColor whiteColor];
		}
	} else {
		return [UIColor grayColor];
	}
	
//チェッカー柄	
//	BOOL isBlack = aIndex % 2;
//	
//	if ((aIndex % ((int)kTetriPadBlockWidth * 2)) >= kTetriPadBlockWidth) {
//		if (isBlack) {
//			isBlack = NO;
//		} else {
//			isBlack = YES;
//		}
//	}
//	
//	if (isBlack) {
//		return [UIColor grayColor];
//	} else {
//		return [UIColor blackColor];
//	}
}

- (void)addTetriMono {
	
	int randIndex = random() % [monos count];
	
	if (mono) {
		[mono release];
		mono = nil;
	}
	
	mono = [[NSClassFromString([monos objectAtIndex:randIndex]) alloc] init];
	monoPoint = CGPointMake(4, 0);
	
	if (![self canMoveToPoint:monoPoint]) {
		[self drawMono];
		[self gameOver];
		return;
	}
	
	[self drawMono];
	
	dropTimer = [NSTimer scheduledTimerWithTimeInterval:0.2f target:self selector:@selector(dropTimerThread) userInfo:nil repeats:YES];
}

- (void)dropTimerThread {
	
	[self hideMono];
	
	CGPoint aPoint = monoPoint;
	aPoint.y += 1;
	
	if (![self canMoveToPoint:aPoint]) {
		[self drawMono];
		if (!dropStopTimer) {
			dropStopTimer = [NSTimer scheduledTimerWithTimeInterval:0.5f target:self selector:@selector(dropStopTimerMethod) userInfo:nil repeats:NO];
		}
		return;
	}
	
	if (dropStopTimer) {
		[dropStopTimer invalidate];
		dropStopTimer = nil;
	}
	
	monoPoint = aPoint;
	[self drawMono];
}

- (void)dropStopTimerMethod {
	dropStopTimer = nil;
	[dropTimer invalidate];
	dropTimer = nil;
	[self lineCheck];
	[self addTetriMono];
}

- (void)hardDrop {
	[self hideMono];
	
	CGPoint aPoint = monoPoint;
	while ([self canMoveToPoint:aPoint]) {
		aPoint.y += 1;
	}
	
	aPoint.y -= 1;
	monoPoint = aPoint;
	[self drawMono];
	
	[dropStopTimer invalidate];
	[self dropStopTimerMethod];
}

- (void)drawMono {
	const uint8_t* p = [mono points];
	for (int i = 0; i < 8; i+=2) {
		NSUInteger aIndex = monoPoint.x + p[i] + p[i + 1] * kTetriPadBlockWidth + monoPoint.y * kTetriPadBlockWidth;
		[buttons objectAtIndex:aIndex];
		[[buttons objectAtIndex:aIndex] setBackgroundColor:[mono color]];
		[informations removeObjectAtIndex:aIndex];
		[informations insertObject:mono atIndex:aIndex];
	}
}

- (void)hideMono {
	
	if (!mono) {
		return;
	}
	
	const uint8_t* p = [mono points];
	for (int i = 0; i < 8; i+=2) {
		NSUInteger aIndex = monoPoint.x + p[i] + p[i + 1] * kTetriPadBlockWidth + monoPoint.y * kTetriPadBlockWidth;
		[[buttons objectAtIndex:aIndex] setBackgroundColor:[self backgroundColorForIndex:aIndex]];
		[informations removeObjectAtIndex:aIndex];
		[informations insertObject:[NSNull null] atIndex:aIndex];
	}
}

- (BOOL)canMoveToPoint:(CGPoint)aPoint {
	const uint8_t* p = [mono points];
	for (int i = 0; i < 8; i+=2) {
		
		if (aPoint.x + p[i] < 0) {
			return NO;
		}
		
		if (aPoint.x + p[i] >= kTetriPadBlockWidth) {
			return NO;
		}
		
		if (aPoint.y + p[i + 1] >= kTetriPadBlockHeight) {
			return NO;
		}
		
		NSUInteger aIndex = aPoint.x + p[i] + p[i + 1] * kTetriPadBlockWidth + aPoint.y * kTetriPadBlockWidth;
		if (![[informations objectAtIndex:aIndex] isEqual:[NSNull null]]) {
			return NO;
		}
	}
	
	return YES;
}

- (void)dealloc {
    [window release];
	[buttons release];
	[monos release];
	[informations release];
    [super dealloc];
}

- (void)moveToRight {
	[self hideMono];
	
	CGPoint aPoint = monoPoint;
	aPoint.x += 1;
	
	if (![self canMoveToPoint:aPoint]) {
		[self drawMono];
		return;
	}
	
	monoPoint = aPoint;
	[self drawMono];
}

- (void)moveToLeft {
	[self hideMono];
	
	CGPoint aPoint = monoPoint;
	aPoint.x -= 1;
	
	if (![self canMoveToPoint:aPoint]) {
		[self drawMono];
		return;
	}
	
	monoPoint = aPoint;
	[self drawMono];
}

- (void)rotateRight {
	[self hideMono];
	
	[mono rotateRight];
	
	if (![self canMoveToPoint:monoPoint]) {
		[mono rotateLeft];
		[self drawMono];
		return;
	}
	
	[self drawMono];
}

- (void)rotateLeft {
	[self hideMono];
	
	[mono rotateLeft];
	
	if (![self canMoveToPoint:monoPoint]) {
		[mono rotateRight];
		[self drawMono];
		return;
	}
	
	[self drawMono];
}

- (void)lineCheck {
	for (int i=0; i<kTetriPadBlockHeight; i++) {
		BOOL hasBrank = NO;
		for (int j=0; j<kTetriPadBlockWidth; j++) {
			if ([[informations objectAtIndex:kTetriPadBlockWidth * i + j] isEqual:[NSNull null]]) {
				hasBrank = YES;
			}
		}
		
		if (!hasBrank) {
			lineCount++;
			for (int j=i; j>=0; j--) {
				for (int k=0; k<kTetriPadBlockWidth; k++) {
					int aIndex = kTetriPadBlockWidth * j + k;
					[informations removeObjectAtIndex:aIndex];
					if (aIndex - kTetriPadBlockWidth >= 0) {
						[informations insertObject:[informations objectAtIndex:aIndex - kTetriPadBlockWidth] atIndex:aIndex];
						if (![[informations objectAtIndex:aIndex] isEqual:[NSNull null]]) {
							[[buttons objectAtIndex:aIndex] setBackgroundColor:[[buttons objectAtIndex:aIndex - kTetriPadBlockWidth] backgroundColor]];
						} else {
							[[buttons objectAtIndex:aIndex] setBackgroundColor:[self backgroundColorForIndex:aIndex]];
						}
					} else {
						[informations insertObject:[NSNull null] atIndex:aIndex];
						[[buttons objectAtIndex:aIndex] setBackgroundColor:[self backgroundColorForIndex:aIndex]];
					}
				}
			}
		}
	}
}

- (void)gameOver {
	
	for (int i=0; i<[buttons count]; i++) {
		if (![[informations objectAtIndex:i] isEqual:[NSNull null]]) {
			[[buttons objectAtIndex:i] setBackgroundColor:[UIColor redColor]];
		}
	}
	
	UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"Game Over" message:[NSString stringWithFormat:@"Your Score is %u", lineCount] delegate:self cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
	[alert show];
	[alert release];
}

- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex {
	[self reset];
	[self addTetriMono];
}

@end
