unit textdefindunit;

interface

uses
	Winapi.Windows,Winapi.Messages,System.SysUtils,System.Variants,
	System.Classes,Vcl.Graphics,
	Vcl.Controls,Vcl.Forms,Vcl.Dialogs,Vcl.StdCtrls,Vcl.ExtCtrls,Vcl.Grids,
	types,inifiles,
	Vcl.ComCtrls,ShlObj,ActiveX,Vcl.Menus,Vcl.CheckLst,IdBaseComponent,
	IdComponent,IdTCPConnection,IdTCPClient,IdGlobal,IdURI,IdHTTP,Vcl.OleCtrls,SHDocVw,
	IdIOHandler,IdIOHandlerSocket,IdIOHandlerStack,IdSSL,IdSSLOpenSSL,Vcl.Mask,
  System.Net.URLClient, System.Net.HttpClient, System.Net.HttpClientComponent;

type
	TStringSelf=class(TStringList)
	public
		buf:string;
		function this:TStringList;
	end;

	TStringsHelper=class helper for TStrings
		function setstrings(sa:TStringDynArray):Integer;
	end;

	TStringDynArrayHelper=record helper for TStringDynArray
		function add(s:string):Integer;
		function adduni(s:string):Integer;

		function item(i:Integer):String;
		function cat(s,e:string):String;
		function stringselfcreate:TStringSelf;
		function load(f:string):boolean;
		function save(f:string):boolean;
		function getcount:Integer;
		procedure setcount(const i:Integer);
		procedure clear;
		function hi:Integer;
		property count:Integer read getcount write setcount;
	end;

	TGrid=class(TStringGrid)
	type
		TFuncXY=reference to procedure(X,Y:Integer);

	private
		constructor CreateEX(Origin:TStringGrid);
		procedure WMChar(var Msg:TWMChar);message WM_CHAR;
		procedure KeyDown(var Key:Word;Shift:TShiftState);override;
		procedure MouseDown(Button:TMouseButton;Shift:TShiftState;X,Y:Integer);override;
		procedure MouseMove(Shift:TShiftState;X,Y:Integer);override;

		procedure SetEditText(ACol,ARow:Integer;const Value:string);override;

		function DoMouseWheelDown(Shift:TShiftState;MousePos:TPoint):boolean;override;
		function DoMouseWheelUp(Shift:TShiftState;MousePos:TPoint):boolean;override;

	public
		downinselection:boolean;
		saverect:TGridRect;
		buf:TGrid;

		function ColExpand(min:Integer):Integer;
		function RowDelete(Y,cnt:Integer):Integer;
		function RowInsert(Y,cnt:Integer):Integer;
		function RowClear(Y,cnt:Integer):Integer;
		function ColDelete(X,cnt:Integer):Integer;
		function ColInsert(X,cnt:Integer):Integer;
		function ColClear(X,cnt:Integer):Integer;

		procedure cutcopy(modecut:boolean);
		function paste:TGridRect;
		function selrowdo(func:TFuncXY):Integer;
		function rowdo(func:TFuncXY):Integer;
		function seldo(func:TFuncXY):Integer;
		function alldo(func:TFuncXY):Integer;
		procedure copy(G:TGrid);
		procedure savebuf;
		procedure seldel;
		function seltext:string;
		procedure setfixed;
		function load(fn:string):boolean;
		function save(fn:string):boolean;
		procedure clear;

	published
		property InplaceEditor;
	end;

	TMemIniFileHelper=class helper for TMemInifile
		procedure readstrings(sc:string;sl:TStrings);
		procedure writestrings(sc:string;sl:TStrings);
		procedure readgrid(sc:string;G:TGrid);
		procedure writegrid(sc:string;G:TGrid);
		procedure readtreeview(sc:string;T:TTreeView);
		procedure writetreeview(sc:string;T:TTreeView);
	end;

	TTextDeFindForm=class(TForm,IDropSource)
		Panel1:TPanel;
		Path:TComboBox;
		Find:TButton;
		GridFiles:TStringGrid;
		PopupMenu2:TPopupMenu;
		PFileCut:TMenuItem;
		PFileCopy:TMenuItem;
		PFilePaste:TMenuItem;
		PFileSaveAs:TMenuItem;
		PFileOpen:TMenuItem;
		PopupMenu1:TPopupMenu;
		PTextCut:TMenuItem;
		PTextCopy:TMenuItem;
		PTextPaste:TMenuItem;
		PTextSaveAs:TMenuItem;
		PTextOpen:TMenuItem;
		buf:TStringGrid;
		TMP:TComboBox;
		SaveDialog:TSaveDialog;
		OpenDialog:TOpenDialog;
		LeftPanel:TPanel;
		ListName:TComboBox;
		Text:TRichEdit;
		Tree:TTreeView;
		Button1:TButton;
		Splitter1:TSplitter;
		PFileExec:TMenuItem;
		PFileFolder:TMenuItem;
		Panel3:TPanel;
		Url:TComboBox;
		FindUrlButton:TButton;
		UrlEditButton:TButton;
		PathEditButton:TButton;
		PTextFind:TMenuItem;
		PTextFindUrl:TMenuItem;
		N1:TMenuItem;
		PathSelButton:TButton;
		OpURLPanel:TPanel;
		OpURLEscape:TCheckBox;
		OpUrlSpace:TCheckBox;
		OpURLZenkaku:TCheckBox;
		OpURLEscapeEdit:TEdit;
		OpURLSpaceEdit:TEdit;
		OptionUrlDQuote:TCheckBox;
		OpURLComment:TCheckBox;
		OpURLButton:TButton;
		Web:TWebBrowser;
		IdHTTP:TIdHTTP;
		IdSSLIOHandlerSocketOpenSSL:TIdSSLIOHandlerSocketOpenSSL;
		Memo1:TMemo;
		OpURLFile:TCheckBox;
		OpURLituneNazo:TCheckBox;
		PFileUpdate:TMenuItem;
		PColAdd:TMenuItem;
		PColDel:TMenuItem;
		PRowAdd:TMenuItem;
		PRowDel:TMenuItem;
		N5:TMenuItem;
		PClear:TMenuItem;
		OpURLWait:TMaskEdit;
		OpURLLocal:TCheckBox;
		OpURLitune:TCheckBox;
    OpURLNoSave: TCheckBox;
    PReFind: TMenuItem;
    OpURLOpenSave: TCheckBox;
    OpURLReset: TCheckBox;
    N2: TMenuItem;
    N3: TMenuItem;
    PReload: TMenuItem;
    PTextListName: TMenuItem;
    NetHTTPClient: TNetHTTPClient;
    NetHTTPRequest: TNetHTTPRequest;
    MTextDelKakko: TMenuItem;
    PTextTextReplaceReg: TMenuItem;
    ReplaceDialog: TReplaceDialog;
    PTextTextReplace: TMenuItem;
    N4: TMenuItem;
    OpURLituneTitleMatch: TCheckBox;
		procedure FindClick(Sender:TObject);
		procedure FormCreate(Sender:TObject);
		procedure GridFilesMouseDown(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
		procedure PFileCutClick(Sender:TObject);
		procedure PFileCopyClick(Sender:TObject);
		procedure PFilePasteClick(Sender:TObject);
		procedure PFileSaveAsClick(Sender:TObject);
		procedure PFileOpenClick(Sender:TObject);
		procedure PTextCutClick(Sender:TObject);
		procedure PTextCopyClick(Sender:TObject);
		procedure PTextPasteClick(Sender:TObject);
		procedure PTextSaveAsClick(Sender:TObject);
		procedure PTextOpenClick(Sender:TObject);
		procedure FormDestroy(Sender:TObject);
		procedure ListNameChange(Sender:TObject);
		procedure TreeClick(Sender:TObject);
		procedure Button1Click(Sender:TObject);
		procedure PFileFolderClick(Sender:TObject);
		procedure PFileExecClick(Sender:TObject);
		procedure FindUrlButtonClick(Sender:TObject);
		procedure TextMouseUp(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
		procedure UrlEditButtonClick(Sender:TObject);
		procedure PathEditButtonClick(Sender:TObject);
		procedure PTextFindClick(Sender:TObject);
		procedure PTextFindUrlClick(Sender:TObject);
		procedure PathSelButtonClick(Sender:TObject);
		procedure GridFilesSetEditText(Sender:TObject;ACol,ARow:Integer;const Value:string);
		procedure FormClose(Sender:TObject;var Action:TCloseAction);
		procedure OpURLButtonClick(Sender:TObject);
		procedure PFileUpdateClick(Sender:TObject);
		procedure PTextFindUrlAddClick(Sender:TObject);
		procedure PColAddClick(Sender:TObject);
		procedure GridFilesSelectCell(Sender:TObject;ACol,ARow:Integer;var CanSelect:boolean);
		procedure PRowDelClick(Sender:TObject);
		procedure PRowAddClick(Sender:TObject);
		procedure PColDelClick(Sender:TObject);
		procedure PClearClick(Sender:TObject);
    procedure PReFindClick(Sender: TObject);
    procedure PReloadClick(Sender: TObject);
    procedure PTextListNameClick(Sender: TObject);
    procedure PTextTextReplaceClick(Sender: TObject);
    procedure ReplaceDialogReplace(Sender: TObject);
    procedure ReplaceDialogFind(Sender: TObject);
    procedure PTextTextReplaceRegClick(Sender: TObject);
    procedure MTextDelKakkoClick(Sender: TObject);
	private
		function getpathtext:string;
		function localfind(var sa:TStringDynArray;ssss:string):boolean;
	function iddownload(Url: string): string;
	function getsearchtext(Url: String): String;
	function tnetdownload(Url: string): string;
		{ Private 錾 }
	public
		{ Public 錾 }
		Files:TGrid;
		EnableReplaceReg:boolean;

		function QueryContinueDrag(fEscapePressed:BOOL;grfKeyState:Longint):HResult;stdcall;
		function GiveFeedback(dwEffect:Longint):HResult;stdcall;
		function GetFilePathDataObject(G:TStringGrid):IDataObject;
	end;

var
	TextDeFindForm:TTextDeFindForm;
	urlrun:boolean;

implementation

uses Math,strutils,IOUtils,masks,clipbrd,SHELLAPI,Vcl.FileCtrl,ComObj,System.JSON,RegularExpressions;

var
	Malloc:IMalloc;
	FMouseDownPt:TPoint;
	sl:TStringDynArray;
	Ini:TMemInifile;
	Inifile:TMemInifile;
	inidir:string;
	pname:string;
	op:TSearchOption;
	sa:TStringDynArray;

const
	MAXLIST=4096;
	TKNMAXLEN=1024;
	NULLNULL=#0#0;
	CR=#13;
	LF=#10;
	CRLF=#13#10;
	TAB=#9;
	CTEXT='';
	CFILE='t@C';
	CPATH='pX';
	CNAME='A[eBXg';
	COPEN='J';
	COPEN2='J2';
	CALBAM='Ao';

var
	NTEXT:Integer;
	NFILE:Integer;
	NPATH:Integer;
	NNAME:Integer;
	NALBAM:Integer;
	NOPEN:Integer;
	NOPEN2:Integer;
	CHEAD:TStringDynArray=['',CTEXT,CFILE,CPATH];
	CHEADWEB:TStringDynArray=['',CTEXT,CFILE,COPEN,COPEN2,CPATH,CNAME,CALBAM];

{$R *.dfm}

procedure TTextDeFindForm.PFileUpdateClick(Sender:TObject);
begin
	NTEXT:=Files.Rows[0].IndexOf(CTEXT);
	NFILE:=Files.Rows[0].IndexOf(CFILE);
	NPATH:=Files.Rows[0].IndexOf(CPATH);
	NNAME:=Files.Rows[0].IndexOf(CNAME);
	NALBAM:=Files.Rows[0].IndexOf(CALBAM);
	NOPEN:=Files.Rows[0].IndexOf(COPEN);
	NOPEN2:=Files.Rows[0].IndexOf(COPEN2);
end;

function INCBS(const s:string):string;
begin
	Result:=s;
	if not IsPathDelimiter(Result,Length(Result)) then
		Result:=Result+'\';
end;

function EXCBS(const s:string):string;
begin
	Result:=s;
	if IsPathDelimiter(Result,Length(Result)) then
		SetLength(Result,Length(Result)-1);
end;

function zenkaku(Str:String):String; // pSp
var
	buf: array [0..1023] of Char;
begin
	LCMapString(GetUserDefaultLCID,LCMAP_FULLWIDTH,PChar(Str),Length(Str)+1,buf,1024);
	Result:=String(buf);
end;

function hankaku(Str:String):String; // Spp
var
	buf: array [0..1023] of Char;
begin
	LCMapString(GetUserDefaultLCID,LCMAP_HALFWIDTH,PChar(Str),Length(Str)+1,buf,1024);
	Result:=String(buf);
end;

function hira(Str:String):String; // J^JiЂ炪
var
	buf: array [0..1023] of Char;
begin
	LCMapString(GetUserDefaultLCID,LCMAP_FULLWIDTH,PChar(Str),Length(Str)+1,buf,1024);
	Str:=String(buf);
	LCMapString(GetUserDefaultLCID,LCMAP_HIRAGANA,PChar(Str),Length(Str)+1,buf,1024);
	Result:=String(buf);
end;

procedure OptionSaveLoad(C:TPanel;bsave:boolean);
var
	i:Integer;
	s:string;
	B:TButton;
	procedure save(C:TComponent);
	begin
		if C.ClassType=TMenuItem then
			Ini.WriteBool('',C.Name,TMenuItem(C).Checked);
		if C.ClassType=TCheckBox then
			Ini.WriteBool('',C.Name,TCheckBox(C).Checked);
		if C.ClassType=TEdit then
			Ini.WriteString('',C.Name,TEdit(C).Text);
		if C.ClassType=TMaskEdit then
			Ini.WriteString('',C.Name,TMaskEdit(C).Text);
	end;

	procedure load(C:TComponent);
	begin
		if C.ClassType=TMenuItem then
			TMenuItem(C).Checked:=Ini.ReadBool('',C.Name,TMenuItem(C).Checked);
		if C.ClassType=TCheckBox then
			TCheckBox(C).Checked:=Ini.ReadBool('',C.Name,TCheckBox(C).Checked);
		if C.ClassType=TEdit then begin
			s:=Ini.ReadString('',C.Name,TEdit(C).Text);
			if s<>'' then
				TEdit(C).Text:=s;
		end;
		if C.ClassType=TMaskEdit then begin
			s:=Ini.ReadString('',C.Name,TMaskEdit(C).Text);
			if s<>'' then
				TEdit(C).Text:=s;
		end;
	end;

begin
	for i:=0 to C.ControlCount-1 do begin
		if bsave then save(C.Controls[i])
		else load(C.Controls[i]);
	end;

end;

procedure TTextDeFindForm.FormCreate(Sender:TObject);

begin
	Ini:=TMemInifile.Create(ChangeFileExt(Application.ExeName,'.ini'));
	Inifile:=TMemInifile.Create(ChangeFileExt(Application.ExeName,'.txt'));
	inidir:=Ini.ReadString('','inidir',inidir);
	OpenDialog.InitialDir:=ExtractFileDir(Application.ExeName);
	SaveDialog.InitialDir:=ExtractFileDir(Application.ExeName);

	Width:=Ini.ReadInteger('','Width',Width);
	Height:=Ini.ReadInteger('','Height',Height);
	LeftPanel.Width:=Ini.ReadInteger('','LeftPanel.Width',LeftPanel.Width);
	Font.Size:=Ini.ReadInteger('','Font.Size',Font.Size);

	OptionSaveLoad(OpURLPanel,false);

	Path.Text:=Ini.ReadString('','Path.Text','');
	Url.Text:=Ini.ReadString('','Url.Text','');
	Ini.readstrings('Url.Items',Url.Items);
	Inifile.readtreeview('Tree',Tree);

	// Files:=GridFiles;
	Files:=TGrid.CreateEX(GridFiles);

	try
		// Tree.LoadFromFile(ChangeFileExt(Application.ExeName,'.txt'));
		ListNameChange(Sender);
		pname:=ListName.Text;
		TreeClick(Sender);
	except
		ShowMessage('c[eLXgǂݍ߂܂ł');
		Application.Terminate;
	end;

end;

procedure TTextDeFindForm.FormClose(Sender:TObject;var Action:TCloseAction);

begin
	if Application.Terminated then
		exit;
	if OpURLNoSave.Checked then
		exit;

	Ini.WriteInteger('','Width',Width);
	Ini.WriteInteger('','Height',Height);
	Ini.WriteInteger('','LeftPanel.Width',LeftPanel.Width);
	Ini.WriteInteger('','Font.Size',Font.Size);
	Ini.WriteString('','Path.Text',Path.Text);
	Ini.WriteString('','Url.Text',Url.Text);
	Ini.writestrings('Url.Items',Url.Items);

	OptionSaveLoad(OpURLPanel,true);

	ListNameChange(Sender);
	Inifile.writetreeview('Tree',Tree);
	// Tree.SaveToFile(ChangeFileExt(Application.ExeName,'.txt'));

	if OpURLReset.Checked then Ini.clear;
	Ini.UpdateFile;
	Inifile.UpdateFile;
end;

procedure TTextDeFindForm.FormDestroy(Sender:TObject);
begin

	Ini.Free;
	Inifile.Free;

end;

function TTextDeFindForm.QueryContinueDrag(fEscapePressed:BOOL;grfKeyState:Longint):HResult;
begin
	if fEscapePressed or((MK_LBUTTON or MK_RBUTTON)=(grfKeyState and(MK_LBUTTON or MK_RBUTTON))) then
		Result:=DRAGDROP_S_CANCEL
	else if grfKeyState and MK_LBUTTON=0 then
		Result:=DRAGDROP_S_DROP
	else
		Result:=S_OK;
end;

procedure TTextDeFindForm.PTextTextReplaceClick(Sender: TObject);
begin
	ReplaceDialog.FindText := Text.SelText ;
	EnableReplaceReg:=false;
	ReplaceDialog.Options:=ReplaceDialog.Options-[frHideMatchCase];
	ReplaceDialog.Options:=ReplaceDialog.Options-[frHideWholeWord];
	ReplaceDialog.Execute() ;
end;

procedure TTextDeFindForm.PTextTextReplaceRegClick(Sender: TObject);
begin
	ReplaceDialog.FindText := Text.SelText ;
	EnableReplaceReg:=true;
	ReplaceDialog.Options:=ReplaceDialog.Options+[frHideMatchCase];
	ReplaceDialog.Options:=ReplaceDialog.Options+[frHideWholeWord];
	ReplaceDialog.Execute() ;
end;

procedure TTextDeFindForm.MTextDelKakkoClick(Sender: TObject);
var s:string;
	sa:TStringDynArray;
begin
	Text.Lines.Text:=TRegEx.Replace(Text.Lines.Text,'\(.*?\)','');
	Text.Lines.Text:=TRegEx.Replace(Text.Lines.Text,'\[.*?\]','');

	for s in self.Text.lines do
		sa.adduni(trim(s));
	with sa.stringselfcreate do try
		self.Text.lines.Assign(this);
	finally
		free;
    end;

end;


procedure TTextDeFindForm.ReplaceDialogFind(Sender: TObject);
var
	R: TReplaceDialog;
	ST : TSearchTypes;
	p,l,sels,sell:integer;
	rs,fs:string;
	regmop: TRegExOptions;
	regmt: TMatch;
	regg: TGroup;

begin
	R:=ReplaceDialog;
	fs:=R.FindText;
	if (frMatchCase in R.Options) then ST:=ST+[stMatchCase];
	if (frWholeWord in R.Options) then ST:=ST+[stWholeWord];

	sels:=Text.SelStart;
	sell:=Text.SelLength;

	p:=-1;
	l:=0;
	if frDown in R.Options then begin
		if EnableReplaceReg then begin

			Text.Lines.LineBreak:=LF;
			rs:=Text.Lines.Text;
			for regmt in TRegEx.Matches(rs,fs,regmop) do begin
				for regg in regmt.Groups do begin
//					if regg.Value=regmt.Value then continue;
					if regg.Index>sels+sell then begin
						p:=regg.Index-1;
						l:=regg.Length;
						break;
					end;
				end;
				if p>=0 then break;
			end;

		end else begin

			p:=Text.FindText(fs,sels+sell,Text.Lines.Text.Length-sels,ST);
			l:=fs.Length;

		end;
		if p>-1 then begin
			Text.SelStart:=p;
			Text.SelLength:=l;
		end;
	end;

end;

procedure TTextDeFindForm.ReplaceDialogReplace(Sender:TObject);
var
	l:Integer;
	s:Integer;
	R:TReplaceDialog;
	ss,fs,rs:string;
begin
	R:=ReplaceDialog;
	fs:=R.FindText;
	rs:=R.ReplaceText;

	repeat
		if EnableReplaceReg then begin

			Text.Lines.LineBreak:=LF;
			ReplaceDialogFind(Sender);
			Text.SelText:=TRegEx.Replace(Text.SelText,fs,rs);

		end else begin

			Text.SelLength:=0;
			ReplaceDialogFind(Sender);
			if (Text.SelLength>0) then begin
				l:=Text.SelLength;
				s:=Text.SelStart;
				Text.seltext:=R.ReplaceText;
				Text.SelStart:=s;
				Text.SelLength:=R.ReplaceText.Length;
			end;
		end;
		if not(frReplaceAll in R.Options) then break;
	until not((Text.SelLength>0));

end;

function TTextDeFindForm.GiveFeedback(dwEffect:Longint):HResult;
begin
	Result:=DRAGDROP_S_USEDEFAULTCURSORS;
end;

procedure TTextDeFindForm.PFileCopyClick(Sender:TObject);
begin
	Files.cutcopy(false);
end;

procedure TTextDeFindForm.PFileCutClick(Sender:TObject);
begin
	Files.cutcopy(true);
end;

function TTextDeFindForm.iddownload(Url:string):string;
var
	s:TStringStream;
begin
	IdHTTP.HandleRedirects:=true;
	IdHTTP.IOHandler.DefStringEncoding := IndyTextEncoding_UTF8;
	IdHTTP.Request.ContentEncoding := 'UTF-8';

	s:=TStringStream.Create('',TEncoding.UTF8);
	try
		Url:=TIdURI.ParamsEncode(Url,IndyTextEncoding_UTF8);
		IdHTTP.Get(Url,s);
		s.Position:=0;
		Result:=s.ReadString(s.Size);
//		setLength(Result,s.Size);
//		s.Read(Result[1],s.Size);
	finally
		FreeAndNil(s);
	end;
	IdHTTP.Disconnect;
end;

function TTextDeFindForm.tnetdownload(Url:string):string;
var
	s:TStringStream;
begin
//	IdHTTP.HandleRedirects:=true;
//	IdHTTP.IOHandler.DefStringEncoding := IndyTextEncoding_UTF8;
//	IdHTTP.Request.ContentEncoding := 'UTF-8';
	s:=TStringStream.Create('',TEncoding.UTF8);
	try
		Url:=TIdURI.ParamsEncode(Url,IndyTextEncoding_UTF8);
		NetHTTPRequest.Get(Url, s);
		s.Position:=0;
		Result:=s.ReadString(s.Size);
	finally
		FreeAndNil(s);
	end;
end;



function TTextDeFindForm.getsearchtext(Url:String):String;
var
	C,cc:Char;
begin

	if OpURLComment.Checked then begin
		if Url.IndexOf('//')>=0 then
			Url:=Url.Substring(0,Url.IndexOf('//'));
	end;

	if OpUrlSpace.Checked then begin
		for C in OpURLSpaceEdit.Text do begin
			Url:=Url.Replace(C,' ');
		end;
	end;

	if OpURLEscape.Checked then begin
		for C in OpURLEscapeEdit.Text do begin
			Url:=Url.Replace(C,format('%%%x',[(Ord(C))]));
		end;
	end;

	if OpURLZenkaku.Checked then begin
		Url:=zenkaku(Url);
	end;
	if OptionUrlDQuote.Checked then begin
		Url:='\"'+Url+'\"';
	end;

	Result:=trim(Url);
end;

procedure TTextDeFindForm.FindUrlButtonClick(Sender:TObject);
var
	urls,urlss,s,ss:string;
	ls,le,i,count:Integer;
	row:integer;
	hit:Integer;
	hitl:boolean;
	hitm:boolean;


	function rowadd(row:integer):integer;
	begin
		if sender=PReFind then begin
			result:=Files.RowInsert(row+1,1);
		end else begin
			Files.RowCount:=Files.RowCount+1;
			result:=Files.RowCount-1;
		end;
		Files.Rows[result].clear;
	end;

	function jsontogrid(Url:string):integer;
	var
		obj:TJSONObject;
		val:TJSONValue;
		vresults:TJSONArray;
		vitem:TJSONObject;
		pair:TJSONPair;
		i,r:Integer;
		hit:Integer;
		data:string;
		artist:string;
		s:string;
		hitm:boolean;
		function getval(k:string):string;
		begin
			try
				Result:=vitem.GetValue(k).Value;
			except
				Result:='';
			end;
		end;

	begin
		result:=0;
		data:=tnetdownload(Url);

		if OpURLOpenSave.Checked then begin
			Memo1.Lines.text:=data;
			Memo1.Lines.SaveToFile(ExtractFilePath(Application.ExeName)+ss+'_'+inttostr(Files.RowCount)+'.txt');
		end;
		try
			obj:=TJSONObject.ParseJSONValue(data) as TJSONObject;
			vresults:=obj.GetValue('results') as TJSONArray;
			hit:=0;
			for i:=0 to vresults.count-1 do begin
				vitem:=vresults.Items[i] as TJSONObject;;
				artist:=getval('artistName');
				if OpURLituneNazo.Checked then
					if not MatchesMask(artist,getsearchtext(ListName.Text)) then continue;
				if OpURLituneTitleMatch.Checked then begin
					hitm:=true;
					for s in getsearchtext(ss).Split([' ']) do begin
						if not MatchesMask(getval('trackName'),'*'+s+'*') then begin
							hitm:=false;
							break;
						end;
					end;
					if not hitm then continue;

				end;


				inc(hit);
				row:=rowadd(row);
				Files.cells[NTEXT,row]:=getsearchtext(ss);
				Files.cells[NFILE,row]:=getval('trackName');
				Files.cells[NPATH,row]:=getval('trackViewUrl').Replace('https:','itmss:');
				Files.cells[NNAME,row]:=getval('artistName');
				Files.cells[NALBAM,row]:=getval('collectionName');
				if getval('isStreamable')='true' then
					Files.cells[NOPEN,row]:='M';
				Files.cells[NOPEN2,row]:='S';
			end;

		except
		end;
		result:=hit;

	end;


	function datatogrid(Url:string):integer;
	var
		data:string;
		i,r:Integer;
	begin
		result:=0;
		data:=iddownload(Url);
		if data<>'' then begin
			row:=rowadd(row);
			Files.cells[NTEXT,row]:=getsearchtext(ss);
			Files.cells[NFILE,row]:=data;
			Files.cells[NPATH,row]:=url;
			result:=1;
		end;
	end;
	function datoi(const s:string;def:Integer):Integer;
	begin
		try
			Result:=StrToIntDef(TRegEx.Replace(s,'[^0-9\n]|^\n',''),def);
		except
			Result:=def;
		end;
	end;

	function stringcut(s,Key:string):string;
	begin
		Result:=s;
		if s.IndexOf(Key)>=0 then
			Result:=s.Substring(s.IndexOf(Key));

	end;

	function geturltext(Key:string):string;
	begin
		Result:=Url.Text;
		Result:=stringcut(Result,'itmss:');
		Result:=stringcut(Result,'http:');
		Result:=stringcut(Result,'https:');
		Result:=Result.Replace('%Xg%',getsearchtext(ListName.Text));
		Result:=Result.Replace('%%',getsearchtext(Key));
	end;

begin
	urlrun:=not urlrun;
	// with GridFiles do begin
	// for i:=selection.top to selection.Bottom do begin
	// end;

	// if Sender<>PTextFindUrlAdd then begin
	// Files.clear;
	// Files.RowCount:=1;
	// end;
	try
		if not urlrun then
			exit;
		try
			if DirectoryExists(getpathtext) then sa:=TDirectory.GetFiles(getpathtext,'*',TSearchOption.soAllDirectories);
		except
			sa.clear;
			// on E: Exception do ShowMessage(E.Message);
		end;

		Files.ColCount:=CHEADWEB.count;
		Files.Rows[0].setstrings(CHEADWEB);
		PFileUpdateClick(Sender);

		Screen.Cursor:=crHourGlass;

		if sender=PReFind then begin
			ls:=Files.Selection.Top;
			le:=Files.Selection.Bottom;
			row:=le+1;
		end else begin
			ls:=Text.Perform(EM_LINEFROMCHAR,Text.SelStart,0);
			le:=Text.Perform(EM_LINEFROMCHAR,Text.SelStart+Text.SelLength-1*Integer(Text.SelLength>0),0);
		end;

		for i:=ls to le do begin
			FindUrlButton.Caption:='~';
			row:=i;
			Caption:=Self.Name+format(' %d/%d',[i,le]);
			if sender=PReFind then
				ss:=Files.Cells[NTEXT,i]
			else
				ss:=Text.lines[i];

			if not urlrun then
				break;
			Application.ProcessMessages;
			urls:=geturltext(ss);
			urlss:=urls.Split(['%Tu%']).item(1);
			urls:=urls.Split(['%Tu%']).item(0);

			if urls='' then
				continue;

			hit:=0;
			if OpURLFile.Checked then
				hit:=datatogrid(urls)
			else if OpURLitune.Checked and(urls.IndexOf('itmss:')=0) then begin
				//Ȗƃ~bgzČȂƂ̂ŐɃXg+Ō
				urls:=urls.Replace('itmss:','https:');
				hit:=jsontogrid(urls);
				if hit=0 then begin
					if urlss<>'' then begin
						urlss:=urlss.Replace('itmss:','https:');
						hit:=jsontogrid(urlss);
					end;
				end;
			end else
				ShellExecute(Handle,'open',PChar(urls),'','',1);

			hitl:=false;
			if OpURLLocal.Checked then
				hitl:=localfind(sa,ss);

			if(hit=0)and(hitl=false) then begin
				row:=rowadd(row);
				Files.cells[NTEXT,row]:=getsearchtext(ss);
				Files.cells[NPATH,row]:=urls;
			end;

			if not (sender=PReFind) then
				if Files.RowCount>(Files.VisibleRowCount+1) then
					Files.TopRow:=Files.RowCount-Files.VisibleRowCount;
			Files.ColExpand(10);
			Files.setfixed;
			if i<le then
				sleep(Max(datoi(OpURLWait.Text,3000),1000));
		end;
	finally
		FindUrlButton.Caption:='URL';
		urlrun:=false;
		Screen.Cursor:=crDefault;

	end;

end;

procedure TTextDeFindForm.PReFindClick(Sender: TObject);
begin
	FindUrlButtonClick(PReFind);
end;


procedure TTextDeFindForm.PReloadClick(Sender: TObject);
begin
//	pname:='';
//	ListNameChange(sender);
	Inifile.readgrid('grid\'+ListName.Text,TGrid(GridFiles));

end;

procedure TTextDeFindForm.PFileExecClick(Sender:TObject);
begin
	with GridFiles do
		ShellExecute(Handle,'open',PChar(INCBS(cells[NPATH,row])+cells[NFILE,row]),'','',1);
end;

procedure TTextDeFindForm.PFileFolderClick(Sender:TObject);
begin
	with GridFiles do
		ShellExecute(Handle,'open',PChar(INCBS(cells[NPATH,row])),'','',1);

end;

procedure TTextDeFindForm.PFileOpenClick(Sender:TObject);
begin
	OpenDialog.DefaultExt:='csv';
	OpenDialog.Filter:='csv|csv|*|*';
	if OpenDialog.Execute then
		Files.save(OpenDialog.FileName);
end;

procedure TTextDeFindForm.PFilePasteClick(Sender:TObject);
begin
	Files.paste;
end;

procedure TTextDeFindForm.PFileSaveAsClick(Sender:TObject);
begin
	SaveDialog.DefaultExt:='csv';
	SaveDialog.Filter:='csv|csv|*|*';
	if SaveDialog.Execute then
		Files.save(SaveDialog.FileName);
end;


procedure TTextDeFindForm.PRowAddClick(Sender:TObject);
begin
	Files.RowInsert(Files.Selection.Top,Files.Selection.Bottom-Files.Selection.Top+1)
end;

procedure TTextDeFindForm.PRowDelClick(Sender:TObject);
begin
	Files.RowDelete(Files.Selection.Top,Files.Selection.Bottom-Files.Selection.Top+1)
end;

procedure TTextDeFindForm.PTextCopyClick(Sender:TObject);
begin
	Text.CopyToClipboard;
end;

procedure TTextDeFindForm.PTextCutClick(Sender:TObject);
begin
	Text.CutToClipboard;
end;

procedure TTextDeFindForm.PTextFindClick(Sender:TObject);
begin
	FindClick(Sender);
end;

procedure TTextDeFindForm.PTextFindUrlAddClick(Sender:TObject);
begin
	FindUrlButtonClick(Sender);
end;

procedure TTextDeFindForm.PTextFindUrlClick(Sender:TObject);
begin
	FindUrlButtonClick(Sender);
end;

procedure TTextDeFindForm.PTextListNameClick(Sender: TObject);
begin
	ListName.Text:=InputBox('Xg','Xg',ListName.Text);

	pname:=ListName.Text;
end;

procedure TTextDeFindForm.PTextOpenClick(Sender:TObject);
begin
	OpenDialog.DefaultExt:='txt';
	OpenDialog.Filter:='txt|txt|*|*';
	if OpenDialog.Execute then
		Text.lines.LoadFromFile(OpenDialog.FileName);
end;

procedure TTextDeFindForm.PTextPasteClick(Sender:TObject);
begin
	Text.PasteFromClipboard;
end;

procedure TTextDeFindForm.PTextSaveAsClick(Sender:TObject);
begin
	SaveDialog.DefaultExt:='txt';
	SaveDialog.Filter:='txt|txt|*|*';
	if SaveDialog.Execute then
		Text.lines.SaveToFile(SaveDialog.FileName);

end;

function gridInRect(X,Y:Integer;const r:TGridRect):boolean;
begin
	Result:=true;
	if ((X<r.left)or(X>r.right)or(Y<r.Top)or(Y>r.Bottom)) then
		Result:=false;
end;

procedure TTextDeFindForm.GridFilesMouseDown(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
var
	ACol,ARow:Longint;

begin
	Files.MouseToCell(X,Y,ACol,ARow);
	if gridInRect(ACol,ARow,Files.Selection) then
		exit;
	Files.MouseToCell(X,Y,ACol,ARow);

end;

procedure TTextDeFindForm.GridFilesSelectCell(Sender:TObject;ACol,ARow:Integer;var CanSelect:boolean);
var
	s,d:string;
begin
	PFileUpdateClick(Sender);
	if ACol=NOPEN then
		s:=Files.cells[NPATH,ARow];
	if ACol=NOPEN2 then
		s:=Files.cells[NPATH,ARow]+'&app=itunes';

	if s='' then exit;
	if OpURLOpenSave.Checked then begin
		Memo1.Lines.text:=iddownload(s.Replace('itmss:','https:'));
		Memo1.Lines.SaveToFile(ExtractFilePath(Application.ExeName)+Zenkaku(Files.cells[NFILE,ARow])+'_'+Zenkaku(Files.cells[NALBAM,ARow])+'.txt');
	end;



	ShellExecute(Handle,'open',PChar(s),'','',1);

	// if s.IndexOf('http:')<>0 then
	// if s.IndexOf('https:')<>0 then
	// if s.IndexOf('itmss:')<>0 then
	// exit;

end;

procedure TTextDeFindForm.GridFilesSetEditText(Sender:TObject;ACol,ARow:Integer;const Value:string);
begin
	// ShowMessage(Value);
	// GridFiles.Options:=GridFiles.Options-[goEditing]+[goRangeSelect];

end;

procedure TTextDeFindForm.TextMouseUp(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
var
	l:Integer;
begin
	if Text.SelLength=0 then begin
		l:=Text.Perform(EM_LINEFROMCHAR,System.NativeUInt(-1),0);
		Text.SelStart:=Text.Perform(EM_LINEINDEX,System.NativeUInt(l),0);
		Text.SelLength:=Text.Perform(EM_LINEINDEX,System.NativeUInt(l+1),0)-Text.SelStart;
	end;
end;

procedure TTextDeFindForm.TreeClick(Sender:TObject);
var
	N:TTreeNode;
	ppname:string;
	i:Integer;

begin

	ppname:=ListName.Text;


	// for i:=Name.Items.Count-1 downto 1 do
	// Name.Items.Delete(i);

	TMP.clear;
	N:=Tree.Items.GetFirstNode;
	while N<>nil do begin
		TMP.Items.add(N.Text);
		N:=N.getNextSibling;
	end;
	ListName.Enabled:=false;
	ListName.Items.Text:=TMP.Items.Text;
	// Name.ItemIndex:=-1;
	// Name.Text:=ppname;
	ListName.ItemIndex:=ListName.Items.IndexOf(ppname);
	// Application.ProcessMessages;
	ListName.Enabled:=true;
end;

function inputtextbox(P:TForm;C:TWinControl;Text:string):string;
var
	f:TForm;
	M:TMemo;
	r:TRect;
begin
	f:=TForm.Create(P);
	M:=TMemo.Create(f);
	try
		f.Font:=P.Font;
		// F.BorderStyle:=bsSingle;
		r:=P.BoundsRect;
		r.Top:=C.ClientToScreen(C.BoundsRect.BottomRight).Y;
		r.Height:=500;
		// R.Inflate(0,0,0,100);
		f.BoundsRect:=r;
		M.Parent:=f;
		M.Align:=alClient;
		M.Text:=Text;
		M.ScrollBars:=ssBoth;
		f.Position:=poDesigned;
		f.ShowModal;
		Result:=M.Text;
	finally
		f.Free;
	end;
end;

procedure TTextDeFindForm.PathEditButtonClick(Sender:TObject);
begin
	Path.Items.Text:=inputtextbox(Self,Path,Path.Items.Text);
end;

procedure TTextDeFindForm.PathSelButtonClick(Sender:TObject);
var
	SelectFolder:String;
begin
	SelectFolder:=Path.Text;
	if SelectDirectory(Path.Text,'',SelectFolder,[sdNewUI,sdNewFolder,sdShowEdit],Self) then begin
		Path.Text:=SelectFolder;
	end;
end;

procedure TTextDeFindForm.PClearClick(Sender:TObject);
begin
	Files.clear;
	Files.RowCount:=1;
end;

procedure TTextDeFindForm.PColAddClick(Sender:TObject);
begin
	Files.ColInsert(Files.Col,1);
end;

procedure TTextDeFindForm.PColDelClick(Sender:TObject);
begin
	Files.ColDelete(Files.Col,1);
end;

procedure TTextDeFindForm.UrlEditButtonClick(Sender:TObject);
begin
	Url.Items.Text:=inputtextbox(Self,Url,Url.Items.Text);
end;

procedure TTextDeFindForm.Button1Click(Sender:TObject);
begin
	TreeClick(Sender);
end;

procedure TTextDeFindForm.ListNameChange(Sender:TObject);
var
	N,NN:TTreeNode;
	s:string;
	function childtext(N:TTreeNode):string;
	begin
		N:=N.getFirstChild;
		while N<>nil do begin
			Text.lines.add(N.Text);
			N:=N.getNextSibling;
		end;

	end;

begin
	if trim(pname)<>'' then begin
		N:=Tree.Items.GetFirstNode;
		NN:=nil;
		while N<>nil do begin
			if N.Text=pname then begin
				NN:=N;
				break;
			end;
			N:=N.getNextSibling;
		end;
		if trim(Text.lines.Text)='' then begin // Ȃ烊Xg
			if NN<>nil then begin
				NN.Delete;
				TreeClick(Sender);
			end;

		end
		else begin // ȊOȂ烊Xg
			if NN=nil then begin
				NN:=Tree.Items.add(nil,pname);
				TreeClick(Sender);
			end;

			NN.DeleteChildren;
			for s in Text.lines do Tree.Items.AddChild(NN,trim(s));

			Inifile.writegrid('grid\'+pname,TGrid(GridFiles));
		end;

	end;

	Text.Text:='';
	N:=Tree.Items.GetFirstNode;
	while N<>nil do begin
		if N.Text=ListName.Text then begin
			childtext(N);
			Inifile.readgrid('grid\'+ListName.Text,TGrid(GridFiles));
		end;
		N:=N.getNextSibling;
	end;

	pname:=ListName.Text;
end;

procedure TTextDeFindForm.OpURLButtonClick(Sender:TObject);
begin
	OpURLPanel.Visible:=not OpURLPanel.Visible;
end;

function TTextDeFindForm.getpathtext:string;
var
	ls,le:Integer;
begin
	ls:=Text.Perform(EM_LINEFROMCHAR,Text.SelStart,0);
	Result:=Path.Text;
	Result:=Result.Replace('%Xg%',getsearchtext(ListName.Text));
	Result:=Result.Replace('%%',Text.lines[ls]);
	if Result='' then
		exit;
	Result:=INCBS(Result);
end;

function TTextDeFindForm.localfind(var sa:TStringDynArray;ssss:string):boolean;
var
	snm,nm:string;
	s,ss,sss:string;
	i,j,r,si:Integer;
	hit:boolean;
	function findr(s:string):string;
	begin
		s:=s.ToUpper;
		s:=zenkaku(s);
		// s:=s.Replace('@','');
		// s:=s.Replace('E','');
		Result:=trim(s);
	end;

begin
	sss:=findr(ssss);
	si:=pos('@',sss);
	if si=0 then si:=pos('E',sss);
	if si=0 then si:=4;
	si:=si-1;

	for j:=Length(sss) downto si do begin

		ss:=sss.Substring(0,j);
		for s in sa do begin
			nm:=trim((ss));
			if nm='' then
				continue;

			if pos('*',nm)=0 then
				if pos('?',nm)=0 then nm:='*'+nm+'*';
			snm:=findr(ExtractFileName(s));
			if MatchesMask(snm,nm) then begin
				r:=Files.RowCount;
				Files.RowCount:=r+1;
				Files.Rows[r].clear;
				Files.cells[NTEXT,r]:=trim(ssss);
				Files.cells[NPATH,r]:=ExtractFileDir(s);
				Files.cells[NFILE,r]:=ExtractFileName(s);
				hit:=true;
			end;
		end;
		if hit then
			break;
	end;
	Result:=hit;
end;






procedure TTextDeFindForm.FindClick(Sender:TObject);
var
	s,ss:string;
	sub:boolean;
	ls,le,i,j,r,count:Integer;
	pathtext:string;
	snm:string;
begin
	try
		Screen.Cursor:=crHourGlass;
		Application.ProcessMessages;

		pathtext:=getpathtext;
		// snm:=ExtractFileName(Path.Text);
		// if snm='' then
		snm:='*';

		// if sub then
		op:=TSearchOption.soAllDirectories;
		// else
		// op := TSearchOption.soTopDirectoryOnly;
		try
			sa:=TDirectory.GetFiles(pathtext,snm,op);
		except
			on e:Exception do
				ShowMessage(e.Message);
		end;
		Files.RowCount:=1;
		Files.ColCount:=CHEAD.count;
		Files.Rows[0].setstrings(CHEAD);
		PFileUpdateClick(Sender);

		if Sender=Find then begin
			ls:=0;
			le:=Text.lines.count-1;

		end
		else begin
			ls:=Text.Perform(EM_LINEFROMCHAR,Text.SelStart,0);
			le:=Text.Perform(EM_LINEFROMCHAR,Text.SelStart+Text.SelLength-1*Integer(Text.SelLength>0),0);
		end;
		for i:=ls to le do begin
			ss:=Text.lines[i];

			if not localfind(sa,ss) then begin
				r:=Files.RowCount;
				Files.RowCount:=r+1;
				Files.Rows[r].clear;
				// Files.rowval(r).get(NTEXT);
				Files.cells[NTEXT,r]:=trim(ss);
			end;
		end;
		Files.ColExpand(10);
		Files.FixedRows:=1;

	finally
		Screen.Cursor:=crDefault;
	end;
end;

function TTextDeFindForm.GetFilePathDataObject(G:TStringGrid):IDataObject;
var
	ISFD,ISF:IShellFolder;
	PItems:packed array of PItemIDList;
	PItem:PItemIDList;
	pchEaten,dwAttributes:Cardinal;
	fn,fnpath:Widestring;
	i,count:Integer;
begin
	Result:=nil;
	count:=0;

	SHGetDesktopFolder(ISFD);
	if Failed(ISFD.ParseDisplayName(0,nil,PWideChar(EXCBS(getpathtext)),pchEaten,PItem,dwAttributes)) then
		exit;
	if Failed(ISFD.BindToObject(PItem,nil,IID_IShellFolder,ISF)) then
		exit;

	for i:=G.Selection.Top to G.Selection.Bottom do begin
		fn:=INCBS(G.cells[NPATH,i])+G.cells[NFILE,i];

		if not FileExists(fn) then
			continue;
		inc(count);
		SetLength(PItems,count);
		fnpath:=ExtractRelativePath(INCBS(getpathtext),fn);

		if Failed(ISF.ParseDisplayName(0,nil,PWideChar(fnpath),pchEaten,PItems[count-1],dwAttributes)) then
			exit;
	end;
	if count<1 then
		exit;

	ISF.GetUIObjectOf(0,count,PItems[0],IDataObject,nil,Pointer(Result));
end;



// --------------------------------------------------------------------------------

procedure TGrid.copy(G:TGrid);
var
	r:TGridRect;
begin
	ColCount:=G.ColCount;
	RowCount:=G.RowCount;
	r:=G.Selection;
	G.Selection:=TGridRect(rect(1,1,G.ColCount-1,G.RowCount-1));
	G.selrowdo(
		procedure(X,Y:Integer)
		begin
			Rows[Y]:=G.Rows[Y];
		end);
	G.Selection:=r;

end;

constructor TGrid.CreateEX(Origin:TStringGrid);
var
	MS:TMemoryStream;
begin
	Create(Origin.Owner);
	Self.Parent:=Origin.Parent;
	Self.Options:=Origin.Options;
	Self.OnSetEditText:=Origin.OnSetEditText;
	Self.OnSelectCell:=Origin.OnSelectCell;
	Self.OnMouseDown:=Origin.OnMouseDown;
	Self.OnMouseMove:=Origin.OnMouseMove;
	buf:=TGrid.Create(Self);

	MS:=TMemoryStream.Create;
	try
		MS.WriteComponent(Origin);
		Origin.Free;
		MS.Position:=0;
		MS.ReadComponent(Self);
	finally
		MS.Free;
	end;
end;

procedure TGrid.WMChar(var Msg:TWMChar);
begin
	if ((CharInSet(Char(Msg.CharCode),[^H])or(Char(Msg.CharCode)>=#32))) then begin
		Options:=Options+[goEditing];
		EditorMode:=true;

	end
	else
		inherited;
end;

procedure TGrid.cutcopy(modecut:boolean);
var
	i,j:Integer;
	xs,ys,xw,yw:Integer;
	Txt:TStringList;
	s,ss:String;
	r:TGridRect;

	function d_dquotedstr(const s,d:string):string;
	var
		C:Char;
		B:boolean;
	begin
		Result:=s;
		B:=false;
		if d='' then
			B:=true;
		for C in s do
			if pos(C,d)>0 then
				B:=true;

		if not B then
			exit;
		Result:='"'+s+'"';
	end;

begin
	if not Focused then
		exit;
	if modecut then
		buf.copy(Self);

	ys:=Selection.Top;
	xs:=Selection.left;
	yw:=Selection.Bottom-ys;
	xw:=Selection.right-xs;

	Txt:=TStringList.Create;
	for i:=0 to yw do begin
		s:='';
		for j:=0 to xw do begin
			if j>0 then
				s:=s+#9;
			ss:=StringReplace(cells[xs+j,ys+i],#9,'',[rfReplaceAll]);
			// ^u͍폜
			// if Pos(ss,CRLF)>0 then
			ss:=d_dquotedstr(ss,CRLF);
			s:=s+ss;
			if modecut then
				cells[xs+j,ys+i]:='';
		end;
		Txt.add(s);
	end;
	s:=Txt.Text;
	s[Length(s)-1]:=#0;
	Clipboard.AsText:=s;
	Txt.Free;
end;

function TGrid.paste:TGridRect;
var
	i,j,si,colcnt:Integer;
	s:String;
	Txt:TStringList;
	ltxt:string;
	xs,ys,xw,yw,cnt:Integer;
	cols:TStringDynArray;

begin
	if not Focused then
		exit;
	buf.copy(Self);

	Txt:=TStringList.Create;
	s:=StringReplace(Clipboard.AsText,CRLF,CR,[rfReplaceAll]);
	for ltxt in SplitString(s,CR) do
		Txt.add(ltxt);

	ys:=Selection.Top;
	xs:=Selection.left;
	yw:=Txt.count-1;
	xw:=1;
	for i:=0 to yw do begin
		s:=Txt[i];
		colcnt:=SplitString(s,#9).count;
		if xw<colcnt then
			xw:=colcnt;
	end;
	dec(xw);

	si:=1;
	for i:=0 to yw do begin
		for j:=0 to xw do begin
			cols:=SplitString(Txt[i],#9);
			s:=cols.item(j);
			cells[xs+j,ys+i]:=s;
		end;
	end;
	Txt.Free;
	Result:=TGridRect(rect(xs,ys,xs+xw,ys+yw));
end;

procedure TGrid.savebuf;
begin
	saverect:=Selection;
	buf.copy(Self);
end;

function TGrid.save(fn:string):boolean;
var
	i:Integer;
begin
	try
		sl.clear;
		for i:=0 to RowCount-1 do begin
			Rows[i].StrictDelimiter:=true;
			Rows[i].Delimiter:=',';
			Rows[i].QuoteChar:='"';
			sl.add(Rows[i].DelimitedText);
		end;
		sl.save(fn);
	except

	end;
end;

procedure TGrid.setfixed;
begin
	if ColCount>1 then FixedCols:=1;
	if RowCount>1 then FixedRows:=1;
end;

function TGrid.load(fn:string):boolean;
var
	i:Integer;
	TMP:TStringList;
begin
	try
		TMP:=TStringList.Create;
		RowCount:=1;
		DrawingStyle:=gdsClassic;
		DefaultRowHeight:=round(-Font.Height*1.5);
		sl.load(fn);
		RowCount:=sl.count;
		for i:=0 to sl.hi do begin
			TMP.Delimiter:=',';
			TMP.QuoteChar:='"';
			TMP.StrictDelimiter:=true;
			TMP.DelimitedText:=sl[i];
			Rows[i]:=TMP;
		end;

		ColCount:=CHEAD.count;
		Rows[0].setstrings(CHEAD);
		setfixed;

		savebuf;
		ColExpand(10);
	finally
		TMP.Free;
	end;
end;

procedure TGrid.seldel;
begin
	savebuf;
	seldo(
		procedure(X,Y:Integer)
		begin
			cells[X,Y]:='';
		end);
end;

function TGrid.seldo(func:TFuncXY):Integer;
var
	i,j:Integer;
begin
	for i:=Selection.Top to Selection.Bottom do
		for j:=Selection.left to Selection.right do
			func(j,i);
end;

function TGrid.alldo(func:TFuncXY):Integer;
var
	i,j:Integer;
begin
	for i:=0 to RowCount-1 do
		for j:=0 to ColCount-1 do
			func(j,i);
end;

function TGrid.selrowdo(func:TFuncXY):Integer;
var
	i:Integer;
begin
	for i:=Selection.Top to Selection.Bottom do
		func(0,i);
end;

function TGrid.seltext:string;
begin
	Result:=cells[Col,row];
end;

procedure TGrid.SetEditText(ACol,ARow:Integer;const Value:string);
begin
	inherited;
	Options:=Options-[goEditing]+[goRangeSelect];
end;

function TGrid.rowdo(func:TFuncXY):Integer;
var
	i:Integer;
begin
	for i:=0 to RowCount-1 do
		func(0,i);

end;

procedure TGrid.KeyDown(var Key:Word;Shift:TShiftState);
var
	w:Word;
begin
	if ssCtrl in Shift then begin
		if Key=17 then
			exit;
		case Key of
			Word('X'):cutcopy(true);
			Word('C'):cutcopy(false);
			Word('V'):paste;
			Word('Z'):copy(buf);
		end;
	end
	else begin
		case Key of
			VK_DELETE:seldel;
		end;
	end;

	inherited;
end;

procedure TGrid.MouseDown(Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
var
	ACol,ARow:Longint;

begin
	MouseToCell(X,Y,ACol,ARow);
	downinselection:=gridInRect(ACol,ARow,Selection);
	if ssDouble in Shift then begin
		Options:=Options+[goEditing]-[goRangeSelect];
		Col:=ACol;
		row:=ARow;
		EditorMode:=true;
	end;
	if downinselection then
		exit;
	inherited;
end;

procedure TGrid.MouseMove(Shift:TShiftState;X,Y:Integer);
var
	DataObject:IDataObject;
	s:string;
	dwEffect:Integer;
	ACol,ARow:Longint;
	savesel:TGridRect;

begin
	MouseToCell(X,Y,ACol,ARow);
	if not downinselection then begin
		inherited;
		exit;

	end;
	if not(csLButtonDown in ControlState) then
		exit;

	s:=Application.ExeName;
	// {^ꂽԂŁA}EẌʒu臒l𒴂hbOJn

	if (csLButtonDown in ControlState)and((Abs(X-FMouseDownPt.X)>=Mouse.DragThreshold)or(Abs(Y-FMouseDownPt.Y)>=Mouse.DragThreshold)) then begin

		savesel:=Selection;
		Perform(WM_LBUTTONUP,0,MakeLong(X,Y));
		// Files.Enabled:=false;
		Selection:=savesel;
		// BeginDrag(true);

		DataObject:=TextDeFindForm.GetFilePathDataObject(Self);
		dwEffect:=DROPEFFECT_NONE;
		DoDragDrop(DataObject,TextDeFindForm,DROPEFFECT_COPY,dwEffect);
	end;
end;

function GetNumScrollLines:Integer;
begin
	SystemParametersInfo(SPI_GETWHEELSCROLLLINES,0,@Result,0);
end;

function TGrid.DoMouseWheelDown(Shift:TShiftState;MousePos:TPoint):boolean;
var
	i:Integer;
begin
	for i:=1 to GetNumScrollLines do
		SendMessage(Handle,WM_VSCROLL,SB_LINEDOWN,0);
	Result:=true;
end;

function TGrid.DoMouseWheelUp(Shift:TShiftState;MousePos:TPoint):boolean;
var
	i:Integer;
begin
	for i:=1 to GetNumScrollLines do
		SendMessage(Handle,WM_VSCROLL,SB_LINEUP,0);
	Result:=true;
end;

function TGrid.ColExpand(min:Integer):Integer;
var
	i,j:Integer;
	w1,w2,w3:Integer;
begin
	w3:=0;
	Canvas.Font:=Font;
	for j:=0 to ColCount-1 do begin
		w1:=0;
		for i:=0 to RowCount-1 do begin
			w2:=Canvas.TextWidth('['+cells[j,i]);
			if (w1<w2) then
				w1:=w2;
		end;
		if w1<min then
			w1:=min;
		ColWidths[j]:=w1;
		w3:=w3+(w1)+GridLineWidth;
	end;
	for j:=0 to ColCount-1 do
		if ColWidths[j]>gridWidth then
			ColWidths[j]:=trunc(gridWidth/2);

	DefaultRowHeight:=Canvas.TextHeight('')+2;
	Result:=w3+4;
end;

procedure TGrid.clear;
begin
	alldo(
		procedure(X,Y:Integer)
		begin
			cells[X,Y]:='';
		end);
end;

function TGrid.ColClear(X,cnt:Integer):Integer;
var
	i:Integer;
begin
	if (X<0) then
		X:=0;
	if X>=ColCount then
		X:=ColCount;
	for i:=0 to cnt-1 do
		cols[X+i].clear();
	Result:=X+cnt-1;
end;

function TGrid.ColDelete(X,cnt:Integer):Integer;
var
	i:Integer;
	w:Integer;
begin
	Result:=0;
	if cnt<0 then
		exit;
	if X<0 then
		exit;
	if X>=ColCount then
		exit;
	w:=ColCount-cnt;
	for i:=X to w-1 do begin
		cols[i]:=cols[i+cnt];
		ColWidths[i]:=ColWidths[i+cnt];
	end;
	RowClear(w,cnt);
	ColCount:=w;
	Result:=ColCount-1;
end;

function TGrid.ColInsert(X,cnt:Integer):Integer;
var
	i:Integer;
	lcnt:Integer;
begin
	if cnt<0 then
		exit;
	if (X<0)or(X>=ColCount) then
		X:=ColCount;
	ColCount:=ColCount+cnt;
	lcnt:=ColCount;

	for i:=lcnt-1 downto X+cnt do begin
		cols[i]:=cols[i-cnt];
		ColWidths[i]:=ColWidths[i-cnt];
	end;
	for i:=0 to cnt-1 do
		cols[X+i].clear();
	Result:=X+cnt-1;
end;

function TGrid.RowDelete(Y,cnt:Integer):Integer;
var
	i:Integer;
	w:Integer;
begin
	Result:=0;
	if cnt<0 then
		exit;
	if Y<0 then
		exit;
	if Y>=RowCount then
		exit;
	w:=RowCount-cnt;
	for i:=Y to w-1 do begin
		Rows[i]:=Rows[i+cnt];
		RowHeights[i]:=RowHeights[i+cnt];
	end;
	RowClear(w,cnt);
	RowCount:=w;
	Result:=RowCount-1;
end;

function TGrid.RowInsert(Y,cnt:Integer):Integer;
var
	i:Integer;
	lcnt:Integer;
begin
	if cnt<0 then
		exit;
	if (Y<0)or(Y>=RowCount) then
		Y:=RowCount;
	RowCount:=RowCount+cnt;
	lcnt:=RowCount;

	for i:=lcnt-1 downto Y+cnt do begin
		Rows[i]:=Rows[i-cnt];
		RowHeights[i]:=RowHeights[i-cnt];
	end;
	for i:=0 to cnt-1 do
		Rows[Y+i].clear();
	Result:=Y+cnt-1;
end;

function TGrid.RowClear(Y,cnt:Integer):Integer;
var
	i:Integer;
begin
	if (Y<0) then
		Y:=0;
	if Y>=RowCount then
		Y:=RowCount;
	for i:=0 to cnt-1 do
		Rows[Y+i].clear();
	Result:=Y+cnt-1;
end;

function TStringDynArrayHelper.add(s:string):Integer;
begin
	SetLength(Self,Length(Self)+1);
	Self[Length(Self)-1]:=s;
	Result:=Length(Self);

end;

function TStringDynArrayHelper.getcount:Integer;
begin
	Result:=Length(Self);
end;

procedure TStringDynArrayHelper.setcount(const i:Integer);
begin
	SetLength(Self,i);
end;

function TStringDynArrayHelper.hi:Integer;
begin
	Result:=High(Self);

end;

function TStringDynArrayHelper.item(i:Integer):String;
begin
	Result:='';
	if i<0 then
		exit;
	if i>High(Self) then
		exit;
	Result:=Self[i];
end;

function TStringDynArrayHelper.save(f:string):boolean;
begin
	with stringselfcreate do
		try
			SaveToFile(f,TEncoding.UTF8);
		except
			Free;
		end;
end;

function TStringDynArrayHelper.load(f:string):boolean;
begin
	with TStringList.Create do
		try
			LoadFromFile(f);
			Self:=TStringDynArray(ToStringArray);
		except
			Free;
		end;
end;

function TStringDynArrayHelper.stringselfcreate:TStringSelf;
var
	s:string;
begin
	Result:=TStringSelf.Create;
	for s in Self do
		Result.add(s);
end;

function TStringDynArrayHelper.adduni(s:string):Integer;
var
	i:Integer;
begin
	for i:=0 to hi do
		if Self[i]=s then
			exit(-1);
	add(s);
	Result:=count;
end;

function TStringDynArrayHelper.cat(s,e:string):String;
var
	T:string;
begin
	for T in Self do
		Result:=Result+s+T+e;
end;

procedure TStringDynArrayHelper.clear;
begin
	SetLength(Self,0);
end;

function TStringSelf.this:TStringList;
begin
	exit(Self);
end;

{ TStringsHelper }

function TStringsHelper.setstrings(sa:TStringDynArray):Integer;
var
	i:Integer;
begin
	for i:=0 to sa.count-1 do
		if i<count then Self[i]:=sa[i];
end;

{ TIniFileHelper }

procedure TMemIniFileHelper.readgrid(sc:string;G:TGrid);
var
	X,Y:Integer;
	s:string;
begin
	G.rowdo(
		procedure(X,Y:Integer)
		begin
			G.Rows[Y].clear;
		end);
	G.RowCount:=1;
	G.ColCount:=1;
	for Y:=0 to MAXLIST do begin
		for X:=0 to 10 do begin
			s:=inttostr(Y)+','+inttostr(X);
			if not ValueExists(sc,s) then
				break;
			if X>=G.ColCount then
				G.ColCount:=X+1;
			if Y>=G.RowCount then
				G.RowCount:=Y+1;
			G.cells[X,Y]:=ReadString(sc,inttostr(Y)+','+inttostr(X),'');
		end;
	end;
	if G.RowCount<2 then
		G.RowCount:=2;

	// G.Rows[0].setstrings(CHEAD);
	G.setfixed;
	G.ColExpand(10);
end;

procedure TMemIniFileHelper.writegrid(sc:string;G:TGrid);
begin
	EraseSection(sc);
	G.alldo(
		procedure(X,Y:Integer)
		begin
			WriteString(sc,inttostr(Y)+','+inttostr(X),G.cells[X,Y]);
		end);

end;

procedure TMemIniFileHelper.readstrings(sc:string;sl:TStrings);
var
	i:Integer;
	s:string;
begin

	if ValueExists(sc,'0') then
		sl.clear;
	for i:=0 to MAXLIST do begin
		if not ValueExists(sc,inttostr(i)) then
			break;
		sl.add(ReadString(sc,inttostr(i),''));
	end;
end;

procedure TMemIniFileHelper.writestrings(sc:string;sl:TStrings);
var
	i:Integer;
begin
	EraseSection(sc);
	// if sl.text='' then exit;
	for i:=0 to sl.count-1 do WriteString(sc,inttostr(i),sl[i]);
end;

procedure TMemIniFileHelper.readtreeview(sc:string;T:TTreeView);
var
	N:TTreeNode;
	i:Integer;
	procedure sub(Key:string;N:TTreeNode);
	var
		i:Integer;
		k:string;
	begin
		for i:=0 to MAXLIST do begin
			k:=Key+','+inttostr(i);
			if not ValueExists(sc,k) then
				break;
			T.Items.AddChild(N,ReadString(sc,k,''));
			sub(k,N);
		end;
	end;

begin
	if SectionExists(sc) then
		T.Items.clear;
	for i:=0 to MAXLIST do begin
		if not ValueExists(sc,inttostr(i)) then
			break;
		N:=T.Items.add(nil,ReadString(sc,inttostr(i),''));
		sub(inttostr(i),N);
	end;

end;

procedure TMemIniFileHelper.writetreeview(sc:string;T:TTreeView);
var
	N:TTreeNode;
	i:Integer;
	procedure sub(Key:string;N:TTreeNode);
	var
		i:Integer;
	begin
		N:=N.getFirstChild;
		i:=0;
		while N<>nil do begin
			WriteString(sc,Key+','+inttostr(N.index),N.Text);
			sub(sc,N);
			N:=N.getNextSibling;
			inc(i);
		end;
	end;

begin
	EraseSection(sc);
	i:=0;
	N:=T.Items.GetFirstNode;
	while N<>nil do begin
		WriteString(sc,inttostr(N.index),N.Text);
		sub(inttostr(N.index),N);
		N:=N.getNextSibling;
		inc(i);
	end;
end;

initialization

SHGetMalloc(Malloc);
OleInitialize(nil);

// I
finalization

OleUninitialize;
Malloc:=nil;

end.
