/* t@C֌W */

#include "bootpack.h"

void file_readfat(int *fat, unsigned char *img)
/* fBXNC[WFAT̈kƂ */
{
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		fat[i + 0] = (img[j + 0]      | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
	return;
}

void file_loadfile(int clustno, int size, char *buf, int *fat, char *img)
{
	int i;
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[clustno * 512 + i];
			}
			break;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[clustno * 512 + i];
		}
		size -= 512;
		buf += 512;
		clustno = fat[clustno];
	}
	return;
}

struct FILEINFO *file_search(char *name, struct FILEINFO *finfo, int max)
{
	int i, j;
	char s[12];
	for (j = 0; j < 11; j++) {
		s[j] = ' ';
	}
	j = 0;
	for (i = 0; name[i] != 0; i++) {
		if (j >= 11) { return 0; /* Ȃ */ }
		if (name[i] == '.' && j <= 8) {
			j = 8;
		} else {
			s[j] = name[i];
			if ('a' <= s[j] && s[j] <= 'z') {
				/* ͑啶ɒ */
				s[j] -= 0x20;
			} 
			j++;
		}
	}
	for (i = 0; i < max; ) {
		if (finfo->name[0] == 0x00) {
			break;
		}
		if ((finfo[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (finfo[i].name[j] != s[j]) {
					goto next;
				}
			}
			return finfo + i; /* t@C */
		}
next:
		i++;
	}
	return 0; /* Ȃ */
}

char *file_loadfile2(int clustno, int *psize, int *fat)
{
	int size = *psize, size2;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char *buf, *buf2;
	buf = (char *) memman_alloc_4k(memman, size);
	file_loadfile(clustno, size, buf, fat, (char *) (ADR_DISKIMG + 0x003e00));
	if (size >= 17) {
		size2 = tek_getsize(buf);
		if (size2 > 0) {	/* tekkĂ */
			buf2 = (char *) memman_alloc_4k(memman, size2);
			tek_decomp(buf, buf2, size2);
			memman_free_4k(memman, (int) buf, size);
			buf = buf2;
			*psize = size2;
		}
	}
	return buf;
}

//FAT12`̃t@C`FbN`
int fat12_filename_check(char *filename,char *style){
  int i,i2;

  //fat12pȂ̂ł͌ߑłłII
  char filen[8];
  char extn[3];

  //܂͕̃`FbN
  for ( i = 0; i <= 13; i++)
    {
      if ( filename[i] == 0x00 || filename[i] == 0x0a ) {break;}
    }
  //邼I
  if ( i == 13 ){return 20;}


  //sȕ̌
  for ( i = 0; i <= 11; i++ )
    {
      if ( filename[i] == 0x00 ){break;}

      //0x1fȉȂ疳Ɉُ
      if ( filename[i] <= 0x1f ){return i+1;}

      //0x7fȏȂ疳Ɉُ
      if ( filename[i] >= 0x7f ){return i+1;}
		
      //Xy[X`)܂łُ͈
      if ( 0x20 <= filename[i] && filename[i] <= 0x29 ){return i+1;}

      // * ` ,@̓_
      if ( 0x2a <= filename[i] && filename[i] <= 0x2c ){return i+1;}

      // - `9܂łOK

      //F`܂ł̓_
      if ( 0x3a <= filename[i] && filename[i] <= 0x3e ){return i+1;}

      // H̓_
      if ( filename[i] == 0x3f ) {return i+1;}

      //@̓_
      if ( filename[i] == 0x40 ) {return i+1;}

      //A`Z܂łOK

      //[̓_
      if ( filename[i] == 0x5b ) {return i+1;}

      //\OK

      //]̓_
      if ( filename[i] == 0x5d ){return i+1;} 

      //O``܂ł̓_
      if ( 0x5e <= filename[i] && filename[i] <= 0x60 ){return i+1;}

      //a`z܂łOK
	      
      //{`~܂ł̓_
      if ( 0x7b <= filename[i] && filename[i] <= 0x7e ){return i+1;}

    }

  //̂悤Ȃ̂Ő`Jn

  //UXy[XŖ߂
  for ( i = 0; i <= 7; i++)
    {
      filen[i] = 0x20;
    }
  for ( i = 0; i <= 2; i++)
    {
      extn[i] = 0x20;
    }

  //t@C؂o
  for ( i = 0; i <= 7; i++)
    {
      if ( filename[i] == '.' || filename[i] == 0)
	{break;}
      filen[i] = filename[i];
    }

  //gq؂o
  if ( filename[i] != 0 )
    {
      i++;
      for ( i2=0; i2 <= 2; i2++)
	{
	  extn[i2] = filename[i + i2];
	}
    }

  //Ōɑ啶ɑďo͂
  for ( i = 0; i <= 7; i++ )
    {
      if ( filen[i] >= 'a' && filen[i] <= 'z')
	{style[i] = filen[i] - 0x20;}
      else
      	{style[i] = filen[i];}
    }
  for ( i = 8; i <= 10; i++)
    {
      if ( extn[i - 8] >= 'a' && extn[i-8] <= 'z')
	{style[i] = extn[i - 8] - 0x20;}
      else
      	{style[i] = extn[i - 8];}
    }

  //Ō̍ŌɁA0t
  style[11] = 0;

  return 0;
}
