/* ^XNo[vp^XN */

#include "bootpack.h"

//struct SHTCTL *shtctl;
//struct MEMMAN *memman;
//struct BOOTINFO *binfo;

#define taskbar_y   20

//̃^XNAN

struct SHEET *taskbar_make(struct SHTCTL *shtctl,struct MEMMAN *memman,struct BOOTINFO *binfo)
{
//======= ^XNo[{v======================
	struct SHEET *tbar_sht = sheet_alloc(shtctl);
	tbar_sht->titlebar = 1;
	tbar_sht->closedbutton = 1;
	unsigned char *tbarbuf=(unsigned char *) memman_alloc_4k(memman,binfo->scrnx*taskbar_y);
	sheet_setbuf(tbar_sht,tbarbuf,binfo->scrnx,taskbar_y,-1);
	struct TASK *tbar_task = task_alloc();
	int *tbar_fifo = (int *) memman_alloc_4k(memman,128*4);
	tbar_task->cons_stack = memman_alloc_4k(memman,64*1024);
	tbar_task->tss.esp = tbar_task->cons_stack + 64 * 1024 - 12;
	tbar_task->tss.eip = (int) &tbartask;
	tbar_task->tss.es = 1 * 8;
	tbar_task->tss.cs = 2 * 8;
	tbar_task->tss.ss = 1 * 8;
	tbar_task->tss.ds = 1 * 8;
	tbar_task->tss.fs = 1 * 8;
	tbar_task->tss.gs = 1 * 8;
	*((int *) (tbar_task->tss.esp + 4)) = (int) tbar_sht;
	tbar_sht->task = tbar_task;
	task_run(tbar_task, 2, 2); /* level=2, priority=2 */
	fifo32_init(&tbar_task->fifo, 128, tbar_fifo, tbar_task);
	//==============================================

	return tbar_sht;
}

void tbartask(struct SHEET *sheet){
  struct TASK *task = task_now();
  struct TIMER *timer1 = timer_alloc();
  int i;
  int fifodata;
  char s[40];

  //^XNo[Ƃĕ`
  boxfill8(sheet->buf, sheet->bxsize, COL8_FFFFFF, 0, 0, sheet->bxsize-1, taskbar_y);
  boxfill8(sheet->buf, sheet->bxsize, COL8_C6C6C6, 0, taskbar_y - 2, sheet->bxsize-1, taskbar_y - 2);
  boxfill8(sheet->buf, sheet->bxsize, COL8_000000, 0, taskbar_y-1, sheet->bxsize-1, taskbar_y-1);

  //l𗎂Ƃ
	char ptn_tl[8][9] = {
          "*********",
	  "******...",
	  "***......",
	  "**.......",
          "*........",
	  "*........",
	  "*........",
	  "........."
	  };
	ptboxfill8(sheet->buf,sheet->bxsize,0,0,9,8,ptn_tl,8,9,COL8_000000,COL8_FFFFFF);

	char ptn_tr[8][9] = {
          "*********",
	  "...******",
	  "......***",
	  ".......**",
          "........*",
	  "........*",
	  "........*",
	  "........."
	  };
	ptboxfill8(sheet->buf,sheet->bxsize,sheet->bxsize-10,0,sheet->bxsize+1,8,ptn_tr,8,9,COL8_000000,COL8_FFFFFF);

	char ptn_bbl[14][10] = {
          "********..",
          "*****.***.",
          ".****.****",
          ".****.****",
          ".****.****",
          ".********.",
          ".*******..",
          ".****.****",
          ".****.****",
          ".****.****",
          ".****.****",
          ".****.****",
          "*****.***.",
          "********.."

	  };
	ptboxfill8(sheet->buf,sheet->bxsize,10,2,20,16,ptn_bbl,14,10,COL8_000084,COL8_FFFFFF);

	putfonts8_asc_sht(sheet,8*4,2,COL8_000000,COL8_FFFFFF,"THE-BBL",7);






  sheet_refresh(sheet,0,0,sheet->bxsize-1,taskbar_y);





  //CMOS̎擾
    unsigned char t[7];
    cmos_get(t);

    //QbgCMOSf[^Ƃ肠\iɕϊ
    char timecalk[6];

    timecalk[0] = (t[5] >> 4) * 10 + (t[5] & 0x0f);
    timecalk[1] = (t[4] >> 4) * 10 + (t[4] & 0x0f);
    timecalk[2] = (t[3] >> 4) * 10 + (t[3] & 0x0f);
    timecalk[3] = (t[2] >> 4) * 10 + (t[2] & 0x0f);
    timecalk[4] = (t[1] >> 4) * 10 + (t[1] & 0x0f);
    timecalk[5] = (t[0] >> 4) * 10 + (t[0] & 0x0f);
    
  timer_init(timer1,&task->fifo,10);
  timer_settime(timer1,100);

  for(;;){

    io_cli();

    if (fifo32_status(&task->fifo) ==0){
      io_sti();
    }
    else{
      fifodata = fifo32_get(&task->fifo);

      if (fifodata == 10){
	timecalk[5]++;
	if (timecalk[5] >= 60){
	  timecalk[5] = 0;
	  timecalk[4]++;
	}
	if (timecalk[4] >= 60){
	  timecalk[4] = 0;
	  timecalk[3]++;
	}
	if (timecalk[3] >= 24){
	  timecalk[3] = 0;
	  timecalk[2]++;
	}

	timer_settime(timer1,100);
	io_sti();
      }


    sprintf(s, "%02d:%02d:%02d", timecalk[3], timecalk[4], timecalk[5]);
    putfonts8_asc_sht(sheet,sheet->bxsize-74,2,COL8_000000,COL8_FFFFFF,s,8);

    }
  }
}

