#ifndef		__T_COM_TEMPLATE_ALLSCAN_H_INCLUDE_
#define		__T_COM_TEMPLATE_ALLSCAN_H_INCLUDE_

namespace t_image_engine{

// ֐sTemplate 
template <typename _FUNCTOR, typename _DSTT, typename _SRCT, bool _POS_FLAG>
struct t_com_allscan_functor
{inline static void f(int x, int y, const _SRCT* sp, _DSTT* dst){}};

// sTemplate (ʒuȂ)
template <typename _FUNCTOR, typename _DSTT, typename _SRCT>
struct t_com_allscan_functor<_FUNCTOR, _DSTT, _SRCT, false>
{inline static void f(int x, int y, const _SRCT* sp, _DSTT* dst){_FUNCTOR::f(sp, dst);}};

// sTemplate (ʒu񂠂)
template <typename _FUNCTOR, typename _DSTT, typename _SRCT>
struct t_com_allscan_functor<_FUNCTOR, _DSTT, _SRCT, true>
{inline static void f(int x, int y, const _SRCT* sp, _DSTT* dst){_FUNCTOR::f(sp, dst, x, y);}};


// ʏTemplate
template< bool _POS_FLAG, typename _FUNCTOR, typename _DSTT, typename _SRCT>
class t_com_allscan_f
{
protected:
	typename typedef _SRCT::imagetype_ _SINGLE_T;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst)
	{
		for(int y = 0; y < src.height(); y++){
			const _SINGLE_T* sp =  src.pointer_safe() + y * src.width();
			for(int x = 0; x < src.width(); x++, sp++){
				t_com_allscan_functor<_FUNCTOR, _DSTT, _SINGLE_T, _POS_FLAG>::f(x,y,sp,dst);
			}
		}
		return true;
	}
};

// 2l摜̏ꍇ̓Template
template< bool _POS_FLAG, typename _FUNCTOR, typename _DSTT>
class t_com_allscan_f <_POS_FLAG, _FUNCTOR, _DSTT, t_image_binary>
{
protected:
	typename typedef t_image_binary::imagetype_ _SINGLE_T;

public:
	inline static bool func(const t_image_binary& src, _DSTT* dst)
	{
		for(int y = 0; y < src.height(); y++){
			const _SINGLE_T* sp =  src.pointer_safe() + y * src.linesize();
			int cnt = 7;
			unsigned char buff;
			for(int x = 0; x < src.width(); x++){
				buff = bin2uc(*sp, cnt);
				t_com_allscan_functor<_FUNCTOR, _DSTT, _SINGLE_T, _POS_FLAG>::f(x,y,&buff,dst);
				if(--cnt < 0){
					cnt = 7;
					sp++;
					buff = *sp;
				}
			}
		}
		return true;
	}
};

};

#endif