#ifndef		__T_CTRL_RGB_H_INCLUDE_
#define		__T_CTRL_RGB_H_INCLUDE_

#include "../contena/t_image_rgb.h"

namespace t_image_engine{

// 摜ϊ
class t_ctrl_rgb{
protected:
	// `lu
	static void r2g(t_type_rgb* p){unsigned char t = p->r_; p->r_ = p->g_; p->g_ = t;}
	static void r2b(t_type_rgb* p){unsigned char t = p->r_; p->r_ = p->b_; p->b_ = t;}
	static void g2b(t_type_rgb* p){unsigned char t = p->g_; p->g_ = p->r_; p->r_ = t; }

public:
	// w`lւ
	static bool swap_channel(t_image_rgb* src, color_channel_rgb ch1, color_channel_rgb ch2)
	{
		if(!src || (ch1 == ch2))
			return false;
		void (*function)(t_type_rgb* t);
		switch(ch1 + ch2){
			case 1: function = t_ctrl_rgb::r2g; break;
			case 2: function = t_ctrl_rgb::r2b; break;
			case 3: function = t_ctrl_rgb::g2b; break;
		}
		t_type_rgb* sp = src->pointer();
		for(int i = 0; i < src->size(); i++, sp++){
			(*function)(sp);
		}
		return true;
	}

	// w`l폜
	static bool delete_channel(t_image_rgb* src, color_channel_rgb ch)
	{
		if(!src)
			return false;
		unsigned char* sp = src->pointer_() + ((ch==0)?2:(ch==2)?0:1);
		for(int i = 0; i < src->size(); i++)
			*(sp+=3) = 0;
		return true;
	}

	// w`l臒l͈͓̒lhԂ
	static bool fill_channel(	t_image_rgb* src, color_channel_rgb ch, 
								unsigned char th_upper = 128, 
								unsigned char th_lower = 0, 
								unsigned char color = 0)
	{
		if(!src)
			return false;
		unsigned char* sp = src->pointer_() + ((ch==0)?2:(ch==2)?0:1);
		for(int i = 0; i < src->size(); i++, sp+=3){
			if(*sp <= th_upper && *sp >= th_lower){
				*sp = color;
			}
		}
		return true;
	}

	// F]
	static bool reverse_color(t_image_rgb* src)
	{
		if(!src)
			return false;
		unsigned char* sp = src->pointer_();
		for(int i = 0; i < src->size()*3; i++)
			*sp++ = ~(*sp);
		return true;
	}

};

}

#endif