#ifndef		__T_CONV_RGB2GRAY_H_INCLUDE_
#define		__T_CONV_RGB2GRAY_H_INCLUDE_

#include "../contena/t_image_gray.h"
#include "../contena/t_image_rgb.h"
#include "../common/t_com_operator.h"
#include "../common/t_com_allconv.h"
#include "t_conv_rgb2ycrcb.h"

namespace t_image_engine{

// 摜ϊ(RGB->GRAY)
class t_conv_rgb2gray{

public:
	enum conv_algorithm{
		rgb_average,
		rgb_r_channel,
		rgb_g_channel,
		rgb_b_channel,
		rgb_max_channel,
		luminances
	};


	///! RGBGrayɕϊ
	inline static bool rgb2gray(const t_image_rgb& src, t_image_gray* dst, conv_algorithm algo = rgb_average)
	{
		switch(algo){
			case rgb_average:	
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_average>::func(src, dst);
			case rgb_r_channel: 
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_r_channel>::func(src, dst);
			case rgb_g_channel: 
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_g_channel>::func(src, dst);
			case rgb_b_channel: 
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_b_channel>::func(src, dst);
			case rgb_max_channel: 
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_max_channel>::func(src, dst);
			case luminances:
				return t_com_allconv<t_image_rgb, t_image_gray, t_conv_f_rgb2uc_luminances>::func(src, dst);
		}
		return false;
	}

	///! RGBGrayɕϊ(o͉摜RGB̂܂)
	inline static bool rgb2gray_n(const t_image_rgb& src, t_image_rgb* dst, conv_algorithm algo = rgb_average)
	{
		switch(algo){
			case rgb_average:	
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_average>::func(src, dst);
			case rgb_r_channel: 
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_r_channel>::func(src, dst);
			case rgb_g_channel: 
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_g_channel>::func(src, dst);
			case rgb_b_channel: 
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_b_channel>::func(src, dst);
			case rgb_max_channel: 
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_max_channel>::func(src, dst);
			case luminances:
				return t_com_allconv<t_image_rgb, t_image_rgb, t_conv_f_rgb2uc_n_luminances>::func(src, dst);
		}
	}

	///! GrayRGBɕϊ
	inline static bool gray2rgb(const t_image_gray& src, t_image_rgb* dst)
	{
		return t_com_allconv<t_image_gray, t_image_rgb, t_conv_f_uc2rgb>::func(src, dst);
	}

protected:
	// rgb->gray(gray 8bit)
	//! RGBloCgɒu(r,g,bl̕)
	struct t_conv_f_rgb2uc_average{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = (unsigned char)(((int)src->r_ + (int)src->g_ + (int)src->b_) / 3);}
	};
	//! RGBloCgɒu(R`l)
	struct t_conv_f_rgb2uc_r_channel{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = src->r_;}
	};
	//! RGBloCgɒu(G`l)
	struct t_conv_f_rgb2uc_g_channel{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = src->g_;}
	};
	//! RGBloCgɒu(B`l)
	struct t_conv_f_rgb2uc_b_channel{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = src->b_;}
	};
	//! RGBloCgɒu(R,G,Bōł傫`l)
	struct t_conv_f_rgb2uc_max_channel{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = src->max();}
	};
	//! RGBloCgɒu(Pxl)
	struct t_conv_f_rgb2uc_luminances{
		inline static void f(const t_type_rgb* src, unsigned char* dst)
		{*dst = i2uc(t_conv_c_rgb2ycrcb<unsigned char, int>::calc_y(src->r_, src->g_, src->b_));}
	};

	// rgb->gray(rgb 24bit)
	//! RGBloCgɒu(r,g,bl̕)
	struct t_conv_f_rgb2uc_n_average{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{t_conv_f_rgb2uc_average::f(src, &dst->r_); dst->g_ = dst->b_ = dst->r_;}
	};
	//! RGBloCgɒu(R`l)
	struct t_conv_f_rgb2uc_n_r_channel{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{memset(dst, src->r_, 3);}
	};
	//! RGBloCgɒu(G`l)
	struct t_conv_f_rgb2uc_n_g_channel{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{memset(dst, src->g_, 3);}
	};
	//! RGBloCgɒu(B`l)
	struct t_conv_f_rgb2uc_n_b_channel{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{memset(dst, src->b_, 3);}
	};
	//! RGBloCgɒu(R,G,Bōł傫`l)
	struct t_conv_f_rgb2uc_n_max_channel{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{memset(dst, src->max(), 3);}
	};

	//! RGBloCgɒu(Pxl)
	struct t_conv_f_rgb2uc_n_luminances{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst)
		{memset(dst, i2uc(t_conv_c_rgb2ycrcb<unsigned char, int>::calc_y(src->r_, src->g_, src->b_)), 3);}
	};

	// gray 8bit -> rgb
	//! oCglRGBlɒu
	struct t_conv_f_uc2rgb{
		inline static void f(const unsigned char* src, t_type_rgb* dst)
		{dst->r_ = dst->g_ = dst->b_ = *src; }
	};
	
};

}

#endif