#ifndef		__T_CONV_RGB2HSL_H_INCLUDE_
#define		__T_CONV_RGB2HSL_H_INCLUDE_

#include "../contena/t_image_rgb.h"
#include "../contena/t_image_hsl.h"
#include "../common/t_com_operator.h"
#include "../common/t_com_allconv.h"

namespace t_image_engine{

// 摜ϊ(RGB->HSL)
class t_conv_rgb2hsl{
public:
	///! RGBHSLɕϊ
	inline static bool rgb2hsl(const t_image_rgb& src, t_image_hsl* dst)
	{
		return t_com_allconv<t_image_rgb, t_image_hsl, t_conv_f_rgb2hsl>::func(src, dst); 
	}

	///! HSLRGBɕϊ
	inline static bool hsl2rgb(const t_image_hsl& src, t_image_rgb* dst)
	{
		return t_com_allconv<t_image_hsl, t_image_rgb, t_conv_f_hsl2rgb>::func(src, dst);
	}

protected:
	

protected:
	//! rgb -> hsl
	struct t_conv_f_rgb2hsl{
		// RGB -> HSL
		inline static void f(const t_type_rgb* src, t_type_hsl* dst)
		{
			const double vmax = std::numeric_limits<t_type_rgb::_SINGLE_T>::max();
			const t_type_rgb::_SINGLE_T max = src->max();
			const t_type_rgb::_SINGLE_T min = src->min();

			// L[0...256]
			const t_type_rgb::_SINGLE_T lum = max/2+min/2;
			dst->l_ = lum;

			if(max == min){
				dst->s_ = dst->h_ = 0;
			}else{
				// S[0...256]
				const double dmax = static_cast<double>(max)/vmax;
				const double dmin = static_cast<double>(min)/vmax;
				const double maxminsub = dmax - dmin;
				dst->s_ = d2uc(((lum < vmax / 2) ?
					maxminsub / (dmax + dmin):
					maxminsub / (2.0 - maxminsub)) * vmax);

				// H[0...256]
				const double dr = (dmax - static_cast<double>(src->r_)/vmax) / maxminsub;
				const double dg = (dmax - static_cast<double>(src->g_)/vmax) / maxminsub;
				const double db = (dmax - static_cast<double>(src->b_)/vmax) / maxminsub;
				const double dh = ((max == src->r_) ? db - dg :
					((max == src->g_) ? 2.0 + dr - db: 4.0 + dg - dr)) * 60.0;
				dst->h_ = d2uc((((dh < 0) ? dh+360.0 : dh) / 360.0) * vmax);
			}
		}
	};

	//! hsl -> rgb
	struct t_conv_f_hsl2rgb{
		// h[0...360], min[0...1], max[0...1]
		inline static double get_color(double h, double max, double min)
		{
			if(h < 60.0){
				return min + (max - min) * h / 60.0;
			}else if(h < 180.0){
				return max;
			}else if(h < 240.0){
				return min + (max - min) * (240.0 - h) / 60.0;
			}else{
				return min;
			}
		}

		// HSL -> RGB
		inline static void f(const t_type_hsl* src, t_type_rgb* dst)
		{
			const double vmax = std::numeric_limits<t_type_hsl::_SINGLE_T>::max();
			if(src->s_ == 0){
				dst->r_ = dst->g_ = dst->b_ = src->l_;
			}else{
				const double dl = static_cast<double>(src->l_)/vmax;
				const double ds = static_cast<double>(src->s_)/vmax;
				const double max = (src->l_ < vmax /2) ?
					dl * (1.0 + ds) :
					dl * (1.0 - ds) + ds;
				const double min = 2.0 * dl - max;
				const double dgh = (static_cast<double>(src->h_)/vmax) * 360.0;
				const double drh = (dgh + 120.0 > 360.0) ? dgh - 240.0 : dgh + 120.0;
				const double dbh = (dgh - 120.0 < 0) ? dgh + 240.0 : dgh - 120.0;
				dst->r_  = d2uc(get_color(drh, max, min) * vmax);
				dst->g_  = d2uc(get_color(dgh, max, min) * vmax);
				dst->b_  = d2uc(get_color(dbh, max, min) * vmax);
			}
		}
	};
};

}

#endif