#ifndef		__T_FILT_MEDIAN_H_INCLUDE_
#define		__T_FILT_MEDIAN_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_median.h"

namespace t_image_engine{

//! fBAtB^p[^
class t_filt_param_median : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	int					filter_size_;	//<! tB^TCY
	channel_type		sort_type_;		//<! \[g^Cv


public:
	t_filt_param_median()
	{
		type_ = 4;
		src_ = dst_ = NULL;
		runner_ = NULL;
	}
	~t_filt_param_median()
	{
	}

	bool set_param(
		t_image_interface* src,
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL,
		int filtersize = 3,
		channel_type sorttype = ch_default
	)
	{
		src_ = src;
		dst_ = dst;
		filter_size_ = filtersize;
		sort_type_ = sorttype;
		runner_ = runner;

		return true;
	}
};

//! tB^
class t_filt_median : public t_filt_base <t_filt_param_median>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		
		if(!param || param->type() != 4){
			return false;
		}
		t_filt_param_median* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_)){
			return false;
		}

		switch(p->src_->tag()){
			case rgb_24bit:	 return t_filt_median_main<t_image_rgb>::func(p);
			case rgba_32bit: return t_filt_median_main<t_image_rgba>::func(p);
			case gray_8bit:	 return t_filt_median_main<t_image_gray>::func(p);
			
		}
		return false;
	}
};

}

#endif