#ifndef		__T_FILT_TEMPLATE_MULTI_FUNC_H_INCLUDE_
#define		__T_FILT_TEMPLATE_MULTI_FUNC_H_INCLUDE_

#include "../data/t_line.h"
#include "../common/t_com_looper.h"
#include "../common/t_com_linebuffer.h"
#include "t_filt_template_multifunctor.h"

namespace t_image_engine{

//! ėptB^(C) tB^ėpev[g
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc_line
{
public:
	static inline bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize, 
		const std::vector<t_line>* linedata
		)
	{
		// tB^l
		const int filterhalf = (filtersize & ~1) / 2;

		// 摜擪AhX
		_PROCT* const srcp = reinterpret_cast<_PROCT*>(src->pointer_());
		_PROCT* const dstp = reinterpret_cast<_PROCT*>(dst?dst->pointer_():src->pointer_());

		// CAhX
		_PROCT** linefp = new _PROCT* [filtersize];
		_PROCT** linenp = new _PROCT* [filtersize];

		// IuWFNg
		t_filt_multifunctor<_PROCT, _PARAM> *functor = new t_filt_multifunctor<_PROCT, _PARAM>(p);
		functor->func_filter_init();

		const int limitsy = 0;
		const int limitey = src->height();
		const int limitsx = 0;
		const int limitex = src->width();

		// CƂ̏
		for(std::vector<t_line>::const_iterator it = linedata->begin(); it != linedata->end(); it++){
			// o͐AhX
			_PROCT* pt = dstp + it->y_ * src->width() + it->sx_;

			// CƂ̏
			functor->func_filter_initline();

			const int memorysx = it->sx_ - filterhalf < limitsx ? limitsx : it->sx_ - filterhalf;
			const int memoryex = it->ex_ + filterhalf > limitex ? limitex : it->ex_ + filterhalf;
			const int memorywidth = memoryex-memorysx+1;

			// Cobt@̐/Rs[
			t_com_linebuffer<_PROCT> linebuffer(filtersize, memorywidth); 
			for(int i = 0; i < filtersize; i++){
				int ypos = (it->y_ - filterhalf + i);
				if(ypos < limitsy){
					ypos = limitsy;
				}
				if(ypos > limitey){
					ypos = limitey;
				}
				memcpy(linebuffer.pointer(i), 
					srcp + src->width() * ypos + memorysx, memorywidth * sizeof(_PROCT));
				linefp[i] = linebuffer.pointer(i);
				linenp[i] = linefp[i] + filtersize;
				_PROCT* addr = linefp[i];
				for(int j = 0; j < filtersize; j++, addr++){
					functor->func_filter_make(addr);
				}
			}

			// tB^
			for(int x = it->sx_; x < it->ex_; x++){
				functor->func_filter_run(pt++);
				// ㏈ CƂ̑OAhXl & AhXl
				if(x > limitsx && x < limitex){
					for(int i = 0;  i < filtersize; i++){
						functor->func_linebuff_next(linefp[i]++, linenp[i]++);
					}
				}
			}
		}

		return true;
	}
};

//! ėptB^(C) tB^ėpev[g
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc_line_h
{
public:
	static inline bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize, 
		const std::vector<t_line>* linedata
		)
	{
		// tB^l
		const int filterhalf = (filtersize & ~1) / 2;

		/*
		// 摜擪AhX
		_PROCT* const srcp = reinterpret_cast<_PROCT*>(src->pointer_());
		_PROCT* const dstp = reinterpret_cast<_PROCT*>(dst?dst->pointer_():src->pointer_());

		// obt@ & obt@摜Rs[
		_PROCT* linebuff = new _PROCT [w]; 
		memcpy(linebuff, srcp + src->width() * sy + sx, src->memorysize(w));

		// IuWFNg
		t_filt_multifunctor<_PROCT, _PARAM> *functor = new t_filt_multifunctor<_PROCT, _PARAM>(p);
		functor->func_filter_init();

		// tB^
		for(int y = sy; y < sy + h; y++){
			// obt@AhX
			_PROCT* linefp = linebuff;
			_PROCT* linenp = linebuff + filtersize;

			// o͐AhX
			_PROCT* pt = dstp + y * src->width() + sx + filterhalf;

			// CƂ̏
			functor->func_filter_initline();
			_PROCT* addr = linebuff;
			for(int i = 0; i < filtersize; i++){
				functor->func_filter_make(addr++);
			}

			// tB^
			for(int x = sx; x < sx + w - filtersize; x++){
				functor->func_filter_run(pt++);
				// ㏈ OAhXl & AhXl
				functor->func_linebuff_next(linefp++, linenp++);
			}
			// Cobt@XV
			memcpy(linebuff,  srcp + src->width() * ( y + 1) + sx, src->memorysize(w));
		}

		// IuWFNg㏈
		functor->func_filter_finalize();
		delete  functor;
		delete [] linebuff;
		*/

		return true;
	}
};

}

#endif
