#ifndef		__T_FILT_TEMPLATE_MULTIFUNC_RECT_H_INCLUDE_
#define		__T_FILT_TEMPLATE_MULTIFUNC_RECT_H_INCLUDE_

#include "../data/t_rect.h"
#include "../common/t_com_looper.h"
#include "../common/t_com_linebuffer.h"
#include "t_filt_template_multifunctor.h"

namespace t_image_engine{


//! ėptB^ tB^ėpev[g
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc_rect
{
public:
	static inline bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize, 
		const t_rect* rect
		)
	{
		// tB^l
		const int filterhalf = (filtersize & ~1) / 2;

		// JnʒuEIʒu
		const int sx = rect->left_;
		const int sy = rect->top_;
		const int ex = rect->right_;
		const int ey = rect->bottom_;
		const int limitsx = rect->left_   + filterhalf;
		const int limitex = rect->right_  - filterhalf - 1;
		const int limitsy = rect->top_    + filterhalf;
		const int limitey = rect->bottom_ - filterhalf - 1;
		const int w = rect->width();
		const int h = rect->height();

		// [vJE^
		t_com_looper looper(filtersize);

		// 摜擪AhX
		_PROCT* const srcp = reinterpret_cast<_PROCT*>(src->pointer_());
		_PROCT* const dstp = reinterpret_cast<_PROCT*>(dst?dst->pointer_():src->pointer_());

		// obt@ & obt@摜Rs[
		t_com_linebuffer<_PROCT> linebuffer(filtersize, w); 
		for(int i = 0; i < filtersize; i++){
			memcpy(linebuffer.pointer(i), srcp + src->width() * (i + sy) + sx, src->memorysize(w));
		}

		// CAhX
		_PROCT** linefp = new _PROCT* [filtersize];
		_PROCT** linenp = new _PROCT* [filtersize];

		// IuWFNg
		t_filt_multifunctor<_PROCT, _PARAM> *functor = new t_filt_multifunctor<_PROCT, _PARAM>(p);
		functor->func_filter_init();

		for(int y = sy; y < sy + h; y++){
			// o͐AhX
			_PROCT* pt = dstp + y * src->width() + sx;

			// CƂ̏
			functor->func_filter_initline();

			for(int i = 0; i < filtersize; i++){
				linefp[i] = linebuffer.pointer(looper.pos(i));
				linenp[i] = linefp[i] + filtersize;
				_PROCT* addr = linefp[i];
				for(int j = 0; j < filtersize; j++, addr++){
					functor->func_filter_make(addr);
				}
			}

			// tB^
			for(int x = sx; x < sx + w; x++){
				functor->func_filter_run(pt++);
				// ㏈ CƂ̑OAhXl & AhXl
				if(x > limitsx && x < limitex){
					for(int i = 0;  i < filtersize; i++){
						functor->func_linebuff_next(linefp[i]++, linenp[i]++);
					}
				}
			}

			// Cobt@XV
			if(y > limitsy && y < limitey){
				memcpy(linebuffer.pointer(looper.now()), 
					srcp + src->width() * ( y + filterhalf + 1) + sx, src->memorysize(w));
				// obt@JEg
				looper.next();
			}
		}

		// IuWFNg㏈
		functor->func_filter_finalize();
		delete  functor;
		delete [] linefp;
		delete [] linenp;
		return true;
	}
};

//! ėptB^ tB^ėpev[g
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc_rect_h
{
public:
	static inline bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize, 
		const t_rect* rect
		)
	{
		// tB^l
		const int filterhalf = (filtersize & ~1) / 2;

		// JnʒuEIʒu
		const int sx = rect->left_;
		const int sy = rect->top_;
		const int ex = rect->right_;
		const int ey = rect->bottom_;
		const int limitsx = rect->left_   + filterhalf;
		const int limitex = rect->right_  - filterhalf - 1;
		const int limitsy = rect->top_    + filterhalf;
		const int limitey = rect->bottom_ - filterhalf - 1;
		const int w = rect->width();
		const int h = rect->height();

		// 摜擪AhX
		_PROCT* const srcp = reinterpret_cast<_PROCT*>(src->pointer_());
		_PROCT* const dstp = reinterpret_cast<_PROCT*>(dst?dst->pointer_():src->pointer_());

		// obt@ & obt@摜Rs[
		_PROCT* linebuff = new _PROCT [w]; 
		memcpy(linebuff, srcp + src->width() * sy + sx, src->memorysize(w));

		// IuWFNg
		t_filt_multifunctor<_PROCT, _PARAM> *functor = new t_filt_multifunctor<_PROCT, _PARAM>(p);
		functor->func_filter_init();

		// tB^
		for(int y = sy; y < sy + h; y++){
			// obt@AhX
			_PROCT* linefp = linebuff;
			_PROCT* linenp = linebuff + filtersize;

			// o͐AhX
			_PROCT* pt = dstp + y * src->width() + sx + filterhalf;

			// CƂ̏
			functor->func_filter_initline();
			_PROCT* addr = linebuff;
			for(int i = 0; i < filtersize; i++){
				functor->func_filter_make(addr++);
			}

			// tB^
			for(int x = sx; x < sx + w - filtersize; x++){
				functor->func_filter_run(pt++);
				// ㏈ OAhXl & AhXl
				functor->func_linebuff_next(linefp++, linenp++);
			}
			// Cobt@XV
			memcpy(linebuff,  srcp + src->width() * ( y + 1) + sx, src->memorysize(w));
		}

		// IuWFNg㏈
		functor->func_filter_finalize();
		delete  functor;
		delete [] linebuff;
		return true;
	}
};


}

#endif
