#ifndef		__T_FILT_TEMPLATE_DIFF_H_INCLUDE_
#define		__T_FILT_TEMPLATE_DIFF_H_INCLUDE_

#include "../common/t_com_operator.h"

namespace t_image_engine{

// tB^ev[g
template< typename _OUT, typename _IN, int f>
struct filter_func_sub{
	static inline void func( _OUT *out, const _IN* in ){_OUT t; t=*in; *out+=t*f;}
};
template< typename _OUT, typename _IN>
struct filter_func_sub< _OUT, _IN, 0>{
	static inline void func( _OUT *out, const _IN* in ){}
};
template< typename _OUT, typename _IN>
struct filter_func_sub< _OUT, _IN, 1>{
	static inline void func( _OUT *out, const _IN* in ){*out+=*in;}
};
template< typename _OUT, typename _IN>
struct filter_func_sub< _OUT, _IN, -1>{
	static inline void func( _OUT *out, const _IN* in ){*out-=*in;}
};

// tB^ev[g
template< typename _OUT, typename _IN, int f0, int f1, int f2>
struct filter_func_line{
	static inline void func(_OUT* dst, const _IN* src)
	{
		filter_func_sub<_OUT, _IN, f0>::func(dst,src++);
		filter_func_sub<_OUT, _IN, f1>::func(dst,src++);
		filter_func_sub<_OUT, _IN, f2>::func(dst,src);
	}
};

// tB^ev[g
template< class _PROCT, int f00, int f01, int f02, int f10, int f11, int f12, int f20, int f21, int f22 >
class filter {
protected:
	typename typedef t_type_upper_signed_template<_PROCT>::_T _BUFFT;
public:
	static inline void func(_PROCT* dst, const _PROCT* l0, const _PROCT* l1, const _PROCT* l2)
	{
		_BUFFT ret = 0;
		filter_func_line<_BUFFT, _PROCT, f00,f01,f02>::func(&ret, l0);
		filter_func_line<_BUFFT, _PROCT, f10,f11,f12>::func(&ret, l1);
		filter_func_line<_BUFFT, _PROCT, f20,f21,f22>::func(&ret, l2);
		t_type_upper_signed_template<_PROCT>::saturate(dst, &ret);
	}
};

// tB^sNX
class t_filt_param_diff;
template <	class _PROCT, int f00, int f01, int f02, int f10, int f11, int f12, int f20, int f21, int f22> 
class t_filt_diff_func
{
public:
	static inline bool func(int filtersize, t_filt_param_diff* p)
	{
		// p[^
//		const int sx = p->sx_;
//		const int sy = p->sy_;
//		const int w  = p->width_;
//		const int h  = p->height_;

		// Ŝ
		const int sx = 0; 
		const int sy = 0;
		const int w =  p->src_->width();
		const int h =  p->src_->height();

		// [vJE^
		const int filterhalf = (filtersize & ~1) / 2;
		const int bytewidth = w * sizeof(_PROCT);
		t_com_looper looper(filtersize);

		// 摜擪AhX
		_PROCT* const srcp = reinterpret_cast<_PROCT*>(p->src_->pointer_());
		_PROCT* const dstp = reinterpret_cast<_PROCT*>(p->dst_?p->dst_->pointer_():p->src_->pointer_());

		// obt@ & obt@摜Rs[
		t_com_linebuffer<_PROCT> linebuffer(filtersize, w); 
		for(int i = 0; i < filtersize; i++)
			memcpy(linebuffer.pointer(i), srcp + p->src_->width() * (i + sy) + sx, bytewidth);

		// Cobt@AhXz
		_PROCT** linep = new _PROCT* [filtersize];

		// tB^
		for(int y = sy + filterhalf; y < sy + h - filterhalf; y++){
			// o͐AhX
			_PROCT* pt = dstp + y * p->src_->width() + sx + filterhalf;
			// CAhX擾
			for(int i = 0; i < filtersize; i++)
				linep[i] = linebuffer.pointer(looper.pos(i));
			for(int x = sx + filterhalf; x < sx + w - filterhalf; x++)				
				filter<_PROCT,f00,f01,f02,f10,f11,f12,f20,f21,f22>::func(pt++, linep[0]++, linep[1]++, linep[2]++);
			// Cobt@XV
			if(y < sy + h - filterhalf - 1){
				memcpy(linebuffer.pointer(looper.now()), srcp + p->src_->width() * ( y + filterhalf + 1) + sx, bytewidth);
				// obt@JEg
				looper.next();
			}
		}
		delete [] linep;
		return true;
	}
};

//! tB^C
template <class _TYPE> 
class t_filt_diff_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;

public:
	static inline bool func(t_filt_param_diff* p)
	{
		switch(p->filter_type_){
			case ftype_sobel:
				switch(p->filter_dir_){
					case dir_left:			t_filt_diff_func<_PROCT,-1, 0, 1,-2, 0, 2,-1, 0, 1>::func(3,p); break;
					case dir_top:			t_filt_diff_func<_PROCT,-1,-2,-1, 0, 0, 0, 1, 2, 1>::func(3,p); break;
					case dir_right:			t_filt_diff_func<_PROCT, 1, 0,-1, 2, 0,-2, 1, 0,-1>::func(3,p); break;
					case dir_bottom:		t_filt_diff_func<_PROCT, 1, 2, 1, 0, 0, 0,-1,-2,-1>::func(3,p); break;
					case dir_topleft:		t_filt_diff_func<_PROCT,-2,-1, 0,-1, 0, 1, 0, 1, 2>::func(3,p); break;
					case dir_bottomleft:	t_filt_diff_func<_PROCT, 0, 1, 2,-1, 0, 1,-2,-1, 0>::func(3,p); break;
					case dir_topright:		t_filt_diff_func<_PROCT, 0,-1,-2, 1, 0,-1, 2, 1, 0>::func(3,p); break;
					case dir_bottomright:	t_filt_diff_func<_PROCT, 2, 1, 0, 1, 0,-1, 0,-1,-2>::func(3,p); break;
				}
				break;
			case ftype_prewitt:
				switch(p->filter_dir_){
					case dir_left:			t_filt_diff_func<_PROCT,-1, 0, 1,-1, 0, 1,-1, 0, 1>::func(3,p); break;
					case dir_top:			t_filt_diff_func<_PROCT,-1,-1,-1, 0, 0, 0, 1, 1, 1>::func(3,p); break;
					case dir_right:			t_filt_diff_func<_PROCT, 1, 0,-1, 1, 0,-1, 1, 0,-1>::func(3,p); break;
					case dir_bottom:		t_filt_diff_func<_PROCT, 1, 1, 1, 0, 0, 0,-1,-1,-1>::func(3,p); break;
					case dir_topleft:		t_filt_diff_func<_PROCT,-1,-1, 0,-1, 0, 1, 0, 1, 1>::func(3,p); break;
					case dir_bottomleft:	t_filt_diff_func<_PROCT, 0, 1, 1,-1, 0, 1,-1,-1, 0>::func(3,p); break;
					case dir_topright:		t_filt_diff_func<_PROCT, 0,-1,-1, 1, 0,-1, 1, 1, 0>::func(3,p); break;
					case dir_bottomright:	t_filt_diff_func<_PROCT, 1, 1, 0, 1, 0,-1, 0,-1,-1>::func(3,p); break;
				}
				break;
			case ftype_laplacian:
				switch(p->filter_dir_){
					case dir_dir4:			t_filt_diff_func<_PROCT, 0,-1, 0,-1, 4,-1, 0,-1, 0>::func(3,p); break;
					case dir_dir8:			t_filt_diff_func<_PROCT,-1,-1,-1,-1, 8,-1,-1,-1,-1>::func(3,p); break;
				}
				break;
		}
		return true;
	}
};

}

#endif
