#ifndef		__T_FILT_TEMPLATE_PIXELATE_H_INCLUDE_
#define		__T_FILT_TEMPLATE_PIXELATE_H_INCLUDE_

#include "multifunc/t_filt_template_multifunc.h"

namespace t_image_engine{


class t_filt_param_pixelate;

// sNZ[gϊNXev[g
template <class _TYPE> 
class t_filt_pixelate_func
{
protected:
	int filter_size_;	//<! tB^TCY
	int image_width_;
public:
	t_filt_pixelate_func(int filter_size, int image_width)
	{
		filter_size_ = filter_size;
		image_width_ = image_width;
	}

	~t_filt_pixelate_func()
	{
	}

	// ᑬ
	void pixelate(int x, int y,  const _TYPE *spt, _TYPE *dpt)
	{
		const int fs = filter_size_;
		int yp = y % fs;
		int xp = x % fs;
		*dpt = *(spt - image_width_ * yp - xp);
	}

};

// sNZ[gNXC
template <class _TYPE> 
class t_filt_pixelate_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;

	// Functor
	class t_filt_pixelate_functor
	{
	public:
		inline static void f(int x, int y, const _PROCT *spt, _PROCT *dpt, t_filt_pixelate_func<_PROCT>* pixelate)
		{
			pixelate->pixelate(x, y, spt, dpt);
		}
	};
public:
	static inline bool func(const t_filt_param_pixelate* p)
	{
		// sNZ[g
		t_filt_pixelate_func<_PROCT> pixelate(p->filter_size_, p->src_->width());

		// tB^s
		return t_filt_template_multifunc_simple<_TYPE, t_filt_param_pixelate, 
			t_filt_pixelate_functor,  t_filt_pixelate_func<_PROCT>*, true>::func(p, &pixelate);
	}
};

}

#endif