#ifndef		__T_FILT_TEMPLATE_SMOOTH_H_INCLUDE_
#define		__T_FILT_TEMPLATE_SMOOTH_H_INCLUDE_

#include "../common/t_com_looper.h"
#include "../common/t_com_linebuffer.h"
#include "multifunc/t_filt_template_multifunc.h"

namespace t_image_engine{

// p[^NX`	
class t_filt_param_smooth;

//! SmoothtB^C (t_filt_multifunctorev[g)
template < typename _PROCT>
class t_filt_multifunctor <_PROCT, t_filt_param_smooth >
{
protected:
	int	sub_;
	typename t_type_upper_unsigned_template<_PROCT>::_T buffer_;

public:
	t_filt_multifunctor(const t_filt_param_smooth* p)
	{
		if(p->filter_dir_ == 0){
			sub_ = p->filter_size_ * p->filter_size_;
		}else{
			sub_ = p->filter_size_ ;
		}
	}

	inline void func_filter_init()
	{}
	inline void func_filter_initline()
	{
		t_type_upper_unsigned_template<_PROCT>::_T t(0); buffer_ = t;
	}
	inline void func_filter_make(const _PROCT* addr)
	{
		buffer_ += *addr;
	}
	inline void func_filter_run(_PROCT* dst)
	{
		*dst = buffer_ / sub_;
	}
	inline void func_linebuff_next(const _PROCT* faddr, const _PROCT* naddr)
	{
		buffer_ -= *faddr; 
		buffer_ += *naddr;
	}
	inline void func_filter_finalize()
	{}
};

//! SmoothtB^Ăяo
template < typename _TYPE > 
class t_filt_smooth_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;

public:
	// ėp֐gp
	static inline bool func(const t_filt_param_smooth* p)
	{
		// tB^s
		switch(p->filter_dir_){
		case 0:
		return t_filt_template_multifunc<_PROCT , t_filt_param_smooth>::
			func(p->src_, p->dst_, p, p->filter_size_);
		case 1:
		return t_filt_template_multifunc_h<_PROCT , t_filt_param_smooth>::
			func(p->src_, p->dst_, p, p->filter_size_);
		}
		return false;
	}
};

}

#endif
