#ifndef		__T_PHY_CIRCLE_H_INCLUDE_
#define		__T_PHY_CIRCLE_H_INCLUDE_

#include "../data/t_point.h"
#include "../type/t_type_define.h"
#include <math.h>
#include <utility>

namespace t_image_engine{

// ~(2)
template <typename _TYPE = float>
class t_phy_circle{

public:
	typedef _TYPE _SINGLE_T;
	typedef t_point_template<_TYPE> _POINT_T;

	t_phy_circle(const _POINT_T& point, _TYPE radius)
	{
		reset(point, radius);
	}
	
	virtual ~t_phy_circle(){}

	inline void reset(const _POINT_T& point, _TYPE radius)
	{
		point_ = point;
		radius_ = radius;
	}

	// 0xƂ
	inline _POINT_T getpos(_TYPE angle)
	{
		angle *= radf_f;
		return _POINT_T(
			point_.x_ + cosf(angle) * radius_, 
			point_.y_ + sinf(angle) * radius_);
	}

protected:
	_POINT_T point_;
	_TYPE radius_;
};

}

#endif