#ifndef		__T_TTABLE_LENS_H_INCLUDE_
#define		__T_TTABLE_LENS_H_INCLUDE_

#include "../data/t_table.h"
#include "../type/t_type_define.h"


namespace t_image_engine{

// Ye[u̍쐬
class t_ttable_lens{
public:
	inline static bool create(t_table* table, int radius, float foucsdepth, float targetdepth)
	{
		// e[u̐
		const int diameter =  radius * 2;
		table->create_table(diameter, diameter);
		
		// e[uf[^̍쐬
		for(int y = 0; y < diameter; y++){
			t_table::_T_TABLE_LINE *line = table->get_line_pt(y);
			int xpos = static_cast<int>(radius - sqrt(
				pow(static_cast<double>(radius),2) - 
				pow(static_cast<double>(radius - y),2)));
			for(int x = 0; x < diameter; x++){
				if(x <= xpos || x >= diameter-xpos){
					line->at(x) = t_pointf((float)x, (float)y);
				}else{
					calcpos(&line->at(x), x, y, radius, radius, foucsdepth, targetdepth);
				}
			}
		}
		return true;
	}

	inline static void calcpos(t_pointf* pos, int x, int y, 
		int centerx, int centery, float focusdepth, float targetlength)
	{
		// ݂̓_璆S܂ł̊px
		float xlen = static_cast<float>(x - centerx);
		float ylen = static_cast<float>(y - centery);
		float rad_a = atan2f(xlen, ylen); 
		rad_a += pi_f/2; // 90x]

		// ݂̓_œ_܂ł̊px
		float xylen = xlen * xlen + ylen * ylen;
		float rad_b = atan2f(xylen, focusdepth*focusdepth);
		float rad_c =  pi_f/2 - rad_b;

		// ړ_܂ł̋Zo
		float len = sqrt(xylen) - targetlength / tan(rad_c);
		pos->x_ = centerx - len * cos(rad_a);
		pos->y_ = centery + len * sin(rad_a);

		return;

	}
};

};

#endif