#ifndef		__T_TYPE_DEFINE_H_INCLUDE_
#define		__T_TYPE_DEFINE_H_INCLUDE_

namespace t_image_engine{

/*-----------------------------------------------------------------------------
񋓎q 摜
-----------------------------------------------------------------------------*/
///! 摜
typedef enum{
	rgb_24bit,		// RGB
	rgb_8bit,		// RGB index color
	rgba_32bit,		// RGBA
	gray_8bit,		// GRAY
	cmyk_32bit,		// CMYK
	ycrcb_24bit,	// YCrCb
	hsl_24bit,		// HSL
	binary_1bit		// Binary
}image_tag;


/*-----------------------------------------------------------------------------
񋓎q 摜`l
-----------------------------------------------------------------------------*/
///! RGB`l
typedef enum {
	channel_rgb_r,
	channel_rgb_g,
	channel_rgb_b,
}color_channel_rgb;

///! RGBA`l
typedef enum {
	channel_rgba_r,
	channel_rgba_g,
	channel_rgba_b,
	channel_rgba_a,
}color_channel_rgba;

///! CMYK`l
typedef enum{
	channel_cmyk_c,
	channel_cmyk_m,
	channel_cmyk_y,
	channel_cmyk_k,
}color_channel_cmyk;

///! YCrCb`l
typedef enum {
	channel_ycrcb_y,
	channel_ycrcb_cr,
	channel_ycrcb_cb,
}color_channel_ycrcb;

///! HSL`l
typedef enum {
	channel_hsl_h,
	channel_hsl_s,
	channel_hsl_l,
}color_channel_hsl;

///! Binary
typedef enum {
	channel_bin_w,	// 1
	channel_bin_b	// 0
}binary_channel;


///! 摜ԃASY
typedef enum{
	nearest_neighbor,	// ŋߖT@
	bi_linear,			// oCjA
	bi_cubic,			// oCL[rbN
	pixel_averaging,	// ωf@
	area_averaging,		// ʐϕϖ@
}stretch_type;

///! `lI
typedef enum{
	ch_default,			// ftHg

	ch_rgb_r,			// RGB/RGBA r`l
	ch_rgb_g,			// RGB/RGBA g`l
	ch_rgb_b,			// RGB/RGBA b`l
	ch_rgb_a,			// RGBA a`l

	ch_ycrcb_y,			// YCrCb y`l
	ch_ycrcb_cr,		// YCrCb cr`l
	ch_ycrcb_cb,		// YCrCb cb`l

	ch_hsl_h,			// HSL h`l
	ch_hsl_s,			// HSL s`l
	ch_hsl_l,			// HSL l`l

	ch_cmyk_c,			// CMYK c`l\[g
	ch_cmyk_m,			// CMYK m`l\[g
	ch_cmyk_y,			// CMYK y`l\[g
	ch_cmyk_k,			// CMYK k`l\[g

	ch_bin_white,
	ch_bin_black,

	ch_avr,				// RGB/YCrCb `lϒl\[g
	ch_lum,				// RGB/YCrCb Pxl\[g

}channel_type;


///! ʒu`
typedef enum{
	pos_topleft,
	pos_top,
	pos_topright,

	pos_bottomleft,
	pos_bottom,
	pos_bottomright,

	pos_right,
	pos_left,

	pos_center
}base_position;

/*-----------------------------------------------------------------------------
萔l
-----------------------------------------------------------------------------*/
// ~
static const double	pi		= 3.1415926535897932;
static const float	pi_f	= static_cast<float>(pi);

static const double radf	= pi / 180.0;
static const float	radf_f	= pi_f / 180.0f;

static const double degf	= 180.0 / pi;
static const float	degf_f	= 180.0f / pi_f;

// oCi}XN
static const unsigned char bin_mask_table[8] =
	{0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};
//	{0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
	
};
#endif