#ifndef		__T_TYPE_RGBA_H_INCLUDE_
#define		__T_TYPE_RGBA_H_INCLUDE_

#include "template/t_type_upper_template.h"
#include "../common/t_com_operator.h"

namespace t_image_engine{

#define _STRUCT_ARRAY	(5,(t_type_rgba_base,b_,g_,r_,a_))
#include "template/t_type_multiple_template.h"
#undef _STRUCT_ARRAY

// BYTE^
typedef t_type_rgba_base< unsigned char>	t_type_rgba;
// int^
typedef t_type_rgba_base< int >				t_type_irgba;
// unsigned int^
typedef t_type_rgba_base< unsigned int >	t_type_uirgba;
// double^
typedef t_type_rgba_base< double >			t_type_frgba;
// double^
typedef t_type_rgba_base< double >			t_type_drgba;

// RGB
// type_rgba -> type_irgba
template <> 
struct t_type_upper_signed_template <t_type_rgba> {
	typedef t_type_irgba	_T;
	typedef int				_TL;
	inline static void saturate(t_type_rgba* r, const t_type_irgba* v)
	{r->r_ = i2uc(v->r_); r->g_ = i2uc(v->g_); r->b_ = i2uc(v->b_); r->a_ = i2uc(v->a_);}
};

//  type_rgba -> type_uirgba
template <> 
struct t_type_upper_unsigned_template <t_type_rgba> {
	typedef t_type_uirgba	_T;
	typedef unsigned int	_TL;
	inline static void saturate(t_type_rgba* r, const t_type_uirgba* v)
	{r->r_ = ui2uc(v->r_); r->g_ = ui2uc(v->g_); r->b_ = ui2uc(v->b_); r->a_ = ui2uc(v->a_);}
};

}
#endif