#include <boost/preprocessor.hpp>

// struct name
#define _MULTIPLE_STRUCT_NAME \
	BOOST_PP_ARRAY_ELEM(0, _STRUCT_ARRAY)

// menber
#define _CREATE_MEMBER(z,num,data) \
	_T BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY);
#define	_MY_MEMBER \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), _CREATE_MEMBER, _T)

// operator 0 
#define	_CREATE_OPERATOR_0(z,num,data) \
	BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) = data;
#define _MY_OPERATOR_0(n) \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), _CREATE_OPERATOR_0, n)

// operator 1
#define	_CREATE_OPERATOR_1(z,num,data) \
	BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) data rhs;
#define _MY_OPERATOR_1(op) \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), _CREATE_OPERATOR_1, op)

// operator 2
#define	_CREATE_OPERATOR_2(z,num,data) \
	BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) data rhs.BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY);
#define _MY_OPERATOR_2(op) \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), _CREATE_OPERATOR_2, op)

// operator 3
#define	_CREATE_OPERATOR_3(z,num,data) \
	t.BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) = BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) data rhs;
#define _MY_OPERATOR_3(op) \
	_MULTIPLE_STRUCT_NAME t; \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), _CREATE_OPERATOR_3, op) \
	return t;

// min/max
#define _CREATE_MEMBER_LIST(z,num,data) \
	BOOST_PP_ARRAY_ELEM(num, _STRUCT_ARRAY) ,
#define _MY_SORTFUNC(functor) \
	_T array[BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), 1)] = { \
	BOOST_PP_REPEAT_FROM_TO(1, BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), 1), _CREATE_MEMBER_LIST, op) \
	BOOST_PP_ARRAY_ELEM(BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), 1), _STRUCT_ARRAY) }; \
	qsort(array, BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), 1), sizeof(_T), functor); \
	return array[0];

// template
template <typename _T> 
struct _MULTIPLE_STRUCT_NAME
{
	// member type
	typedef _T _SINGLE_T;

	// member num
	enum {_MEMBER_NUM = BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(_STRUCT_ARRAY), 1)};

	// member
	_MY_MEMBER

	// constructor
	_MULTIPLE_STRUCT_NAME<_T>()
		{_MY_OPERATOR_0(0)}
	_MULTIPLE_STRUCT_NAME<_T>(const _MULTIPLE_STRUCT_NAME<_T>& rhs)
		{_MY_OPERATOR_2(=)}
	_MULTIPLE_STRUCT_NAME<_T>(const _T& val)
		{_MY_OPERATOR_0(val)}

	//! = Iy[^
	template <typename _TYPE> inline  _MULTIPLE_STRUCT_NAME<_T>& operator = (const _TYPE& rhs)
		{_MY_OPERATOR_2(=) return *this;}
	//! += Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T>& operator += (const _TYPE& rhs)
		{_MY_OPERATOR_2(+=) return *this;}
	//! -= Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T>& operator -= (const _TYPE& rhs)
		{_MY_OPERATOR_2(-=) return *this;}

	//! /= Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T>& operator /= (const _TYPE& rhs)
		{_MY_OPERATOR_1(/=) return *this;}
	//! /= Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T>& operator *= (const _TYPE& rhs)
		{_MY_OPERATOR_1(*=) return *this;}

	// /Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T> operator / (const _TYPE& rhs) const
		{_MY_OPERATOR_3(/)}
	// *Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T> operator * (const _TYPE& rhs) const 
		{_MY_OPERATOR_3(*)}
	// +Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T> operator + (const _TYPE& rhs) const
		{_MY_OPERATOR_3(+)}
	// -Iy[^
	template <typename _TYPE> inline _MULTIPLE_STRUCT_NAME<_T> operator - (const _TYPE& rhs) const
		{_MY_OPERATOR_3(-)}

	// min
	inline _T min() const
		{_MY_SORTFUNC(comp)}

	// max
	inline _T max() const
		{_MY_SORTFUNC(compr)}

protected:
	// sort function
	inline static int comp(const void *_a, const void *_b)
		{	
			const _T* a = reinterpret_cast<const _T*>(_a); 
			const _T* b = reinterpret_cast<const _T*>(_b); 
			return (*a < *b) ? -1 :((*a > *b) ?  1 : 0);
		}
	inline static int compr(const void *_a, const void *_b)
		{	
			const _T* a = reinterpret_cast<const _T*>(_a); 
			const _T* b = reinterpret_cast<const _T*>(_b); 
			return (*a < *b) ?  1 :((*a > *b) ? -1 : 0);
		}
};