/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#include <core/cpu.h>
#include "asm.h"
#include "constants.h"
#include "pcpu.h"

cpu_id_t
get_cpu_id (void)
{
	return currentcpu->apic_id;
}

bool
cpu_is_bsp(void)
{
	return currentcpu->bsp;
}

void
cpu_relax(void)
{
	asm_pause();
}

void
monitor_size(size_t *max, size_t *min)
{
	u32 a, b, c, d;

	asm_cpuid (5, 0, &a, &b, &c, &d);
	*max = b;
	*min = a;
}

void
setup_monitor (void *addr)
{
	asm_monitor(addr, 0, 0);
}

void 
wait_for_updating ()
{
	asm_mwait(0, 0);
}

void
enable_interrupt(void)
{
	if (currentcpu_available()) {
		if ( --currentcpu->disable_interrupt == 0) {
			asm_sti();
		}
	}
}

void
disable_interrupt(void)
{
	asm_cli();
	if (currentcpu_available()) {
		currentcpu->disable_interrupt++;
	}
}
