/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 */

#include <core/assert.h>
#include <core/cpu.h>
#include <core/printf.h>
#include "asm.h"
#include "constants.h"
#include "pcpu.h"
#include "panic.h"

#if 0
static int support_monitor = 1;
#endif

cpu_id_t
get_cpu_id (void)
{
	if (!currentcpu_available()) {
		return 0;
	}
	return currentcpu->apic_id;
}

bool
cpu_is_bsp(void)
{
	return currentcpu->bsp;
}

void
cpu_relax(void)
{
	asm_pause();
}

#if 0
vmmerr_t
monitor_size(size_t *max, size_t *min)
{
	u32 a, b, c, d;

	if (!support_monitor) {
		if (cpu_is_bsp()) {
			printf("monitor and mwait is not supported\n");
		}
		return 1;
	}
	asm_cpuid (1, 0, &a, &b, &c, &d);
	if ((c & 0x8) == 0) {
		if (cpu_is_bsp()) {
			printf("monitor and mwait is not supported\n");
		}
		support_monitor = 0;
		*max = *min = 0;
		return 1;
	}

	asm_cpuid (5, 0, &a, &b, &c, &d);
	*max = b;
	*min = a;

	return 0;
}

void
setup_monitor (void *addr)
{
	if (!support_monitor) {
		return;
	}
	asm_monitor(addr, 0, 0);
}

void 
wait_for_updating ()
{
	if (!support_monitor) {
		/*
		 * Local apic is not set up yet, so that
		 * we can't wake up even if we execute hlt
		 */
		freeze();
	}
	asm_mwait(0, 0);
}

#endif /* 0 */

void
enable_interrupt(void)
{
	if (currentcpu_available()) {
		ASSERT(currentcpu->disable_interrupt > 0);
		if ( --currentcpu->disable_interrupt == 0) {
			asm_sti();
		}
	} else {
		asm_sti();
	}
}

void
disable_interrupt(void)
{
	asm_cli();
	if (currentcpu_available()) {
		currentcpu->disable_interrupt++;
	}
}
