/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _IO_PIT_REGS_H
#define _IO_PIT_REGS_H

#define PIT_COUNTER_RAIT			1193182 /* HZ */
#define PIT_COUNTER_NUM				3

#define PIT_COUNTER0_ACCESS_IOPORT		0x40
#define PIT_COUNTER1_ACCESS_IOPORT		0x41
#define PIT_COUNTER2_ACCESS_IOPORT		0x42
#define PIT_TCW_REG_IOPORT			0x43
#define  PIT_TCW_REG_MODE_SELECT_MASK		0x0e
#define  PIT_TCW_REG_MODE0			0x00
#define  PIT_TCW_REG_MODE2			0x04
#define  PIT_TCW_REG_MODE2A			0x0c
#define  PIT_TCW_REG_MODE3			0x06
#define  PIT_TCW_REG_RDWR_SELECT_MASK		0x30
#define   PIT_TCW_REG_COUNTER_LATCH_COMMAND	0x00
#define   PIT_TCW_REG_LSB			0x10
#define   PIT_TCW_REG_MSB			0x20
#define   PIT_TCW_REG_LSB_MSB			0x30
#define  PIT_TCW_REG_COUNTER_SELECT_MASK	0xc0
#define  PIT_TCW_REG_COUNTER_SELECT_SHIFT	6
#define   PIT_TCW_REG_COUNTER0			0x00
#define   PIT_TCW_REG_COUNTER1			0x40
#define   PIT_TCW_REG_COUNTER2			0x80
#define   PIT_TCW_REG_READ_BACK_COMMAND		0xc0

#define PIT_NMI_SC_REG_IOPORT			0x61
#define  PIT_NMI_SC_REG_CONTROL_MASK		0x0f
#define  PIT_NMI_SC_REG_CONTROL_COUNTER2_EN	0x01
#define  PIT_NMI_SC_REG_TIMER_COUNTER2		0x20

#endif /* _IO_PIT_REGS_H */
