/*
 * The TaskJuggler Project Management Software
 *
 * Copyright (c) 2001, 2002, 2003, 2004, 2005 by Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id$
 */

#ifndef _ReportManager_h_
#define _ReportManager_h_

#include <list>

#include <qobject.h>
#include <q3ptrlist.h>

#include "ManagedReportInfo.h"

class Q3WidgetStack;
class QString;
class Q3ListViewItem;
class KMainWindow;
class KSelectAction;
class KListView;
class KListViewItem;
class KListViewSearchLine;
class KURL;
class Project;
class Report;
class CoreAttributes;
class Report;
class ManagedReportInfo;

class ReportManager : public QObject
{
    Q_OBJECT
public:
    ReportManager(KMainWindow* mainWindow, Q3WidgetStack* v, KListView* b,
                  KListViewSearchLine* s);
    virtual ~ReportManager();

    void updateReportList(const Project* pr);

    ManagedReportInfo* getCurrentReport() const;

    Q3ListViewItem* getFirstInteractiveReportItem() const;

    Q3WidgetStack* getReportStack() const { return reportStack; }

    void setFocusToReport() const;

    void enableReportActions(bool enable);

    bool generateReport(Q3ListViewItem*);
    bool showReport(Q3ListViewItem*, bool& showReport);
    void showRMBMenu(Q3ListViewItem*, const QPoint&, int, bool& errors,
                     bool& showReport);

    bool isProjectLoaded() const;

    void setLoadingProject(bool lp);

    void clear();

    void print();

    void addReportItem (Report* r, QString currentReport);
    ManagedReportInfo* getMRI(Report* r);
    void setBrowserEntry(KListViewItem* item, Report* r);

signals:
    void signalChangeStatusBar(const QString& text);
    void signalEditCoreAttributes(CoreAttributes* ca);
    void signalEditReport(const Report* report);
    void signalEditFile(const KURL& url);

public slots:
    void zoomIn();
    void zoomOut();
    void zoomTo();
    void updateZoomSelector(const QStringList& items, unsigned int current);
    void closeCurrentReport();
    void changeStatusBar(const QString& text);
    void editCoreAttributes(CoreAttributes* ca);
    void editReport(const Report* report);

private:
    void updateReportBrowser();
    void expandLVI(Q3ListViewItem *lvi, bool opn);
    bool generateReports(Q3ListViewItem *lvi);

    KMainWindow* mainWindow;
    KSelectAction* zoomSelector;

    const Project* project;

    Q3WidgetStack* reportStack;
    KListView* browser;
    KListViewSearchLine* searchLine;

    KListViewItem* qtReports;
    KListViewItem* htmlReports;
    KListViewItem* csvReports;
    KListViewItem* svgReports;
    KListViewItem* xmlReports;
    KListViewItem* icalReports;
    KListViewItem* exportReports;

    std::list<ManagedReportInfo*> reports;

    bool loadingProject;
} ;

#endif

