/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log.adapters.slf4j;

import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLogger;
import org.slf4j.impl.MarkerIgnoringBase;
import org.slf4j.impl.MessageFormatter;

public class Slf4jAdapter
extends MarkerIgnoringBase {
    private final SimpleLogger log;
    private final String loggerName;

    Slf4jAdapter(SimpleLogger simpleLogger, String string) {
        this.log = simpleLogger;
        this.loggerName = string;
    }

    public String getName() {
        return this.loggerName;
    }

    public boolean isErrorEnabled() {
        return this.log.wouldLog(DebugLevel.L2_ERROR);
    }

    public boolean isWarnEnabled() {
        return this.log.wouldLog(DebugLevel.L3_WARN);
    }

    public boolean isInfoEnabled() {
        return this.log.wouldLog(DebugLevel.L4_INFO);
    }

    public boolean isDebugEnabled() {
        return this.log.wouldLog(DebugLevel.L5_DEBUG);
    }

    public void error(String string) {
        this.log.db(DebugLevel.L2_ERROR, string);
    }

    public void error(String string, Object object) {
        if (this.log.wouldLog(DebugLevel.L2_ERROR)) {
            this.log.db(DebugLevel.L2_ERROR, MessageFormatter.format(string, object));
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.log.wouldLog(DebugLevel.L2_ERROR)) {
            this.log.db(DebugLevel.L2_ERROR, MessageFormatter.format(string, object, object2));
        }
    }

    public void error(String string, Object[] objectArray) {
        if (this.log.wouldLog(DebugLevel.L2_ERROR)) {
            this.log.db(DebugLevel.L2_ERROR, MessageFormatter.format(string, objectArray));
        }
    }

    public void error(String string, Throwable throwable) {
        this.log.db(DebugLevel.L2_ERROR, string);
        this.log.dbe(DebugLevel.L2_ERROR, throwable);
    }

    public void warn(String string) {
        this.log.db(DebugLevel.L3_WARN, string);
    }

    public void warn(String string, Object object) {
        if (this.log.wouldLog(DebugLevel.L3_WARN)) {
            this.log.db(DebugLevel.L3_WARN, MessageFormatter.format(string, object));
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.log.wouldLog(DebugLevel.L3_WARN)) {
            this.log.db(DebugLevel.L3_WARN, MessageFormatter.format(string, object, object2));
        }
    }

    public void warn(String string, Object[] objectArray) {
        if (this.log.wouldLog(DebugLevel.L3_WARN)) {
            this.log.db(DebugLevel.L3_WARN, MessageFormatter.format(string, objectArray));
        }
    }

    public void warn(String string, Throwable throwable) {
        this.log.db(DebugLevel.L3_WARN, string);
        this.log.dbe(DebugLevel.L3_WARN, throwable);
    }

    public void info(String string) {
        this.log.db(DebugLevel.L4_INFO, string);
    }

    public void info(String string, Object object) {
        if (this.log.wouldLog(DebugLevel.L4_INFO)) {
            this.log.db(DebugLevel.L4_INFO, MessageFormatter.format(string, object));
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.log.wouldLog(DebugLevel.L4_INFO)) {
            this.log.db(DebugLevel.L4_INFO, MessageFormatter.format(string, object, object2));
        }
    }

    public void info(String string, Object[] objectArray) {
        if (this.log.wouldLog(DebugLevel.L4_INFO)) {
            this.log.db(DebugLevel.L4_INFO, MessageFormatter.format(string, objectArray));
        }
    }

    public void info(String string, Throwable throwable) {
        this.log.db(DebugLevel.L4_INFO, string);
        this.log.dbe(DebugLevel.L4_INFO, throwable);
    }

    public void debug(String string) {
        this.log.db(DebugLevel.L5_DEBUG, string);
    }

    public void debug(String string, Object object) {
        if (this.log.wouldLog(DebugLevel.L5_DEBUG)) {
            this.log.db(DebugLevel.L5_DEBUG, MessageFormatter.format(string, object));
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.log.wouldLog(DebugLevel.L5_DEBUG)) {
            this.log.db(DebugLevel.L5_DEBUG, MessageFormatter.format(string, object, object2));
        }
    }

    public void debug(String string, Object[] objectArray) {
        if (this.log.wouldLog(DebugLevel.L5_DEBUG)) {
            this.log.db(DebugLevel.L5_DEBUG, MessageFormatter.format(string, objectArray));
        }
    }

    public void debug(String string, Throwable throwable) {
        this.log.db(DebugLevel.L5_DEBUG, string);
        this.log.dbe(DebugLevel.L5_DEBUG, throwable);
    }
}

