/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class AddColumnChange
extends TableChangeImplBase {
    private Column _newColumn;
    private String _previousColumnName;
    private String _nextColumnName;

    public AddColumnChange(String tableName, Column newColumn, String previousColumnName, String nextColumnName) {
        super(tableName);
        this._newColumn = newColumn;
        this._previousColumnName = previousColumnName;
        this._nextColumnName = nextColumnName;
    }

    public Column getNewColumn() {
        return this._newColumn;
    }

    public String getPreviousColumn() {
        return this._previousColumnName;
    }

    public String getNextColumn() {
        return this._nextColumnName;
    }

    public boolean isAtEnd() {
        return this._nextColumnName == null;
    }

    @Override
    public void apply(Database model, boolean caseSensitive) {
        Table table = this.findChangedTable(model, caseSensitive);
        Column newColumn = new CloneHelper().clone(this._newColumn, true);
        if (this._previousColumnName != null) {
            Column prevColumn = table.findColumn(this._previousColumnName, caseSensitive);
            int idx = table.getColumnIndex(prevColumn) + 1;
            table.addColumn(idx, newColumn);
        } else if (this._nextColumnName != null) {
            table.addColumn(0, newColumn);
        } else {
            table.addColumn(newColumn);
        }
    }
}

