/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.IndexImplBase;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;

public class CloneHelper {
    public Database clone(Database source) {
        Table sourceTable;
        Database result = new Database();
        result.setName(source.getName());
        result.setIdMethod(source.getIdMethod());
        result.setVersion(source.getVersion());
        int tableIdx = 0;
        while (tableIdx < source.getTableCount()) {
            sourceTable = source.getTable(tableIdx);
            result.addTable(this.clone(sourceTable, true, false, result, true));
            ++tableIdx;
        }
        tableIdx = 0;
        while (tableIdx < source.getTableCount()) {
            sourceTable = source.getTable(tableIdx);
            Table clonedTable = result.getTable(tableIdx);
            int fkIdx = 0;
            while (fkIdx < sourceTable.getForeignKeyCount()) {
                ForeignKey sourceFk = sourceTable.getForeignKey(fkIdx);
                clonedTable.addForeignKey(this.clone(sourceFk, clonedTable, result, true));
                ++fkIdx;
            }
            ++tableIdx;
        }
        return result;
    }

    public Table clone(Table source, boolean cloneIndexes, boolean cloneForeignKeys, Database targetModel, boolean caseSensitive) {
        Table result = new Table();
        result.setCatalog(source.getCatalog());
        result.setSchema(source.getSchema());
        result.setName(source.getName());
        result.setType(source.getType());
        int colIdx = 0;
        while (colIdx < source.getColumnCount()) {
            result.addColumn(this.clone(source.getColumn(colIdx), true));
            ++colIdx;
        }
        if (cloneIndexes) {
            int indexIdx = 0;
            while (indexIdx < source.getIndexCount()) {
                result.addIndex(this.clone(source.getIndex(indexIdx), result, true));
                ++indexIdx;
            }
        }
        if (cloneForeignKeys) {
            int fkIdx = 0;
            while (fkIdx < source.getForeignKeyCount()) {
                result.addForeignKey(this.clone(source.getForeignKey(fkIdx), result, targetModel, caseSensitive));
                ++fkIdx;
            }
        }
        return result;
    }

    public Column clone(Column source, boolean clonePrimaryKeyStatus) {
        Column result = new Column();
        result.setName(source.getName());
        result.setJavaName(source.getJavaName());
        result.setPrimaryKey(clonePrimaryKeyStatus ? source.isPrimaryKey() : false);
        result.setRequired(source.isRequired());
        result.setAutoIncrement(source.isAutoIncrement());
        result.setTypeCode(source.getTypeCode());
        result.setSize(source.getSize());
        result.setDefaultValue(source.getDefaultValue());
        return result;
    }

    public Index clone(Index source, Table targetTable, boolean caseSensitive) {
        IndexImplBase result = source.isUnique() ? new UniqueIndex() : new NonUniqueIndex();
        result.setName(source.getName());
        int colIdx = 0;
        while (colIdx < source.getColumnCount()) {
            IndexColumn column = source.getColumn(colIdx);
            result.addColumn(this.clone(column, targetTable, caseSensitive));
            ++colIdx;
        }
        return result;
    }

    public IndexColumn clone(IndexColumn source, Table targetTable, boolean caseSensitive) {
        IndexColumn result = new IndexColumn();
        result.setColumn(targetTable.findColumn(source.getName(), caseSensitive));
        result.setOrdinalPosition(source.getOrdinalPosition());
        result.setSize(source.getSize());
        return result;
    }

    public ForeignKey clone(ForeignKey source, Table owningTable, Database targetModel, boolean caseSensitive) {
        ForeignKey result = new ForeignKey();
        Table foreignTable = targetModel.findTable(source.getForeignTableName(), caseSensitive);
        result.setName(source.getName());
        result.setForeignTable(foreignTable);
        result.setAutoIndexPresent(source.isAutoIndexPresent());
        result.setOnDelete(source.getOnDelete());
        result.setOnUpdate(source.getOnUpdate());
        int refIdx = 0;
        while (refIdx < source.getReferenceCount()) {
            Reference ref = source.getReference(refIdx);
            result.addReference(this.clone(ref, owningTable, foreignTable, caseSensitive));
            ++refIdx;
        }
        return result;
    }

    public Reference clone(Reference source, Table localTable, Table foreignTable, boolean caseSensitive) {
        Reference result = new Reference();
        result.setLocalColumn(localTable.findColumn(source.getLocalColumnName(), caseSensitive));
        result.setForeignColumn(foreignTable.findColumn(source.getForeignColumnName(), caseSensitive));
        return result;
    }
}

