/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.firebird;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class FirebirdBuilder
extends SqlBuilder {
    public FirebirdBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        super.createTable(database, table, parameters);
        Column[] columns = table.getAutoIncrementColumns();
        int idx = 0;
        while (idx < columns.length) {
            this.writeAutoIncrementCreateStmts(database, table, columns[idx]);
            ++idx;
        }
    }

    @Override
    public void dropTable(Table table) throws IOException {
        Column[] columns = table.getAutoIncrementColumns();
        int idx = 0;
        while (idx < columns.length) {
            this.writeAutoIncrementDropStmts(table, columns[idx]);
            ++idx;
        }
        super.dropTable(table);
    }

    private void writeAutoIncrementCreateStmts(Database database, Table table, Column column) throws IOException {
        this.print("CREATE GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.printEndOfStatement();
        this.print("CREATE TRIGGER ");
        this.printIdentifier(this.getConstraintName("trg", table, column.getName(), null));
        this.print(" FOR ");
        this.printlnIdentifier(this.getTableName(table));
        this.println("ACTIVE BEFORE INSERT POSITION 0 AS");
        this.print("BEGIN IF (NEW.");
        this.printIdentifier(this.getColumnName(column));
        this.print(" IS NULL) THEN NEW.");
        this.printIdentifier(this.getColumnName(column));
        this.print(" = GEN_ID(");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.print(", 1); END");
        this.printEndOfStatement();
    }

    private void writeAutoIncrementDropStmts(Table table, Column column) throws IOException {
        this.print("DROP TRIGGER ");
        this.printIdentifier(this.getConstraintName("trg", table, column.getName(), null));
        this.printEndOfStatement();
        this.print("DROP GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.printEndOfStatement();
    }

    protected String getGeneratorName(Table table, Column column) {
        return this.getConstraintName("gen", table, column.getName(), null);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("SELECT ");
        int idx = 0;
        while (idx < columns.length) {
            result.append("GEN_ID(");
            result.append(this.getDelimitedIdentifier(this.getGeneratorName(table, columns[idx])));
            result.append(", 0)");
            ++idx;
        }
        result.append(" FROM RDB$DATABASE");
        return result.toString();
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    public void createForeignKeys(Database database) throws IOException {
        int idx = 0;
        while (idx < database.getTableCount()) {
            this.createForeignKeys(database, database.getTable(idx));
            ++idx;
        }
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
        if (newColumn.isAutoIncrement()) {
            this.writeAutoIncrementCreateStmts(model, table, newColumn);
        }
    }

    public void insertColumn(Database model, Table table, Column newColumn, Column prevColumn) throws IOException {
        this.addColumn(model, table, newColumn);
        int pos = 1;
        if (prevColumn != null) {
            pos = table.getColumnIndex(prevColumn) + 2;
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ALTER ");
        this.printIdentifier(this.getColumnName(newColumn));
        this.print(" POSITION ");
        this.print(String.valueOf(pos));
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        if (column.isAutoIncrement()) {
            this.writeAutoIncrementDropStmts(table, column);
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            boolean needSubstr;
            boolean bl = needSubstr = TypeMap.isTextType(targetColumn.getTypeCode()) && sizeChanged && targetColumn.getSize() != null && sourceColumn.getSizeAsInt() > targetColumn.getSizeAsInt();
            if (needSubstr) {
                this.print("SUBSTRING(");
            }
            this.print("(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" || '' ");
            if (needSubstr) {
                this.print(") FROM 1 FOR ");
                this.print(targetColumn.getSize());
                this.print(")");
            } else {
                this.print(")");
            }
        } else {
            super.writeCastExpression(sourceColumn, targetColumn);
        }
    }
}

